package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.misc.JunSampleTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;

/**
 * JunOpenGL3dTypicalObjectsMisc class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsMisc.java,v 8.8 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsMisc extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - Anpanman
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Anpanman() {
		JunOpenGL3dTransformedObject baseSphere = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.Ball_(3));
		baseSphere.flushAllPaints();
		JunOpenGL3dTransformedObject baseCube = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.XUnitBox());
		baseCube.flushAllPaints();
		JunOpenGL3dNurbsCurve circle = (JunOpenGL3dNurbsCurve) JunOpenGL3dNurbsCurve.Circle();
		circle.lineWidth_(2f);
		JunOpenGL3dTransformedObject baseCircle = new JunOpenGL3dTransformedObject(circle);
		baseCircle.flushAllPaints();
		JunOpenGL3dObject head = baseSphere.scaledBy_(new Jun3dPoint(0.9, 1, 0.9).multipliedBy_(4));
		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(new Jun3dPoint(0.3, 0.3, 0.5));
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-25));
		leftEye = leftEye.transform_(transformation);
		leftEye = leftEye.translatedBy_(new Jun3dPoint(3.0, 1.1, 1.5));
		JunOpenGL3dObject leftEyebrow = baseCircle.scaledBy_(new Jun3dPoint(0.8, 0.8, 1));
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(70));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-60)));
		leftEyebrow = leftEyebrow.transform_(transformation);
		leftEyebrow = leftEyebrow.translatedBy_(new Jun3dPoint(2.6, 1.3, 1.8));
		JunOpenGL3dObject nose = baseSphere.scaledBy_(new Jun3dPoint(0.8, 1, 0.9).multipliedBy_(1.2));
		nose = nose.translatedBy_(new Jun3dPoint(3.5, 0, 0));
		JunOpenGL3dObject noseLight = baseCube.scaledBy_(0.5);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-20));
		transformation = transformation.product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(15)));
		noseLight = noseLight.transform_(transformation);
		noseLight = noseLight.translatedBy_(new Jun3dPoint(3.9, 0.3, 0.2));
		JunOpenGL3dObject leftCheek = baseSphere.scaledBy_(new Jun3dPoint(0.5, 1, 0.9).multipliedBy_(1.3));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(35));
		leftCheek = leftCheek.transform_(transformation);
		leftCheek = leftCheek.translatedBy_(new Jun3dPoint(2.6, 2.2, 0));
		JunOpenGL3dObject mouth = baseCircle.scaledBy_(new Jun3dPoint(1, 1.5, 0.8));
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		mouth = mouth.transform_(transformation);
		mouth = mouth.translatedBy_(new Jun3dPoint(3.1, 0.0, -1.0));
		JunOpenGL3dObject leftCheekLight = baseCube.scaledBy_(0.5);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-10));
		transformation = transformation.product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(40)));
		leftCheekLight = leftCheekLight.transform_(transformation);
		leftCheekLight = leftCheekLight.translatedBy_(new Jun3dPoint(2.6, 2.5, 0.2));
		JunOpenGL3dObject rightCheekLight = baseCube.scaledBy_(0.5);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-10));
		transformation = transformation.product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(-20)));
		rightCheekLight = rightCheekLight.transform_(transformation);
		rightCheekLight = rightCheekLight.translatedBy_(new Jun3dPoint(3.0, -1.8, 0.2));
		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftEyebrow.paint_(Color.black);
		leftObjects.add_(leftEyebrow);
		leftCheek.paint_(StColorValue.Blend(StColorValue.Orange, Color.red));
		leftObjects.add_(leftCheek);

		JunOpenGL3dCompoundObject anpanman = new JunOpenGL3dCompoundObject();
		anpanman.add_(leftObjects);
		leftObjects.establishAllNormalVectors();
		anpanman.add_(new JunOpenGL3dTransformedObject(leftObjects).transform_(Jun3dTransformation.MirrorY()));
		head.paint_(new Color(0.968624f, 0.580271f, 0.415578f));
		anpanman.add_(head);
		nose.paint_(Color.red);
		anpanman.add_(nose);
		noseLight.paint_(Color.white);
		anpanman.add_(noseLight);
		leftCheekLight.paint_(Color.white);
		anpanman.add_(leftCheekLight);
		rightCheekLight.paint_(Color.white);
		anpanman.add_(rightCheekLight);
		mouth.paint_(Color.black);
		anpanman.add_(mouth);

		Jun3dBoundingBox box = anpanman.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0 / maximum));
		JunOpenGL3dObject anpan = new JunOpenGL3dTransformedObject(anpanman, transformation);
		anpan.name_("anpanman");
		return anpan;
	}

	/**
	 * Typical objects - Aoki
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki() {
		JunOpenGL3dObject anObject = Aoki1();
		anObject.name_("aoki");
		return anObject;
	}

	/**
	 * Typical objects - Aoki1
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki1() {
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball_(3);
		ball.flushAllPaints();
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(ball);
		JunOpenGL3dObject cone = JunOpenGL3dObject.Cone_radius_height_(10, 1, 1);
		cone.flushAllPaints();
		JunOpenGL3dObject baseCone = (new JunOpenGL3dTransformedObject(cone));
		JunOpenGL3dObject hairAndBeard = baseSphere.scaledBy_(4.05);
		hairAndBeard = hairAndBeard.translatedBy_(new Jun3dPoint(-0.115, 0, 0));
		JunOpenGL3dObject face = baseSphere.scaledBy_(4);
		JunOpenGL3dObject leftEar = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, 10, 1, 0.5);
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		leftEar = leftEar.transform_(transformation);
		leftEar = leftEar.translatedBy_(new Jun3dPoint(0, 3.8, -0.5));
		JunOpenGL3dObject leftEyebrow = JunOpenGL3dObject.ChunkOfPieFrom_to_by_radius_thickness_(330, 360, 10, 2.2, 1);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(110));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90)));
		leftEyebrow = leftEyebrow.transform_(transformation);
		leftEyebrow = leftEyebrow.translatedBy_(new Jun3dPoint(3, 0.5, 2));
		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(0.5);
		leftEye = leftEye.translatedBy_(new Jun3dPoint(4, 1.5, 0));
		JunOpenGL3dObject leftEyeLight = baseSphere.scaledBy_(0.25);
		leftEyeLight = leftEyeLight.translatedBy_(new Jun3dPoint(4.23, 1.5, 0.2));
		JunOpenGL3dObject nose = baseCone.scaledBy_(new Jun3dPoint(1, 1, 2));
		nose = nose.translatedBy_(new Jun3dPoint(4, 0, -2));
		JunOpenGL3dObject mustache = baseCone.scaledBy_(new Jun3dPoint(1.5, 1.5, 2));
		mustache = mustache.translatedBy_(new Jun3dPoint(3, 0, -3));
		JunOpenGL3dObject mole = baseSphere.scaledBy_(0.05);
		JunOpenGL3dObject mole1 = mole.translatedBy_(new Jun3dPoint(2.8, 2, -2));
		JunOpenGL3dObject mole2 = mole.translatedBy_(new Jun3dPoint(4.45, -0.15, -1));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEar.paint_(StColorValue.Orange);
		leftObjects.add_(leftEar);
		leftEyebrow.paint_(Color.black);
		leftObjects.add_(leftEyebrow);
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftEyeLight.paint_(Color.white);
		leftObjects.add_(leftEyeLight);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject aoki = new JunOpenGL3dCompoundObject();
		aoki.add_(leftObjects);
		aoki.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		hairAndBeard.paint_(Color.black);
		aoki.add_(hairAndBeard);
		face.paint_(StColorValue.Orange);
		aoki.add_(face);
		nose.paint_(StColorValue.Orange);
		aoki.add_(nose);
		mustache.paint_(Color.black);
		aoki.add_(mustache);
		mole1.paint_(Color.black);
		aoki.add_(mole1);
		mole2.paint_(Color.black);
		aoki.add_(mole2);

		Jun3dBoundingBox box = aoki.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1 / maximum));
		JunOpenGL3dObject aojun = new JunOpenGL3dTransformedObject(aoki, transformation);
		aojun.name_("aoki1");
		return aojun;
	}

	/**
	 * Typical objects - Aoki2
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki2() {
		StImage anImage = JunSampleTriangle.Aoki();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.repeat_(true);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Cube();
		anObject.texture_(aTexture);
		anObject.name_("aoki2");
		return anObject;
	}

	/**
	 * Typical objects - Arowana
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Arowana() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Arowana.lst")));
	}

	/**
	 * Typical objects - axes
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Axes() {
		Jun3dPoint[] twoPoints = new Jun3dPoint[2];
		Jun3dPoint[] fourPoints = new Jun3dPoint[4];
		JunOpenGL3dCompoundObject xAxis = new JunOpenGL3dCompoundObject();
		xAxis.name_("x axis");
		twoPoints[0] = new Jun3dPoint(-1, 0, 0);
		twoPoints[1] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0.05, 0);
		fourPoints[2] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[2] = new Jun3dPoint(0.9, -0.05, 0);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0, 0.05);
		fourPoints[2] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[2] = new Jun3dPoint(0.9, 0, -0.05);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));

		JunOpenGL3dCompoundObject yAxis = new JunOpenGL3dCompoundObject();
		yAxis.name_("y axis");
		twoPoints[0] = new Jun3dPoint(0, -1, 0);
		twoPoints[1] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0.05, 0.9, 0);
		fourPoints[2] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[2] = new Jun3dPoint(-0.05, 0.9, 0);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0, 0.9, 0.05);
		fourPoints[2] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[2] = new Jun3dPoint(0, 0.9, -0.05);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));

		JunOpenGL3dCompoundObject zAxis = new JunOpenGL3dCompoundObject();
		zAxis.name_("z axis");
		twoPoints[0] = new Jun3dPoint(0, 0, -1);
		twoPoints[1] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0.05, 0, 0.9);
		fourPoints[2] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[2] = new Jun3dPoint(-0.05, 0, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0, 0.05, 0.9);
		fourPoints[2] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[2] = new Jun3dPoint(0, -0.05, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));

		JunOpenGL3dCompoundObject axes = new JunOpenGL3dCompoundObject(xAxis, yAxis, zAxis);
		axes.name_("axes");

		return axes;
	}

	/**
	 * Typical objects - axes
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Axes2() {
		Jun3dPoint[] twoPoints = new Jun3dPoint[2];
		Jun3dPoint[] fourPoints = new Jun3dPoint[4];
		JunOpenGL3dCompoundObject xAxis = new JunOpenGL3dCompoundObject();
		xAxis.name_("x axis");
		twoPoints[0] = new Jun3dPoint(0, 0, 0);
		twoPoints[1] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0.05, 0);
		fourPoints[2] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));
		fourPoints[0] = new Jun3dPoint(1, 0, 0);
		fourPoints[1] = new Jun3dPoint(0.9, 0, 0.05);
		fourPoints[2] = new Jun3dPoint(0.9, 0, 0);
		fourPoints[3] = new Jun3dPoint(1, 0, 0);
		xAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.red));

		JunOpenGL3dCompoundObject yAxis = new JunOpenGL3dCompoundObject();
		yAxis.name_("y axis");
		twoPoints[0] = new Jun3dPoint(0, 0, 0);
		twoPoints[1] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0.05, 0.9, 0);
		fourPoints[2] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));
		fourPoints[0] = new Jun3dPoint(0, 1, 0);
		fourPoints[1] = new Jun3dPoint(0, 0.9, 0.05);
		fourPoints[2] = new Jun3dPoint(0, 0.9, 0);
		fourPoints[3] = new Jun3dPoint(0, 1, 0);
		yAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.green));

		JunOpenGL3dCompoundObject zAxis = new JunOpenGL3dCompoundObject();
		zAxis.name_("z axis");
		twoPoints[0] = new Jun3dPoint(0, 0, 0);
		twoPoints[1] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolyline(twoPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0.05, 0, 0.9);
		fourPoints[2] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));
		fourPoints[0] = new Jun3dPoint(0, 0, 1);
		fourPoints[1] = new Jun3dPoint(0, 0.05, 0.9);
		fourPoints[2] = new Jun3dPoint(0, 0, 0.9);
		fourPoints[3] = new Jun3dPoint(0, 0, 1);
		zAxis.add_(new JunOpenGL3dPolygon(fourPoints, Color.blue));

		JunOpenGL3dCompoundObject axes = new JunOpenGL3dCompoundObject(xAxis, yAxis, zAxis);
		axes.name_("axes");

		return axes;
	}

	/**
	 * Typical objects - Baby
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Baby() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Baby.lst")));
	}

	/**
	 * Typical objects - Bell
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Bell() {
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball_(3);
		ball.flushAllPaints();
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(ball);
		JunOpenGL3dObject bellSphere = baseSphere;

		JunOpenGL3dObject bellRing = JunOpenGL3dObject.Torus_radius_(1, 0.2);
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		bellRing = bellRing.transform_(transformation);
		bellRing = bellRing.translatedBy_(new Jun3dPoint(0, 0, 0.2));

		JunOpenGL3dObject bellHole = baseSphere.scaledBy_(0.2);
		bellHole = bellHole.translatedBy_(new Jun3dPoint(0.88, 0, -0.4));

		JunOpenGL3dObject bellHoleLine = JunOpenGL3dObject.SlicedPieFrom_to_by_radius_thickness_(20, 160, 10, 1, 0.1);
		transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-90));
		bellHoleLine = bellHoleLine.transform_(transformation);
		bellHoleLine = bellHoleLine.translatedBy_(new Jun3dPoint(0, 0, -0.04));

		JunOpenGL3dCompoundObject bell = new JunOpenGL3dCompoundObject();
		bellSphere.paint_(Color.yellow);
		bell.add_(bellSphere);
		bellRing.paint_(Color.yellow);
		bell.add_(bellRing);
		bellHole.paint_(Color.black);
		bell.add_(bellHole);
		bellHole.establishAllNormalVectors();
		bell.add_(new JunOpenGL3dTransformedObject(bellHole, Jun3dTransformation.MirrorX()));
		bellHoleLine.paint_(Color.black);
		bell.add_(bellHoleLine);

		Jun3dBoundingBox box = bell.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		bell = new JunOpenGL3dTransformedObject(bell, transformation).asCompoundObject();
		bell.name_("bell");
		return bell;
	}

	/**
	 * Typical objects - Dolphin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Dolphin() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Dolphin.lst")));
	}

	/**
	 * Typical objects - Doraemon
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Doraemon() {
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.Ball_(3));
		baseSphere.flushAllPaints();
		JunOpenGL3dObject baseCircle = new JunOpenGL3dTransformedObject(JunOpenGL3dNurbsCurve.Circle());
		baseCircle.flushAllPaints();
		JunOpenGL3dObject head = baseSphere.scaledBy_(4.5);

		JunOpenGL3dObject leftCheek = baseSphere.scaledBy_(new Jun3dPoint(0.65, 1, 1.1).multipliedBy_(3));
		Jun3dTransformation transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(25));
		transformation = transformation.product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(20)));
		leftCheek = leftCheek.transform_(transformation);
		leftCheek = leftCheek.translatedBy_(new Jun3dPoint(2.25, 1.1, -0.9));

		JunOpenGL3dObject leftEyeRound = baseSphere.scaledBy_(new Jun3dPoint(0.6, 1.2, 1.2));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(15));
		transformation = transformation.product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-30)));
		leftEyeRound = leftEyeRound.transform_(transformation);
		leftEyeRound = leftEyeRound.translatedBy_(new Jun3dPoint(3.5, 1, 2));

		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(0.3);
		leftEye = leftEye.translatedBy_(new Jun3dPoint(4.1, 0.7, 2.2));
		JunOpenGL3dObject nose = baseSphere.scaledBy_(0.7);
		nose = nose.translatedBy_(new Jun3dPoint(4.3, 0, 1));
		JunOpenGL3dObject noseLight = baseSphere.scaledBy_(0.2);
		noseLight = noseLight.translatedBy_(new Jun3dPoint(4.8, 0.2, 1.2));

		JunOpenGL3dObject whisker = baseCircle.scaledBy_(new Jun3dPoint(0.3, 1, 1));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(25));
		JunOpenGL3dObject leftWhisker = whisker.transform_(transformation);
		transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30));
		JunOpenGL3dObject leftWhisker1 = leftWhisker.transform_(transformation);
		leftWhisker1 = leftWhisker1.translatedBy_(new Jun3dPoint(3.95, 2.0, 0.0));
		transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(10));
		JunOpenGL3dObject leftWhisker2 = leftWhisker.transform_(transformation);
		leftWhisker2 = leftWhisker2.translatedBy_(new Jun3dPoint(3.8, 2.1, -0.8));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(35));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-10)));
		JunOpenGL3dObject leftWhisker3 = whisker.transform_(transformation);
		leftWhisker3 = leftWhisker3.translatedBy_(new Jun3dPoint(3.5, 2.2, -1.6));

		JunOpenGL3dObject mouth = baseCircle.scaledBy_(new Jun3dPoint(1, 2.0, 1));
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		mouth = mouth.transform_(transformation);
		mouth = mouth.translatedBy_(new Jun3dPoint(3.7, 0, -1.9));

		JunOpenGL3dObject centerLine = baseCircle.scaledBy_(new Jun3dPoint(0.9, 2, 2));
		transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90));
		transformation = transformation.product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(20)));
		centerLine = centerLine.transform_(transformation);
		centerLine = centerLine.translatedBy_(new Jun3dPoint(3.6, 0, -1.2));

		double x = 0.3;
		double y = 3.2;
		double width = 0.7;
		Jun2dPoint[] arrayOfPoints = new Jun2dPoint[] { new Jun2dPoint(-x, y - width), new Jun2dPoint(-x, y), new Jun2dPoint(x, y), new Jun2dPoint(x, y - width) };
		JunOpenGL3dObject collar = Rotate_divisions_(arrayOfPoints, 18);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		collar = collar.transform_(transformation);
		collar = collar.translatedBy_(new Jun3dPoint(0, 0, -4.0));

		JunOpenGL3dObject bell = JunOpenGL3dObject.Bell();
		bell = bell.scaledBy_(1.5);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-30));
		bell = bell.transform_(transformation);
		bell = bell.translatedBy_(new Jun3dPoint(3.5, 0, -4.3));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftCheek.paint_(Color.white);
		leftObjects.add_(leftCheek);
		leftEyeRound.paint_(Color.white);
		leftObjects.add_(leftEyeRound);
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftWhisker1.paint_(Color.black);
		leftObjects.add_(leftWhisker1);
		leftWhisker2.paint_(Color.black);
		leftObjects.add_(leftWhisker2);
		leftWhisker3.paint_(Color.black);
		leftObjects.add_(leftWhisker3);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject dora = new JunOpenGL3dCompoundObject();
		dora.add_(leftObjects);
		dora.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		dora.add_(bell);
		head.paint_(Color.blue);
		dora.add_(head);
		nose.paint_(Color.red);
		dora.add_(nose);
		noseLight.paint_(Color.white);
		dora.add_(noseLight);
		mouth.paint_(Color.red);
		dora.add_(mouth);
		centerLine.paint_(StColorValue.LightGray);
		dora.add_(centerLine);
		collar.paint_(Color.red);
		dora.add_(collar);

		Jun3dBoundingBox box = dora.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject doraemon = new JunOpenGL3dTransformedObject(dora, transformation);
		doraemon.name_("doraemon");
		return doraemon;
	}

	/**
	 * Typical objects - Earl
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Earl() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Earl.lst")));
	}

	/**
	 * typical objects misc
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Eddy() {
		Vector collection = new Vector();
		Jun3dPoint[] triangle = new Jun3dPoint[3];
		Jun3dPoint[] triangle1 = new Jun3dPoint[3];
		triangle[0] = new Jun3dPoint(1.0, 1.0, 0.0);
		triangle[1] = new Jun3dPoint(-1.0, 1.0, 0.0);
		triangle[2] = new Jun3dPoint(-1.0, -1.0, 0.0);
		Jun3dTransformation translationT1 = Jun3dTransformation.Translate_(new Jun3dPoint(0.5, 0.1, 0.0));
		Jun3dTransformation yRotationT1 = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(10.0));
		triangle1 = triangle;
		for (int i = 0; i < 100; i++) {
			Color color = JunOpenGL3dObject.SampleColor();
			StAssociation assoc = new StAssociation(color, triangle1.clone());
			collection.addElement(assoc);
			for (int j = 0; j < triangle1.length; j++) {
				Jun3dPoint point = triangle1[j];
				point = (point.transform_(translationT1)).transform_(yRotationT1);
				triangle1[j] = point;
			}
		}

		JunOpenGL3dCompoundObject eddy = new JunOpenGL3dCompoundObject();
		eddy.name_("eddy");

		for (Enumeration e = collection.elements(); e.hasMoreElements();) {
			JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
			StAssociation assoc = (StAssociation) e.nextElement();
			Color color = (Color) assoc.key();
			Jun3dPoint[] points = (Jun3dPoint[]) assoc.value();
			Jun3dPoint[] points2 = new Jun3dPoint[points.length + 1];
			for (int i = 0; i < points.length; i++) {
				points2[i] = points[i];
			}
			points2[points.length] = points[0];
			body.add_(new JunOpenGL3dPolygon(points, color));
			body.add_(new JunOpenGL3dPolyline(points2, Color.black));
			eddy.add_(body);
		}

		return eddy;
	}

	/**
	 * Typical objects - Hand
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Hand() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Hand.lst")));
	}

	/**
	 * Typical object - Mickey
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey() {
		JunOpenGL3dObject anObject = Mickey3();
		anObject.name_("mickey");
		return anObject;
	}

	/**
	 * Typical object - Mickey1
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey1() {
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball_(3);
		ball.flushAllPaints();
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(ball);
		JunOpenGL3dObject head = baseSphere.scaledBy_(4);

		JunOpenGL3dObject leftEar = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, 10, 2.5, 0.5);
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		leftEar = leftEar.transform_(transformation);
		leftEar = leftEar.translatedBy_(new Jun3dPoint(-1, 3.5, 5));

		JunOpenGL3dObject leftEyeRound = baseSphere.scaledBy_(new Jun3dPoint(1, 1, 1.2).multipliedBy_(3.05));
		leftEyeRound = leftEyeRound.translatedBy_(new Jun3dPoint(1, 0.5, 0));

		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(new Jun3dPoint(1, 1, 3).multipliedBy_(0.5));
		leftEye = leftEye.translatedBy_(new Jun3dPoint(3.6, 1.1, 0.2));

		JunOpenGL3dObject cheek = baseSphere.scaledBy_(new Jun3dPoint(1, 1, 0.5).multipliedBy_(3.5));
		cheek = cheek.translatedBy_(new Jun3dPoint(1, 0, -2));

		JunOpenGL3dObject nose = baseSphere.scaledBy_(new Jun3dPoint(1, 1.5, 0.5));
		nose = nose.translatedBy_(new Jun3dPoint(4, 0, -1.5));

		JunOpenGL3dObject leftBow = JunOpenGL3dObject.Cone_radius_height_(10, 1, 2);
		transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90));
		leftBow = leftBow.transform_(transformation);
		leftBow = leftBow.translatedBy_(new Jun3dPoint(3, 1.5, -4.5));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEar.paint_(Color.black);
		leftObjects.add_(leftEar);
		leftEyeRound.paint_(Color.white);
		leftObjects.add_(leftEyeRound);
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftBow.paint_(Color.red);
		leftObjects.add_(leftBow);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject mickey = new JunOpenGL3dCompoundObject();
		mickey.add_(leftObjects);
		mickey.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		head.paint_(Color.black);
		mickey.add_(head);
		cheek.paint_(Color.white);
		mickey.add_(cheek);
		nose.paint_(Color.black);
		mickey.add_(nose);

		Jun3dBoundingBox box = mickey.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject mickeyMouse = new JunOpenGL3dTransformedObject(mickey, transformation);
		mickeyMouse.name_("mickey1");
		return mickeyMouse;
	}

	/**
	 * Typical object - Mickey3
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey3() {
		JunOpenGL3dObject leftBow = JunOpenGL3dObject.Cone_radius_height_(10, 0.07, 0.14);
		Jun3dTransformation transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90));
		leftBow = leftBow.transform_(transformation);
		leftBow = leftBow.translatedBy_(new Jun3dPoint(0.15, 0.1, -0.4));
		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftBow.paint_(Color.yellow);
		leftObjects.add_(leftBow);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject mickey = new JunOpenGL3dCompoundObject();
		mickey.add_(leftObjects);
		mickey.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		mickey.add_(JunOpenGL3dObject.Mouse());

		Jun3dBoundingBox box = mickey.boundingBox();
		double maximum = Math.max(box.width(), (Math.max(box.height(), box.depth())));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject mickey2 = new JunOpenGL3dTransformedObject(mickey, transformation);
		mickey2.name_("mickey3");
		return mickey2;
	}

	/**
	 * Typical object - Minnie
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Minnie() {
		JunOpenGL3dCompoundObject lashes = new JunOpenGL3dCompoundObject();
		JunOpenGL3dPolyline leftLashePolyline = new JunOpenGL3dPolyline(new Jun3dPoint[] { new Jun3dPoint(0, -0.03, 0), new Jun3dPoint(0, 0.03, 0) });
		leftLashePolyline.lineWidth_(0.1f);
		lashes.add_(leftLashePolyline);
		for (double each = -0.02; each <= 0.02; each = each + 0.02) {
			leftLashePolyline = new JunOpenGL3dPolyline(new Jun3dPoint[] { new Jun3dPoint(0, each, 0), new Jun3dPoint(0, each, 0.06) });
			leftLashePolyline.lineWidth_(0.1f);
			lashes.add_(leftLashePolyline);
		}
		Jun3dTransformation transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-15));
		JunOpenGL3dObject leftLashes = lashes.transform_(transformation);
		leftLashes = leftLashes.translatedBy_(new Jun3dPoint(0.2, 0.085, 0.035));

		JunOpenGL3dObject leftRibbon = JunOpenGL3dObject.ChunkOfPieFrom_to_by_radius_thickness_(70, 140, 10, 0.21, 0.07);
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		leftRibbon = leftRibbon.transform_(transformation);
		leftRibbon = leftRibbon.translatedBy_(new Jun3dPoint(-0.1, 0, 0.2));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftLashes.paint_(Color.black);
		leftObjects.add_(leftLashes);
		leftRibbon.paint_(Color.red);
		leftObjects.add_(leftRibbon);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject minnie = new JunOpenGL3dCompoundObject();
		minnie.add_(leftObjects);
		minnie.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		minnie.add_(JunOpenGL3dObject.Mouse());

		Jun3dBoundingBox box = minnie.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject minnieMouse = new JunOpenGL3dTransformedObject(minnie, transformation);
		minnieMouse.name_("minnie");
		return minnieMouse;
	}

	/**
	 * Typical object - Mouse
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mouse() {
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball_(3);
		ball.flushAllPaints();
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(ball);
		JunOpenGL3dObject head = baseSphere.scaledBy_(4);

		JunOpenGL3dObject leftEar = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, 10, 2.5, 0.5);
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		leftEar = leftEar.transform_(transformation);
		leftEar = leftEar.translatedBy_(new Jun3dPoint(-1, 4.5, 4));

		JunOpenGL3dObject leftEyeRound = baseSphere.scaledBy_(3.05);
		leftEyeRound = leftEyeRound.scaledBy_(new Jun3dPoint(1, 1, 1.2));
		leftEyeRound = leftEyeRound.translatedBy_(new Jun3dPoint(1, 0.5, 0));

		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(new Jun3dPoint(1, 1, 3).multipliedBy_(0.5));
		leftEye = leftEye.translatedBy_(new Jun3dPoint(3.6, 1.1, 0.2));

		JunOpenGL3dObject leftCheek = baseSphere.scaledBy_(new Jun3dPoint(0.8, 0.6, 1).multipliedBy_(3));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(-10));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-60)));
		leftCheek = leftCheek.transform_(transformation);
		leftCheek = leftCheek.translatedBy_(new Jun3dPoint(1.5, 1, -2));

		JunOpenGL3dObject noseRound = baseSphere.scaledBy_(new Jun3dPoint(1, 1.1, 0.7).multipliedBy_(2));
		noseRound = noseRound.translatedBy_(new Jun3dPoint(3, 0, -2));

		JunOpenGL3dObject nose = baseSphere.scaledBy_(new Jun3dPoint(1, 1, 0.9));
		nose = nose.translatedBy_(new Jun3dPoint(4.8, 0, -1.5));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEar.paint_(Color.black);
		leftObjects.add_(leftEar);
		leftEyeRound.paint_(Color.white);
		leftObjects.add_(leftEyeRound);
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftCheek.paint_(Color.white);
		leftObjects.add_(leftCheek);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject mouse = new JunOpenGL3dCompoundObject();
		mouse.add_(leftObjects);
		mouse.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		head.paint_(Color.black);
		mouse.add_(head);
		noseRound.paint_(Color.white);
		mouse.add_(noseRound);
		nose.paint_(Color.black);
		mouse.add_(nose);

		Jun3dBoundingBox box = mouse.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject mickyMouse = new JunOpenGL3dTransformedObject(mouse, transformation);
		mickyMouse.name_("mouse");
		return mickyMouse;
	}

	/**
	 * Typical objects - Oni
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Oni() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Oni.lst")));
	}

	/**
	 * Typical objects - Panda
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Panda() {
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.Ball_(3));
		baseSphere.flushAllPaints();
		JunOpenGL3dObject head = baseSphere.scaledBy_(4);
		JunOpenGL3dObject leftEar = baseSphere.scaledBy_(new Jun3dPoint(0.5, 1.2, 1.2));
		leftEar = leftEar.translatedBy_(new Jun3dPoint(-1, 3.3, 3.0));
		JunOpenGL3dObject leftEyeRound = baseSphere.scaledBy_(new Jun3dPoint(0.4, 1.0, 1.2));
		Jun3dTransformation transformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30));
		transformation = transformation.product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(10)));
		transformation = transformation.product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(20)));
		leftEyeRound = leftEyeRound.transform_(transformation);
		leftEyeRound = leftEyeRound.translatedBy_(new Jun3dPoint(3.5, 1.6, -0.4));
		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(new Jun3dPoint(0.2, 0.3, 0.3));
		leftEye = leftEye.translatedBy_(new Jun3dPoint(3.8, 1.6, 0.2));
		JunOpenGL3dObject leftEyeLight = baseSphere.scaledBy_(new Jun3dPoint(0.2, 0.3, 0.3).multipliedBy_(0.8));
		leftEyeLight = leftEyeLight.translatedBy_(leftEye.center().plus_(new Jun3dPoint(0.1, 0, 0.05)));
		JunOpenGL3dObject noseRound = baseSphere.scaledBy_(1.8);
		noseRound = noseRound.translatedBy_(new Jun3dPoint(3.2, 0, -1.1));
		JunOpenGL3dObject nose = baseSphere.scaledBy_(new Jun3dPoint(0.5, 0.7, 0.5));
		nose = nose.translatedBy_(new Jun3dPoint(4.8, 0, -0.5));
		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEar.paint_(Color.black);
		leftObjects.add_(leftEar);
		leftEyeRound.paint_(Color.black);
		leftObjects.add_(leftEyeRound);
		leftEye.paint_(Color.white);
		leftObjects.add_(leftEye);
		leftEyeLight.paint_(Color.black);
		leftObjects.add_(leftEyeLight);

		JunOpenGL3dCompoundObject panda = new JunOpenGL3dCompoundObject();
		panda.add_(leftObjects);
		leftObjects.establishAllNormalVectors();
		panda.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		head.paint_(Color.white);
		panda.add_(head);
		noseRound.paint_(Color.white);
		panda.add_(noseRound);
		nose.paint_(Color.black);
		panda.add_(nose);

		Jun3dBoundingBox box = panda.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(box.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject aPanda = new JunOpenGL3dTransformedObject(panda, transformation);
		aPanda.name_("panda");
		return aPanda;
	}

	/**
	 * Typical objects - Panda2
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Panda2() {
		JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
		JunOpenGL3dObject head = JunOpenGL3dObject.Panda();
		JunOpenGL3dObject hemisphere = JunOpenGL3dObject.Hemisphere_redius_center_(15, 0.4, new Jun3dPoint(0, 0, 0));
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball();
		Jun3dTransformation aTransformation = JunAngle.FromDeg_(90).transformationToRotateX().product_(new Jun3dPoint(1, 1, 1.3).transformationToScale().product_(new Jun3dPoint(-0.2, 0, -0.6).transformationToTranslate()));
		JunOpenGL3dObject breast = hemisphere.transform_(aTransformation);
		aTransformation = JunAngle.FromDeg_(-90).transformationToRotateX().product_(new Jun3dPoint(1, 1, 0.8).multipliedBy_(0.43).transformationToScale().product_(new Jun3dPoint(-0.19, 0, -0.7).transformationToTranslate()));
		JunOpenGL3dObject stomach = ball.transform_(aTransformation);
		aTransformation = new Jun3dPoint(2, 0.8, 1).multipliedBy_(0.15).transformationToScale().product_(
				JunAngle.FromDeg_(20).transformationToRotateY().product_(JunAngle.FromDeg_(20).transformationToRotateZ()).product_(new Jun3dPoint(0, 0.4, -0.5).transformationToTranslate()));
		JunOpenGL3dObject leftArm = ball.transform_(aTransformation);
		aTransformation = new Jun3dPoint(2, 0.8, 1).multipliedBy_(0.15).transformationToScale().product_(
				JunAngle.FromDeg_(20).transformationToRotateY().product_(JunAngle.FromDeg_(-20).transformationToRotateZ()).product_(new Jun3dPoint(0, -0.4, -0.5).transformationToTranslate()));
		JunOpenGL3dObject rightArm = ball.transform_(aTransformation);
		aTransformation = new Jun3dPoint(1.6, 0.9, 1).multipliedBy_(0.15).transformationToScale().product_(
				JunAngle.FromDeg_(10).transformationToRotateY().product_(JunAngle.FromDeg_(30).transformationToRotateZ()).product_(new Jun3dPoint(0, 0.4, -0.85).transformationToTranslate()));
		JunOpenGL3dObject leftLeg = ball.transform_(aTransformation);
		aTransformation = new Jun3dPoint(1.6, 0.9, 1).multipliedBy_(0.15).transformationToScale().product_(
				JunAngle.FromDeg_(10).transformationToRotateY().product_(JunAngle.FromDeg_(-30).transformationToRotateZ()).product_(new Jun3dPoint(0, -0.4, -0.85).transformationToTranslate()));
		JunOpenGL3dObject rightLeg = ball.transform_(aTransformation);
		aTransformation = new Jun3dPoint(0.1, 0.1, 0.1).transformationToScale().product_(new Jun3dPoint(-0.6, 0, -0.8).transformationToTranslate());
		JunOpenGL3dObject tail = ball.transform_(aTransformation);

		body.add_(head);
		breast.paint_(Color.black);
		body.add_(breast);
		stomach.paint_(Color.white);
		body.add_(stomach);
		leftArm.paint_(Color.black);
		body.add_(leftArm);
		rightArm.paint_(Color.black);
		body.add_(rightArm);
		leftLeg.paint_(Color.black);
		body.add_(leftLeg);
		rightLeg.paint_(Color.black);
		body.add_(rightLeg);
		tail.paint_(Color.white);
		body.add_(tail);

		return body;
	}

	/**
	 * Typical objects - Penguin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Penguin() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Penguin.lst")));
	}

	/**
	 * Typical object - Pooh
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Pooh() {
		JunOpenGL3dObject ball = JunOpenGL3dObject.Ball_(3);
		ball.flushAllPaints();
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(ball);
		JunOpenGL3dObject pie = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, 10, 1, 1);
		pie.flushAllPaints();
		JunOpenGL3dTransformedObject basePie = new JunOpenGL3dTransformedObject(pie);
		JunOpenGL3dObject circle = JunOpenGL3dNurbsCurve.Circle();
		circle.flushAllPaints();
		JunOpenGL3dObject baseCircle = new JunOpenGL3dTransformedObject(circle);
		JunOpenGL3dObject head = baseSphere.scaledBy_(4);

		JunOpenGL3dObject leftEar = basePie.scaledBy_(new Jun3dPoint(1.2, 1.2, 0.5));
		Jun3dTransformation transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		leftEar = leftEar.transform_(transformation);
		leftEar = leftEar.translatedBy_(new Jun3dPoint(-1, 3.2, 3.5));

		JunOpenGL3dObject leftEye = baseSphere.scaledBy_(0.4);
		leftEye = leftEye.translatedBy_(new Jun3dPoint(3.6, 1.6, -0.4));

		JunOpenGL3dObject leftEyebrow = baseCircle.scaledBy_(new Jun3dPoint(0.8, 1, 1));
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(70));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-60)));
		leftEyebrow = leftEyebrow.transform_(transformation);
		leftEyebrow = leftEyebrow.translatedBy_(new Jun3dPoint(2.8, 1.7, 1.7));

		JunOpenGL3dObject leftCheek = baseSphere.scaledBy_(new Jun3dPoint(0.9, 0.7, 1).multipliedBy_(3));
		transformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(-10));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-60)));
		leftCheek = leftCheek.transform_(transformation);
		leftCheek = leftCheek.translatedBy_(new Jun3dPoint(1.3, 1, -2));

		JunOpenGL3dObject noseRound = baseSphere.scaledBy_(new Jun3dPoint(1, 1.1, 0.9).multipliedBy_(2));
		noseRound = noseRound.translatedBy_(new Jun3dPoint(3, 0, -1.8));

		JunOpenGL3dObject nose = baseSphere.scaledBy_(new Jun3dPoint(0.8, 1, 0.9).multipliedBy_(0.8));
		nose = nose.translatedBy_(new Jun3dPoint(4.8, 0, -1.3));

		JunOpenGL3dObject tongue = basePie.scaledBy_(new Jun3dPoint(1, 0.7, 0.39));
		transformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(20));
		transformation = transformation.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(210)));
		tongue = tongue.transform_(transformation);
		tongue = tongue.translatedBy_(new Jun3dPoint(3.7, 1, -2.9));

		JunOpenGL3dCompoundObject leftObjects = new JunOpenGL3dCompoundObject();
		leftEar.paint_(StColorValue.Orange);
		leftObjects.add_(leftEar);
		leftEye.paint_(Color.black);
		leftObjects.add_(leftEye);
		leftEyebrow.paint_(Color.black);
		leftObjects.add_(leftEyebrow);
		leftCheek.paint_(StColorValue.Orange);
		leftObjects.add_(leftCheek);
		leftObjects.establishAllNormalVectors();

		JunOpenGL3dCompoundObject pooh = new JunOpenGL3dCompoundObject();
		pooh.add_(leftObjects);
		pooh.add_(new JunOpenGL3dTransformedObject(leftObjects, Jun3dTransformation.MirrorY()));
		head.paint_(StColorValue.Orange);
		pooh.add_(head);
		noseRound.paint_(StColorValue.Orange);
		pooh.add_(noseRound);
		nose.paint_(Color.black);
		pooh.add_(nose);
		tongue.paint_(Color.red);
		pooh.add_(tongue);

		Jun3dBoundingBox box = pooh.boundingBox();
		double maximum = Math.max(box.width(), Math.max(box.height(), box.depth()));
		transformation = Jun3dTransformation.Translate_(pooh.center().negated());
		transformation = transformation.product_(Jun3dTransformation.Scale_(1.0d / maximum));
		JunOpenGL3dObject thePooh = new JunOpenGL3dTransformedObject(pooh, transformation);
		thePooh.name_("pooh");
		return thePooh;
	}

	/**
	 * Typical objects - Raptor
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Raptor() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Raptor.lst")));
	}

	/**
	 * Typical object - Smalltalk.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Smalltalk() {
		return SmalltalkCube();
	}

	/**
	 * Typical object - Smalltalk Cube.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject SmalltalkCube() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.repeat_(true);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.texture_(aTexture);
		aCube.name_("smalltalk cube");
		return aCube;
	}

	/**
	 * Typical object - Smalltalk Plane.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject SmalltalkPlane() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.repeat_(true);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(0, 1, 0) });
		aPolygon.paint_(Color.white);
		aPolygon.texture_(aTexture);
		aPolygon.name_("smalltalk plane");
		return aPolygon;
	}

	/**
	 * typical objects misc
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Stack() {
		JunOpenGL3dCompoundObject stack = new JunOpenGL3dCompoundObject();
		stack.name_("stack");

		Jun3dPoint[] polyline = { new Jun3dPoint(-1, -1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(1, -1, 0) };
		for (float i = 0; i < 5; i += 0.5) {
			Color color = JunOpenGL3dObject.SampleColor();
			Jun3dPoint[] points = new Jun3dPoint[polyline.length];
			for (int j = 0; j < polyline.length; j++) {
				points[j] = new Jun3dPoint(polyline[j].x(), polyline[j].y(), i * -1);
			}
			Jun3dPoint[] points2 = new Jun3dPoint[points.length + 1];
			for (int j = 0; j < points.length; j++) {
				points2[j] = points[j];
			}
			points2[points.length] = points[0];
			JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
			body.add_(new JunOpenGL3dPolygon(points, color));
			body.add_(new JunOpenGL3dPolyline(points2, Color.black));
			stack.add_(body);
		}

		for (float i = 0; i < 5; i += 0.5) {
			Color color = JunOpenGL3dObject.SampleColor();
			Jun3dPoint[] points = new Jun3dPoint[polyline.length];
			for (int j = 0; j < polyline.length; j++) {
				points[j] = new Jun3dPoint(polyline[j].x(), polyline[j].y(), i);
			}
			Jun3dPoint[] points2 = new Jun3dPoint[points.length + 1];
			for (int j = 0; j < points.length; j++) {
				points2[j] = points[j];
			}
			points2[points.length] = points[0];
			JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
			body.add_(new JunOpenGL3dPolygon(points, color));
			body.add_(new JunOpenGL3dPolyline(points2, Color.black));
			stack.add_(body);
		}

		return stack;
	}

	/**
	 * Typical objects - Torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Torus() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Torus.lst")));
	}

	/**
	 * Typical objects - Triple Ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Triball() {
		JunOpenGL3dObject aBall = JunOpenGL3dObject.Ball_(2);
		aBall.paint_(StColorValue.Blend(Color.blue, Color.white));
		aBall = aBall.transform_(Jun3dTransformation.Translate_(new Jun3dPoint(0.75, 0, 0)));
		JunOpenGL3dCompoundObject displayObject = new JunOpenGL3dCompoundObject();
		for (int i = 60; i <= 360; i += 120) {
			Jun3dTransformation aT = Jun3dTransformation.Rotate_(JunAngle.FromDeg_(i));
			displayObject.add_(aBall.transform_(aT));
		}
		displayObject.name_("tripleBall");
		return displayObject;
	}

	/**
	 * Typical objects - Wasp
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Wasp() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Wasp.lst")));
	}

	/**
	 * Typical objects - Wyvern
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Wyvern() {
		return JunOpenGL3dObject.LoadFrom_(Read(Object.class.getResource("/jp/co/sra/jun/opengl/objects/typical/Wyvern.lst")));
	}

	/**
	 * Read the content of the specified URL.
	 * 
	 * @param aURL java.net.URL
	 * @return java.lang.String
	 * @category Private
	 */
	private static String Read(URL aURL) {
		StringWriter writer = new StringWriter();
		try {
			InputStream input = aURL.openStream();
			int ch;
			while ((ch = input.read()) > 0) {
				writer.write(ch);
			}
		} catch (IOException e) {
		}
		return writer.toString();
	}
}
