package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.awt.Dimension;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;

/**
 * JunOpenGL3dTypicalObjectsImage class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsImage.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsImage extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - image earth
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageEarth() {
		return new StImage(JunOpenGLTextureTestExamples.ImageEarth2());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageBMWC() {
		return ImageBMWC_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageBMWC_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(((Number) y).floatValue(), ((Number) x).floatValue(), 1.0f);
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageGCWY() {
		return ImageGCWY_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageGCWY_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(((Number) x).floatValue(), 1.0f, ((Number) y).floatValue());
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKBCG() {
		return ImageKBCG_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKBCG_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(0.0f, ((Number) x).floatValue(), ((Number) y).floatValue());
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKGYR() {
		return ImageKGYR_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKGYR_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(((Number) x).floatValue(), ((Number) y).floatValue(), 0.0f);
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKRMB() {
		return ImageKRMB_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKRMB_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(((Number) y).floatValue(), 0.0f, ((Number) x).floatValue());
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRBBR() {
		return ImageRBBR_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRBBR_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return Color.getHSBColor(((Number) x).floatValue(), 1.0f, 1.0f - ((Number) y).floatValue());
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRGBR() {
		return ImageRGBR_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRGBR_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				Jun2dPoint aPoint = new Jun2dPoint(((Number) x).doubleValue() - 0.5, ((Number) y).doubleValue() - 0.5);
				double aHue = Math.toDegrees(aPoint.theta()) / 360.0d;
				double aSaturation = aPoint.r() / 0.5;
				return Color.getHSBColor((float) aHue, Math.min((float) aSaturation, 1.0f), 1.0f);
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRYWM() {
		return ImageRYWM_(DefaultImageSize());
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRYWM_(int imageSize) {
		return ImageSize_colorBlock_(new Dimension(imageSize, imageSize), new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Color(1, ((Number) y).floatValue(), ((Number) x).floatValue());
			}
		});
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize java.awt.Dimension
	 * @param colorBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Typical objects image
	 */
	protected static StImage ImageSize_colorBlock_(Dimension imageSize, StBlockClosure colorBlock) {
		final StImage anImage = new StImage(imageSize.width, imageSize.height);
		int divisionSize = Math.min(anImage.width(), anImage.height());
		final StInterval[] xIntervals = (new JunImageAdjuster()).computeIntervals_divisionSize_(anImage.width(), divisionSize);
		final StInterval[] yIntervals = (new JunImageAdjuster()).computeIntervals_divisionSize_(anImage.height(), divisionSize);
		int xHowMany = xIntervals.length - 1;
		int yHowMany = yIntervals.length - 1;
		for (int y = 0; y <= yHowMany; y++) {
			int j = y;
			for (int x = 0; x <= xHowMany; x++) {
				final int i = x;
				Color colorValue = (Color) colorBlock.value_value_(new Float(x / (float) xHowMany), new Float(y / (float) yHowMany));
				final int colorIndex = colorValue.getRGB();
				yIntervals[j].do_(new StBlockClosure() {
					public Object value_(final Object n) {
						xIntervals[i].do_(new StBlockClosure() {
							public Object value_(Object m) {
								anImage.setPixel(((Number) m).intValue(), ((Number) n).intValue(), colorIndex);
								return null;
							}
						});
						return null;
					}
				});
			}
		}
		return anImage;
	}
}
