package jp.co.sra.jun.opengl.objects.typical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject;

/**
 * JunOpenGL3dTypicalObjectsHedron class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsHedron.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsHedron extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - cuboctahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject Cuboctahedron() {
		Jun3dPoint p01 = new Jun3dPoint(1, 0, 1);
		Jun3dPoint p02 = new Jun3dPoint(0, 1, 1);
		Jun3dPoint p03 = new Jun3dPoint(-1, 0, 1);
		Jun3dPoint p04 = new Jun3dPoint(0, -1, 1);
		Jun3dPoint p05 = new Jun3dPoint(1, -1, 0);
		Jun3dPoint p06 = new Jun3dPoint(1, 1, 0);
		Jun3dPoint p07 = new Jun3dPoint(-1, 1, 0);
		Jun3dPoint p08 = new Jun3dPoint(-1, -1, 0);
		Jun3dPoint p09 = new Jun3dPoint(1, 0, -1);
		Jun3dPoint p10 = new Jun3dPoint(0, 1, -1);
		Jun3dPoint p11 = new Jun3dPoint(-1, 0, -1);
		Jun3dPoint p12 = new Jun3dPoint(0, -1, -1);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p02, p03, p04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p05, p01, p04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p06, p02, p01 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p07, p03, p02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p08, p04, p03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p12, p11, p10, p09 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p05, p12, p09 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p06, p09, p10 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p07, p10, p11 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p08, p11, p12 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p05, p09, p06 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p02, p06, p10, p07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p03, p07, p11, p08 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p04, p08, p12, p05 }));

		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject cuboctahedron = compoundObject.scaledBy_(scaleFactor);
		cuboctahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		cuboctahedron.flushAllPaints();
		cuboctahedron.paint_(DefaultPaint());
		cuboctahedron.name_("cuboctahedron");
		return cuboctahedron;
	}

	/**
	 * Typical objects - icosidodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject Icosidodecahedron() {
		JunAngle angle1 = JunAngle.FromDeg_(31.717474411461d);
		JunAngle angle2 = JunAngle.FromDeg_(36);
		Jun3dPoint a00 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint a01 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(1)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a02 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(2)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a03 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(3)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a04 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(4)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a05 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(5)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a06 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(6)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a07 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(7)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a08 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(8)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint a09 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(9)).product_(Jun3dTransformation.RotateX_(angle1)));
		Jun3dPoint b01 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(1)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b02 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(2)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b03 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(3)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b04 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(4)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b06 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(6)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b07 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(7)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b08 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(8)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint b09 = a00.transform_(Jun3dTransformation.RotateZ_(angle2.multipliedBy_(9)).product_(Jun3dTransformation.RotateX_(angle1.negated())));
		Jun3dPoint c00 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint c02 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(2)).product_(Jun3dTransformation.RotateY_(angle1)));
		Jun3dPoint c03 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(3)).product_(Jun3dTransformation.RotateY_(angle1)));
		Jun3dPoint c05 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(5)).product_(Jun3dTransformation.RotateY_(angle1)));
		Jun3dPoint c07 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(7)).product_(Jun3dTransformation.RotateY_(angle1)));
		Jun3dPoint c08 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(8)).product_(Jun3dTransformation.RotateY_(angle1)));
		Jun3dPoint d02 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(2)).product_(Jun3dTransformation.RotateY_(angle1.negated())));
		Jun3dPoint d03 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(3)).product_(Jun3dTransformation.RotateY_(angle1.negated())));
		Jun3dPoint d07 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(7)).product_(Jun3dTransformation.RotateY_(angle1.negated())));
		Jun3dPoint d08 = c00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(8)).product_(Jun3dTransformation.RotateY_(angle1.negated())));
		Jun3dPoint e00 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint e05 = e00.transform_(Jun3dTransformation.RotateX_(angle2.multipliedBy_(5)).product_(Jun3dTransformation.RotateZ_(angle1)));

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a00, b01, a01 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a05, a04, b04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a00, b09, a09 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a05, a06, b06 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c00, a03, a02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c00, a03, a02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c05, b08, b07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c05, b08, b07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c00, b02, b03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { c05, a07, a08 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a01, b01, b02, c00, a02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a04, a03, c00, b03, b04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b06, a06, a07, c05, b07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b09, b08, c05, a08, a09 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e00, d03, b07, b08, c03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e00, c02, a02, a03, d02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e05, d07, a08, a07, c07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e05, c08, b03, b02, d08 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a00, a01, c02, c03, b09 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a00, a09, d07, d08, b01 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a05, b06, d03, d02, a04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a05, b04, c08, c07, a06 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e00, c03, c02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e00, d02, d03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e05, c07, c08 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { e05, d08, d07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a01, a02, c02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a03, a04, d02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b06, b07, d03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b08, b09, c03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b01, d08, b02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { b03, c08, b04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a09, a08, d07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { a07, a06, c07 }));

		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject icosidodecahedron = compoundObject.scaledBy_(scaleFactor);
		icosidodecahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		icosidodecahedron.flushAllPaints();
		icosidodecahedron.paint_(DefaultPaint());
		icosidodecahedron.name_("icosidodecahedron");
		return icosidodecahedron;
	}

	/**
	 * Typical objects - pentakis dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject PentakisDodecahedron() {
		JunOpenGL3dObject pentakisDodecahedron = NAkisHedron_(RegularDodecahedron());
		pentakisDodecahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		pentakisDodecahedron.flushAllPaints();
		pentakisDodecahedron.paint_(DefaultPaint());
		pentakisDodecahedron.name_("pentakis dodecahedron");
		return pentakisDodecahedron;
	}

	/**
	 * Typical objects - regular dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularDodecahedron() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] pointArray = new Jun3dPoint[10];
		for (int i = 0; i < 5; i++) {
			pointArray[i] = new Jun3dPoint(Math.cos(Math.PI * ((i + 1) * 2 + 1) / 5) * 2, Math.sin(Math.PI * ((i + 1) * 2 + 1) / 5) * 2, (1.0d + Math.sqrt(5.0d)) / 2 + 1.0d);
			pointArray[i + 5] = new Jun3dPoint(Math.cos(Math.PI * ((i + 1) * 2 + 1) / 5) * (1.0d + Math.sqrt(5.0d)), Math.sin(Math.PI * ((i + 1) * 2 + 1) / 5) * (1.0d + Math.sqrt(5.0d)), (1.0d + Math.sqrt(5.0d)) / 2 - 1.0d);
		}
		for (int i = 0; i < 10; i++) {
			pointArray[i] = pointArray[i].dividedBy_(pointArray[i].rho()).multipliedBy_(0.81573786516665d / 0.79465447229177d);
		}
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[0], pointArray[1], pointArray[2], pointArray[3], pointArray[4] }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[4].negated(), pointArray[3].negated(), pointArray[2].negated(), pointArray[1].negated(), pointArray[0].negated() }));
		for (int i = 0; i < 5; i++) {
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[i], pointArray[i + 5], pointArray[(i + 3) % 5 + 5].negated(), pointArray[(i + 1) % 5 + 5], pointArray[(i + 1) % 5] }));
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[(i + 1) % 5].negated(), pointArray[(i + 1) % 5 + 5].negated(), pointArray[(i + 3) % 5 + 5], pointArray[i + 5].negated(), pointArray[i].negated() }));
		}

		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject regularDodecahedron = compoundObject.scaledBy_(scaleFactor);
		regularDodecahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		regularDodecahedron.flushAllPaints();
		regularDodecahedron.paint_(DefaultPaint());
		regularDodecahedron.name_("regular dodecahedron");
		return regularDodecahedron;
	}

	/**
	 * Typical objects - regular hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularHexahedron() {
		JunOpenGL3dCompoundObject compoundObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject regularHexahedron = compoundObject.scaledBy_(scaleFactor);
		regularHexahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		regularHexahedron.flushAllPaints();
		regularHexahedron.paint_(DefaultPaint());
		regularHexahedron.name_("regular hexahedron");
		return regularHexahedron;
	}

	/**
	 * Typical objects - regular icoshedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularIcosahedron() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] pointArray = new Jun3dPoint[5];
		for (int i = 0; i < pointArray.length; i++) {
			pointArray[i] = new Jun3dPoint(Math.cos(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sin(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sqrt(5.0d) / 5);
		}
		for (int i = 0; i < pointArray.length; i++) {
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), pointArray[i], pointArray[(i + 1) % 5] }));
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[(i + 1) % 5], pointArray[i], pointArray[(i + 1 + 2) % 5].negated() }));
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[i].negated(), pointArray[(i + 1) % 5].negated(), pointArray[(i + 1 + 2) % 5] }));
			compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[(i + 1) % 5].negated(), pointArray[i].negated(), new Jun3dPoint(0.0d, 0.0d, 1.0d).negated() }));
		}

		Jun3dPoint[] aSet = compoundObject.asPointSet();
		double totalDistance = 0.0d;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < aSet.length; i++) {
			totalDistance += aSet[i].distance_(originPoint);
		}
		double aRadius = totalDistance / aSet.length;
		double scaleFactor = 1 / aRadius;
		JunOpenGL3dObject regularIcosahedron = compoundObject.scaledBy_(scaleFactor);
		regularIcosahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		regularIcosahedron.flushAllPaints();
		regularIcosahedron.paint_(DefaultPaint());
		regularIcosahedron.name_("regular icosahedron");
		return regularIcosahedron;
	}

	/**
	 * Typical objects - regular octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularOctahedron() {
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint p2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p4 = new Jun3dPoint(-1, 0, 0);
		Jun3dPoint p5 = new Jun3dPoint(0, -1, 0);
		Jun3dPoint p6 = new Jun3dPoint(0, 0, -1);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p2, p3 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p3, p4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p4, p5 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p5, p2 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p2, p6, p3 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p3, p6, p4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p4, p6, p5 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p5, p6, p2 }));

		JunOpenGL3dObject regularOctahedron = compoundObject;
		regularOctahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		regularOctahedron.flushAllPaints();
		regularOctahedron.paint_(DefaultPaint());
		regularOctahedron.name_("regular octahedron");
		return regularOctahedron;
	}

	/**
	 * Typical objects - regular tetrahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularTetrahedron() {
		Jun3dPoint p1 = new Jun3dPoint(-1, -1, 1);
		Jun3dPoint p2 = new Jun3dPoint(1, -1, -1);
		Jun3dPoint p3 = new Jun3dPoint(1, 1, 1);
		Jun3dPoint p4 = new Jun3dPoint(-1, 1, -1);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p2, p3 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p3, p4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p4, p2 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p4, p3, p2 }));

		Jun3dPoint[] aSet = compoundObject.asPointSet();
		double totalDistance = 0.0d;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < aSet.length; i++) {
			totalDistance += aSet[i].distance_(originPoint);
		}
		double aRadius = totalDistance / aSet.length;
		double scaleFactor = 1.0d / aRadius;
		JunOpenGL3dObject regularTetrahedron = compoundObject.scaledBy_(scaleFactor);
		regularTetrahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		regularTetrahedron.flushAllPaints();
		regularTetrahedron.paint_(DefaultPaint());
		regularTetrahedron.name_("regular tetrahedron");
		return regularTetrahedron;
	}

	/**
	 * Typical objects - tetrakis hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TetrakisHexahedron() {
		JunOpenGL3dObject tetrakisHexahedron = NAkisHedron_(RegularHexahedron());
		tetrakisHexahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		tetrakisHexahedron.flushAllPaints();
		tetrakisHexahedron.paint_(DefaultPaint());
		tetrakisHexahedron.name_("tetrakis hexahedron");
		return tetrakisHexahedron;
	}

	/**
	 * Typical objects - triakis icosahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TriakisIcosahedron() {
		JunOpenGL3dObject triakisIcosahedron = NAkisHedron_(RegularIcosahedron());
		triakisIcosahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		triakisIcosahedron.flushAllPaints();
		triakisIcosahedron.paint_(DefaultPaint());
		triakisIcosahedron.name_("triakis icosahedron");
		return triakisIcosahedron;
	}

	/**
	 * Typical objects - triakis octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TriakisOctahedron() {
		JunOpenGL3dObject triakisOctahedron = NAkisHedron_(RegularOctahedron());
		triakisOctahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		triakisOctahedron.flushAllPaints();
		triakisOctahedron.paint_(DefaultPaint());
		triakisOctahedron.name_("triakis octahedron");
		return triakisOctahedron;
	}

	/**
	 * Typical objects - truncated dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedDodecahedron() {
		final Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		final double aFactor = 0.85065080835204d;
		final HashMap aHashMap = new HashMap();
		final JunOpenGL3dCompoundObject aCompound = new JunOpenGL3dCompoundObject();
		RegularDodecahedron().primitivesDo_(new StBlockClosure() {
			public Object value_(Object pentahedron) {
				Jun3dPoint[] vertexes = ((JunOpenGL3dVertexesObject) pentahedron).vertexes();
				JunPlane aPlane = new JunPlane(vertexes[0], vertexes[2], vertexes[4]);
				Jun3dPoint aPoint = aPlane.nearestPointFromPoint_(originPoint);
				Jun3dLine aLine = new Jun3dLine(originPoint, aPoint);
				Jun3dPoint[] anArrayOfPoints = new Jun3dPoint[10];
				for (int i = 0; i < 10; i++) {
					Jun3dPoint originalVertex = (new Jun3dLine(aPoint, vertexes[0])).atT_(aFactor).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(360 / 10 * i + 18), aLine));
					Jun3dPoint roundedVertex = originalVertex.roundTo_(1.0e-12);
					aHashMap.put(roundedVertex, originalVertex);
					anArrayOfPoints[i] = roundedVertex;
				}
				JunOpenGL3dPolygon aDecahedron = new JunOpenGL3dPolygon(anArrayOfPoints);
				aCompound.add_(aDecahedron);
				return null;
			}
		});

		final ArrayList aCollection = new ArrayList();
		aCompound.primitivesDo_(new StBlockClosure() {
			public Object value_(Object decahedron) {
				Jun3dPoint[] vertexes = ((JunOpenGL3dVertexesObject) decahedron).vertexes();
				Jun3dPoint[] anArrayOfPoints = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < vertexes.length; i++) {
					anArrayOfPoints[i] = (Jun3dPoint) aHashMap.get(vertexes[i]);
				}
				aCollection.add(new JunOpenGL3dPolygon(anArrayOfPoints));
				return null;
			}
		});
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject(aCollection);
		final ArrayList aTable = new ArrayList();
		final Jun3dPoint[] anArrayOfPoints = compoundObject.asPointSet();
		compoundObject.primitivesDo_(new StBlockClosure() {
			public Object value_(Object decahedron) {
				Jun3dPoint[] vertexes = ((JunOpenGL3dVertexesObject) decahedron).vertexes();
				Jun3dPoint p1 = vertexes[2];
				Jun3dPoint p2 = vertexes[1];
				Jun3dPoint p = (new Jun3dLine(p1, p2)).atT_(0.5);
				Jun3dPoint p3 = null;
				for (int i = 0; i < anArrayOfPoints.length; i++) {
					if (anArrayOfPoints[i].equals(p1) == false && anArrayOfPoints[i].equals(p2) == false) {
						if (p3 == null || anArrayOfPoints[i].distance_(p) < p3.distance_(p)) {
							p3 = anArrayOfPoints[i];
						}
					}
				}
				boolean found = false;
				for (int i = 0; i < aTable.size(); i++) {
					List aList = Arrays.asList((Jun3dPoint[]) aTable.get(i));
					if (aList.contains(p1) && aList.contains(p2) && aList.contains(p3)) {
						found = true;
						break;
					}
				}
				if (found == false) {
					Jun3dPoint[] anArray = new Jun3dPoint[] { p1, p2, p3 };
					aTable.add(anArray);
					JunOpenGL3dPolygon aTriangle = new JunOpenGL3dPolygon(anArray);
					compoundObject.add_(aTriangle);
				}

				p1 = vertexes[0];
				p2 = vertexes[9];
				p = (new Jun3dLine(p1, p2)).atT_(0.5);
				p3 = null;
				for (int i = 0; i < anArrayOfPoints.length; i++) {
					if (anArrayOfPoints[i].equals(p1) == false && anArrayOfPoints[i].equals(p2) == false) {
						if (p3 == null || anArrayOfPoints[i].distance_(p) < p3.distance_(p)) {
							p3 = anArrayOfPoints[i];
						}
					}
				}
				found = false;
				for (int i = 0; i < aTable.size(); i++) {
					List aList = Arrays.asList((Jun3dPoint[]) aTable.get(i));
					if (aList.contains(p1) && aList.contains(p2) && aList.contains(p3)) {
						found = true;
						break;
					}
				}
				if (found == false) {
					Jun3dPoint[] anArray = new Jun3dPoint[] { p1, p2, p3 };
					aTable.add(anArray);
					JunOpenGL3dPolygon aTriangle = new JunOpenGL3dPolygon(anArray);
					compoundObject.add_(aTriangle);
				}

				return null;
			}
		});

		Jun3dPoint[] points = compoundObject.asPointArray();
		double totalDistance = 0;
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject truncatedDodecahedron = compoundObject.scaledBy_(scaleFactor);
		truncatedDodecahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		truncatedDodecahedron.flushAllPaints();
		truncatedDodecahedron.paint_(DefaultPaint());
		truncatedDodecahedron.name_("truncated dodecahedron");
		return truncatedDodecahedron;
	}

	/**
	 * Typical objects - truncated hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedHexahedron() {
		double offset = new Jun3dPoint(1, 0, 0).transform_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5))).x();
		Jun3dPoint p01 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p02 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 45.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p03 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 90.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p04 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 135.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p05 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 180.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p06 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 225.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p07 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 270.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p08 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 315.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, offset))));
		Jun3dPoint p91 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5)).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset)))));
		Jun3dPoint p92 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 45.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p93 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 90.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p94 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 135.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p95 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 180.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p96 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 225.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p97 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 270.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p98 = new Jun3dPoint(1, 0, 0).transform_((Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(22.5 + 315.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0 - offset))));
		Jun3dPoint p32 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 45.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, offset, 0))));
		Jun3dPoint p33 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 90.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, offset, 0))));
		Jun3dPoint p36 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 225.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, offset, 0))));
		Jun3dPoint p37 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 270.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, offset, 0))));
		Jun3dPoint p72 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 45.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0 - offset, 0))));
		Jun3dPoint p73 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 90.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0 - offset, 0))));
		Jun3dPoint p76 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 225.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0 - offset, 0))));
		Jun3dPoint p77 = new Jun3dPoint(0, 0, 1).transform_((Jun3dTransformation.RotateY_(JunAngle.FromDeg_(22.5 + 270.0))).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0 - offset, 0))));

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p02, p03, p04, p05, p06, p07, p08 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p98, p97, p96, p95, p94, p93, p92, p91 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p02, p32, p33, p92, p93, p36, p37, p03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p06, p77, p76, p96, p97, p73, p72, p07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p08, p72, p73, p98, p91, p33, p32 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p05, p04, p37, p36, p94, p95, p76, p77 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p32, p02 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p91, p92, p33 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p08, p07, p72 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p98, p73, p97 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p03, p37, p04 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p36, p93, p94 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p06, p05, p77 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p95, p96, p76 }));

		Jun3dPoint[] aSet = compoundObject.asPointSet();
		double totalDistance = 0.0d;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < aSet.length; i++) {
			totalDistance += aSet[i].distance_(originPoint);
		}
		double aRadius = totalDistance / aSet.length;
		double scaleFactor = 1 / aRadius;
		JunOpenGL3dObject truncatedHexahedron = compoundObject.scaledBy_(new Jun3dPoint(scaleFactor, scaleFactor, scaleFactor));
		truncatedHexahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		truncatedHexahedron.flushAllPaints();
		truncatedHexahedron.paint_(DefaultPaint());
		truncatedHexahedron.name_("truncated hexahedron");
		return truncatedHexahedron;
	}

	/**
	 * Typical objects - truncated icosahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedIcosahedron() {
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] pointArray = new Jun3dPoint[5];
		for (int i = 0; i < pointArray.length; i++) {
			pointArray[i] = new Jun3dPoint(Math.cos(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sin(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sqrt(5.0d) / 5);
		}

		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Jun3dPoint p1 = (Jun3dPoint) obj1;
				Jun3dPoint p2 = (Jun3dPoint) obj2;
				Jun3dPoint p3 = (Jun3dPoint) obj3;
				Jun3dPoint[] anArray = new Jun3dPoint[6];
				anArray[0] = p1.multipliedBy_(2).plus_(p2).dividedBy_(3);
				anArray[1] = p1.plus_(p2.multipliedBy_(2)).dividedBy_(3);
				anArray[2] = p2.multipliedBy_(2).plus_(p3).dividedBy_(3);
				anArray[3] = p2.plus_(p3.multipliedBy_(2)).dividedBy_(3);
				anArray[4] = p3.multipliedBy_(2).plus_(p1).dividedBy_(3);
				anArray[5] = p3.plus_(p1.multipliedBy_(2)).dividedBy_(3);
				JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(anArray);
				compoundObject.add_(polygon);
				return null;
			}
		};
		for (int i = 0; i < 5; i++) {
			aBlock.value_value_value_(new Jun3dPoint(0.0d, 0.0d, 1.0d), pointArray[i], pointArray[(i + 1) % 5]);
			aBlock.value_value_value_(pointArray[(i + 1) % 5], pointArray[i], pointArray[(i + 3) % 5].negated());
			aBlock.value_value_value_(pointArray[i].negated(), pointArray[(i + 1) % 5].negated(), pointArray[(i + 3) % 5]);
			aBlock.value_value_value_(pointArray[(i + 1) % 5].negated(), pointArray[i].negated(), new Jun3dPoint(0.0d, 0.0d, 1.0d).negated());
		}

		aBlock = new StBlockClosure() {
			public Object value_value_(Object obj1, Object obj2) {
				Jun3dPoint p0 = (Jun3dPoint) obj1;
				Jun3dPoint[] pp = (Jun3dPoint[]) obj2;
				Jun3dPoint[] anArray = new Jun3dPoint[5];

				for (int i = 0; i < 5; i++) {
					anArray[i] = p0.multipliedBy_(2).plus_(pp[i]).dividedBy_(3);
				}
				JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(anArray);
				compoundObject.add_(polygon);

				for (int i = 0; i < 5; i++) {
					anArray[i] = p0.multipliedBy_(2).plus_(pp[i]).dividedBy_(3).negated();
				}
				polygon = new JunOpenGL3dPolygon(anArray);
				compoundObject.add_(polygon);

				return null;
			}
		};
		aBlock.value_value_(new Jun3dPoint(0.0d, 0.0d, 1.0d), pointArray);
		for (int i = 0; i < 5; i++) {
			aBlock.value_value_(pointArray[i], new Jun3dPoint[] { pointArray[(i + 4) % 5], pointArray[(i + 2) % 5].negated(), pointArray[(i + 3) % 5].negated(), pointArray[(i + 1) % 5], new Jun3dPoint(0.0d, 0.0d, 1.0d) });
		}

		Jun3dPoint[] aSet = compoundObject.asPointSet();
		double totalDistance = 0.0d;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < aSet.length; i++) {
			totalDistance += aSet[i].distance_(originPoint);
		}
		double aRadius = totalDistance / aSet.length;
		double scaleFactor = 1 / aRadius;
		JunOpenGL3dObject truncatedIcosahedron = compoundObject.scaledBy_(new Jun3dPoint(scaleFactor, scaleFactor, scaleFactor));
		truncatedIcosahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		truncatedIcosahedron.flushAllPaints();
		truncatedIcosahedron.paint_(DefaultPaint());
		truncatedIcosahedron.name_("truncated icosahedron");
		return truncatedIcosahedron;
	}

	/**
	 * Typical objects - truncated octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedOctahedron() {
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint p2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p4 = new Jun3dPoint(-1, 0, 0);
		Jun3dPoint p5 = new Jun3dPoint(0, -1, 0);
		Jun3dPoint p6 = new Jun3dPoint(0, 0, -1);
		Jun3dLine aLine = new Jun3dLine(p2, p3);
		Jun3dPoint xy1 = aLine.atT_((double) 1 / 3);
		Jun3dPoint xy2 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p3, p4);
		Jun3dPoint xy3 = aLine.atT_((double) 1 / 3);
		Jun3dPoint xy4 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p4, p5);
		Jun3dPoint xy5 = aLine.atT_((double) 1 / 3);
		Jun3dPoint xy6 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p5, p2);
		Jun3dPoint xy7 = aLine.atT_((double) 1 / 3);
		Jun3dPoint xy8 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p3, p1);
		Jun3dPoint yz1 = aLine.atT_((double) 1 / 3);
		Jun3dPoint yz2 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p1, p5);
		Jun3dPoint yz3 = aLine.atT_((double) 1 / 3);
		Jun3dPoint yz4 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p5, p6);
		Jun3dPoint yz5 = aLine.atT_((double) 1 / 3);
		Jun3dPoint yz6 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p6, p3);
		Jun3dPoint yz7 = aLine.atT_((double) 1 / 3);
		Jun3dPoint yz8 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p1, p4);
		Jun3dPoint zx1 = aLine.atT_((double) 1 / 3);
		Jun3dPoint zx2 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p4, p6);
		Jun3dPoint zx3 = aLine.atT_((double) 1 / 3);
		Jun3dPoint zx4 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p6, p2);
		Jun3dPoint zx5 = aLine.atT_((double) 1 / 3);
		Jun3dPoint zx6 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p2, p1);
		Jun3dPoint zx7 = aLine.atT_((double) 1 / 3);
		Jun3dPoint zx8 = aLine.atT_((double) 2 / 3);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { zx3, xy5, zx2, xy4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { zx7, xy8, zx6, xy1 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy3, yz1, xy2, yz8 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy6, yz5, xy7, yz4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { yz3, zx8, yz2, zx1 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { yz7, zx5, yz6, zx4 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { zx7, zx8, yz3, yz4, xy7, xy8 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { zx1, zx2, xy5, xy6, yz4, yz3 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { yz1, yz2, zx8, zx7, xy1, xy2 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { yz1, xy3, xy4, zx2, zx1, yz2 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy1, zx6, zx5, yz7, yz8, xy2 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy8, xy7, yz5, yz6, zx5, zx6 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy6, xy5, zx3, zx4, yz6, yz5 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { xy3, yz8, yz7, zx4, zx3, xy4 }));

		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject truncatedOctahedron = compoundObject.scaledBy_(scaleFactor);
		truncatedOctahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		truncatedOctahedron.flushAllPaints();
		truncatedOctahedron.paint_(DefaultPaint());
		truncatedOctahedron.name_("truncated octahedron");
		return truncatedOctahedron;
	}

	/**
	 * Typical objects - truncated tetrahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedTetrahedron() {
		Jun3dPoint p1 = new Jun3dPoint(-1, -1, 1);
		Jun3dPoint p2 = new Jun3dPoint(1, -1, -1);
		Jun3dPoint p3 = new Jun3dPoint(1, 1, 1);
		Jun3dPoint p4 = new Jun3dPoint(-1, 1, -1);
		Jun3dLine aLine = new Jun3dLine(p1, p2);
		Jun3dPoint p01 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p02 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p1, p3);
		Jun3dPoint p03 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p04 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p1, p4);
		Jun3dPoint p05 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p06 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p2, p3);
		Jun3dPoint p07 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p08 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p2, p4);
		Jun3dPoint p09 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p10 = aLine.atT_((double) 2 / 3);
		aLine = new Jun3dLine(p3, p4);
		Jun3dPoint p11 = aLine.atT_((double) 1 / 3);
		Jun3dPoint p12 = aLine.atT_((double) 2 / 3);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p03, p05 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p02, p09, p07 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p04, p08, p11 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p06, p12, p10 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p02, p07, p08, p04, p03 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p03, p04, p11, p12, p06, p05 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p08, p07, p09, p10, p12, p11 }));
		compoundObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { p01, p05, p06, p10, p09, p02 }));

		Jun3dPoint[] points = compoundObject.asPointSet();
		double totalDistance = 0;
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		for (int i = 0; i < points.length; i++) {
			totalDistance += points[i].distance_(originPoint);
		}
		double radius = totalDistance / points.length;
		double scaleFactor = 1 / radius;
		JunOpenGL3dObject truncatedTetrahedron = compoundObject.scaledBy_(scaleFactor);
		truncatedTetrahedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		truncatedTetrahedron.flushAllPaints();
		truncatedTetrahedron.paint_(DefaultPaint());
		truncatedTetrahedron.name_("truncated tetrahedron");
		return truncatedTetrahedron;
	}
}
