package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGL3dTypicalObjectsBall class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun692 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsBall.java,v 8.7 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsBall extends JunOpenGL3dTypicalObjects {

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball() {
		return Ball_(2);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_(int smoothInteger) {
		JunOpenGL3dObject aHedron = BallHedron();
		if (smoothInteger < 1) {
			return aHedron;
		}
		final StValueHolder aBoolean = new StValueHolder(false);
		aHedron.primitivesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) anObject;
				if (polygon.vertexes().length > 3) {
					aBoolean.value_(true);
				}
				return null;
			}
		});
		if (aBoolean._booleanValue()) {
			aHedron = Ball_smooth_(NAkisHedron_(aHedron), smoothInteger - 1);
		} else {
			aHedron = Ball_smooth_(aHedron, smoothInteger);
		}
		final double accuracyValue = 1.0e-14;
		final JunOpenGL3dCompoundObject aBall = new JunOpenGL3dCompoundObject();
		aHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] points = polygon.vertexes();
				Jun3dPoint[] newPoints = new Jun3dPoint[points.length];
				for (int i = 0; i < points.length; i++) {
					newPoints[i] = points[i].roundTo_(accuracyValue);
				}
				JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(newPoints);
				Jun3dPoint[] vertexes = aPolygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < normalVectors.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				aPolygon.normalVectors_(normalVectors);
				aBall.add_(aPolygon);
				return null;
			}
		});
		aBall.flushAllPaints();
		aBall.paint_(DefaultPaint());
		aBall.name_("ball " + smoothInteger);
		return aBall;
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @param radius double
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_radius_(int smoothInteger, double radius) {
		return Ball_(smoothInteger).scaledBy_(radius);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_radius_center_(int smoothInteger, double radius, Jun3dPoint center) {
		return Jun3dTransformation.Align_with_(new Jun3dPoint(0, 0, 0), center).applyTo_(Ball_radius_(smoothInteger, radius));
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aBall jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param anInteger int
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_smooth_(JunOpenGL3dObject aBall, int anInteger) {
		return Ball_smooth_interim_(aBall, anInteger, new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				// JunOpenGL3dCompoundObject comoundObject = (JunOpenGL3dCompoundObject) obj1;
				// JunOpenGL3dObject originalObject = (JunOpenGL3dObject) obj2;
				// Integer smoothItenger = (Integer) obj3;
				return null;
			}
		});
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aBall jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param anInteger int
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_smooth_interim_(final JunOpenGL3dObject aBall, final int anInteger, final StBlockClosure aBlock) {
		if (anInteger < 1) {
			return aBall;
		}

		final Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		final JunOpenGL3dCompoundObject smoothBall = new JunOpenGL3dCompoundObject();
		aBall.primitivesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) anObject;
				Jun3dPoint[] pointArray = new Jun3dPoint[6];
				pointArray[0] = polygon.vertexes()[0];
				pointArray[1] = polygon.vertexes()[1];
				pointArray[2] = polygon.vertexes()[2];
				Jun3dPoint aPoint1 = pointArray[0].center_(pointArray[1]);
				Jun3dLine aLine1 = new Jun3dLine(originPoint, aPoint1).normalizedLine();
				aPoint1 = aLine1.atT_(1);
				pointArray[3] = aPoint1;
				Jun3dPoint aPoint2 = pointArray[1].center_(pointArray[2]);
				Jun3dLine aLine2 = new Jun3dLine(originPoint, aPoint2).normalizedLine();
				aPoint2 = aLine2.atT_(1);
				pointArray[4] = aPoint2;
				Jun3dPoint aPoint3 = pointArray[2].center_(pointArray[0]);
				Jun3dLine aLine3 = new Jun3dLine(originPoint, aPoint3).normalizedLine();
				aPoint3 = aLine3.atT_(1);
				pointArray[5] = aPoint3;

				JunOpenGL3dPolygon aTriangle1 = new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[0], pointArray[3], pointArray[5] });
				smoothBall.add_(aTriangle1);
				JunOpenGL3dPolygon aTriangle2 = new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[3], pointArray[1], pointArray[4] });
				smoothBall.add_(aTriangle2);
				JunOpenGL3dPolygon aTriangle3 = new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[4], pointArray[2], pointArray[5] });
				smoothBall.add_(aTriangle3);
				JunOpenGL3dPolygon aTriangle4 = new JunOpenGL3dPolygon(new Jun3dPoint[] { pointArray[3], pointArray[4], pointArray[5] });
				smoothBall.add_(aTriangle4);

				if (aBlock != null) {
					if (aBlock.numArgs() == 1) {
						aBlock.value_(smoothBall);
					}
					if (aBlock.numArgs() == 2) {
						aBlock.value_value_(smoothBall, aBall);
					}
					if (aBlock.numArgs() == 3) {
						aBlock.value_value_value_(smoothBall, aBall, new Integer(anInteger));
					}

				}
				return null;
			}
		});
		smoothBall.paint_(DefaultPaint());
		smoothBall.name_("ball " + anInteger);
		return Ball_smooth_interim_(smoothBall, anInteger - 1, aBlock);
	}

	/**
	 * Typical objects - ball hedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject BallHedron() {
		return JunOpenGL3dObject.RegularIcosahedron();
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall() {
		return ColorBall_(2);
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_(int smoothInteger) {
		final JunOpenGL3dCompoundObject colorBall = new JunOpenGL3dCompoundObject();

		JunOpenGL3dObject sphereBody = Ball_(smoothInteger);
		sphereBody.flushAllPaints();
		sphereBody.polygonsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) anObject;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Color[] colors = new Color[vertexes.length];
				Jun3dPoint[] vectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < vertexes.length; i++) {
					Jun3dPoint p = vertexes[i];
					Jun2dPoint p2 = p.as2dPoint();
					double hue = (p2.distance_(new Jun2dPoint(0, 0)) < 0.0001) ? 1 : JunAngle._RadiansToDegrees(p2.theta()) / 360.0d;
					double saturation = (p.z() >= 0) ? 1 - Math.abs(p.z()) : 1;
					double brightness = (p.z() >= 0) ? 1 : 1 - Math.abs(p.z());
					colors[i] = Color.getHSBColor((float) hue, (float) saturation, (float) brightness);
					vectors[i] = Jun3dPoint.Zero().to_(p).normalUnitVector();
				}
				polygon.colors_(colors);
				polygon.normalVectors_(vectors);
				colorBall.add_(polygon);

				return null;
			}
		});

		colorBall.name_("color ball " + smoothInteger);
		return colorBall;
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_radius_(int smoothInteger, double radius) {
		return ColorBall_(2).scaledBy_(radius);
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_radius_center_(int smoothInteger, double radius, Jun3dPoint center) {
		return Jun3dTransformation.Align_with_(new Jun3dPoint(0, 0, 0), center).applyTo_(ColorBall_radius_(smoothInteger, radius));
	}

	/**
	 * Typical objects - earth
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Earth() {
		Object[] xyPointsAndSphere = JunOpenGL3dObject.XyPointsAndSphere_radius_longitude_latitude_(12, 1, 360, 180);
		Vector collection = (Vector) xyPointsAndSphere[0];
		Jun2dPoint[] points = new Jun2dPoint[collection.size()];
		collection.copyInto(points);
		Jun2dPoint[] xyPoints = new Jun2dPoint[points.length];
		for (int i = 0; i < points.length; i++) {
			xyPoints[i] = new Jun2dPoint(points[i].x(), 1.0d - points[i].y());
		}
		JunOpenGL3dCompoundObject aCompoundObject = (JunOpenGL3dCompoundObject) xyPointsAndSphere[1];
		aCompoundObject.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		aCompoundObject.paint_(Color.white);
		JunOpenGLTexture aTexture = new JunOpenGLTexture(JunOpenGL3dObject.ImageEarth());
		aTexture.linear_(true);
		aTexture.repeat_(true);
		aTexture.coordinates_(xyPoints);
		aCompoundObject.texture_(aTexture);
		aCompoundObject.name_("earth");
		return aCompoundObject;
	}

	/**
	 * Typical objects - soccer ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject SoccerBall() {
		final JunOpenGL3dCompoundObject soccerBall = new JunOpenGL3dCompoundObject();
		JunOpenGL3dCompoundObject base = (JunOpenGL3dCompoundObject) NAkisHedron_(JunOpenGL3dObject.TruncatedIcosahedron());
		base.do_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dCompoundObject compoundObject = (JunOpenGL3dCompoundObject) obj;
				final Color color = (compoundObject.size() > 5) ? StColorValue.VeryLightGray : StColorValue.VeryDarkGray;
				compoundObject.primitivesDo_(new StBlockClosure() {
					public Object value_(Object obj2) {
						JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj2;
						polygon.paint_(color);
						soccerBall.add_(polygon);
						return null;
					}
				});
				return null;
			}
		});
		soccerBall.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) each;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < vertexes.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		soccerBall.name_("soccer ball");
		return soccerBall;
	}

	/**
	 * Typical objects - x unit ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject XUnitBall() {
		return Ball().transform_(Jun3dTransformation.Scale_(new Jun3dPoint(0.5, 0.5, 0.5)).product_(Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 0.5)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90)))));
	}

}
