package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.Writer;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGL3dTransformedObject class
 * 
 *  @author    r-matuda
 *  @created   1998/11/18 (by r-matuda)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @updated   2004/09/29 (by m-asada)
 *  @updated   2004/11/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTransformedObject.java,v 8.15 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dTransformedObject extends JunOpenGL3dPrimitiveObject {
	protected JunOpenGL3dObject object;
	protected Jun3dTransformation transformation;
	protected JunOpenGL3dObject transformedObject;

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGL3dTransformedObject() {
		super();
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Instance creation
	 */
	public JunOpenGL3dTransformedObject(JunOpenGL3dObject a3dObject) {
		this();
		this.object_(a3dObject);
		this.transformation_(Jun3dTransformation.Unity());
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category Instance creation
	 */
	public JunOpenGL3dTransformedObject(JunOpenGL3dObject a3dObject, Jun3dTransformation aTransformation) {
		this();
		this.object_(a3dObject);
		this.transformation_(aTransformation);
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGL3dTransformedObject(JunOpenGL3dObject a3dObject, Jun3dTransformation aTransformation, Color aColor) {
		this();
		this.object_(a3dObject);
		this.transformation_(aTransformation);
		this.paint_(aColor);
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @param aColor java.awt.Color
	 * @param alpha float
	 * @category Instance creation
	 */
	public JunOpenGL3dTransformedObject(JunOpenGL3dObject a3dObject, Jun3dTransformation aTransformation, Color aColor, float alpha) {
		this();
		this.object_(a3dObject);
		this.transformation_(aTransformation);
		this.paint_(aColor);
		this.alpha_(alpha);
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject
	 * @deprecated since Jun454, use the constructor
	 * @category Instance creation
	 */
	public static final JunOpenGL3dTransformedObject Object_(JunOpenGL3dObject a3dObject) {
		return new JunOpenGL3dTransformedObject(a3dObject, Jun3dTransformation.Unity());
	}

	/**
	 * Create a new instance of <code>JunOpenGL3dTransformedObject</code> and initialize it.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject
	 * @deprecated since Jun454, use the constructor
	 * @category Instance creation
	 */
	public static final JunOpenGL3dTransformedObject Object_transformation_(JunOpenGL3dObject a3dObject, Jun3dTransformation aTransformation) {
		return new JunOpenGL3dTransformedObject(a3dObject, aTransformation);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		object = null;
		transformation = null;
		transformedObject = null;
	}

	/**
	 * Answer my current object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject object() {
		return object;
	}

	/**
	 * Set my new object.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public void object_(JunOpenGL3dObject a3dObject) {
		if (a3dObject instanceof JunOpenGL3dTransformedObject) {
			object = ((JunOpenGL3dTransformedObject) a3dObject).transformedObject();
		} else {
			object = a3dObject;
		}

		this.flushBounds();
		this.flushTransformedObject();
	}

	/**
	 * Answer my current transformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#transformation()
	 * @category accessing
	 */
	public Jun3dTransformation transformation() {
		return transformation;
	}

	/**
	 * Set my new transforamtion.
	 * 
	 * @param aTransforamtion jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category accessing
	 */
	public void transformation_(Jun3dTransformation aTransforamtion) {
		transformation = aTransforamtion;
		this.flushBounds();
		this.flushTransformedObject();
	}

	/**
	 * Answer my current transformedObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject transformedObject() {
		if (transformedObject == null) {
			if (this.object() == null) {
				transformedObject = new JunOpenGL3dCompoundObject();
			} else if (this.transformation() == null) {
				transformedObject = (JunOpenGL3dObject) this.object().copy();
			} else {
				transformedObject = this.object().transform_(this.transformation());
			}
			this._copyInto(transformedObject);
		}
		return transformedObject;
	}

	/**
	 * Establish all normal vectors with the specified smoothing angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#establishAllNormalVectorsWithSmoothingAngle_(jp.co.sra.jun.geometry.basic.JunAngle)
	 * @category vector accessing
	 */
	public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle anAngle) {
		super.establishAllNormalVectorsWithSmoothingAngle_(anAngle);

		if (this.object() != null) {
			this.object().establishAllNormalVectorsWithSmoothingAngle_(anAngle);
		}
	}

	/**
	 * Flush all alphas.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllAlphas()
	 * @category flushing
	 */
	public void flushAllAlphas() {
		this.flushAlpha();
		if (this.object() != null) {
			this.object().flushAllAlphas();
		}
	}

	/**
	 * Flush all bounds.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllBounds()
	 * @category flushing
	 */
	public void flushAllBounds() {
		this.flushBounds();
		if (this.object() != null) {
			this.object().flushAllBounds();
		}
	}

	/**
	 * Flush all names.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllNames()
	 * @category flushing
	 */
	public void flushAllNames() {
		this.flushName();
		if (this.object() != null) {
			this.object().flushAllNames();
		}
	}

	/**
	 * Flush all normal vectors.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllNormalVectors()
	 * @category flushing
	 */
	public void flushAllNormalVectors() {
		this.flushNormalVectors();
		if (this.object() != null) {
			this.object().flushNormalVectors();
		}
	}

	/**
	 * Flush all paints.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllPaints()
	 * @category flushing
	 */
	public void flushAllPaints() {
		this.flushPaint();
		if (this.object() != null) {
			this.object().flushAllPaints();
		}
	}

	/**
	 * Flush my transformed object.
	 * 
	 * @category flushing
	 */
	public void flushTransformedObject() {
		transformedObject = null;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dTransformedObject, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#isTransformedObject()
	 * @category testing
	 */
	public boolean isTransformedObject() {
		return true;
	}

	/**
	 * Render the OpenGL object on a rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
		if (this.object() == null) {
			return;
		}

		if (this.hasPaint()) {
			aRenderingContext.paint_(this.paint());
		}
		if (this.hasAlpha()) {
			aRenderingContext.alpha_(this.alpha());
		}

		if (this.transformation() == null) {
			this.object().renderOn_(aRenderingContext);
		} else {
			this.transformedObject().renderOn_(aRenderingContext);
			/*
			 aRenderingContext.productTransformation_while_(this.transformation(), new StBlockClosure() {
			 public Object value() {
			 JunOpenGL3dTransformedObject.this.object().renderOn_(aRenderingContext);
			 return null;
			 }
			 });
			 */
		}
	}

	/**
	 * Enumerate each geometries and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#geometriesDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public Object geometriesDo_(StBlockClosure aBlock) {
		return this.transformedObject().geometriesDo_(aBlock);
	}

	/**
	 * Enumerate each objects and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject#objectsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public Object objectsDo_(StBlockClosure aBlock) {
		return this.transformedObject().objectsDo_(aBlock);
	}

	/**
	 * Enumerate every points and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#pointsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void pointsDo_(final StBlockClosure aBlock) {
		if (this.object() == null) {
			return;
		}

		if (this.transformation() == null) {
			this.object().pointsDo_(aBlock);
		} else {
			this.object().pointsDo_(new StBlockClosure() {
				public Object value_(Object o) {
					Jun3dPoint point = (Jun3dPoint) o;
					aBlock.value_(point.transform_(transformation()));
					return null;
				}
			});
		}
	}

	/**
	 * Enumerate every polygons and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#polygonsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void polygonsDo_(final StBlockClosure aBlock) {
		if (this.object() == null) {
			return;
		}

		if (this.transformation() == null) {
			this.object().polygonsDo_(aBlock);
		} else {
			this.object().polygonsDo_(new StBlockClosure() {
				public Object value_(Object anObject) {
					JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) anObject;
					aBlock.value_(aPolygon.transform_(JunOpenGL3dTransformedObject.this.transformation()));
					return null;
				}
			});
		}
	}

	/**
	 * Enumerate every polylines and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#polylinesDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void polylinesDo_(final StBlockClosure aBlock) {
		if (this.object() == null) {
			return;
		}

		if (this.transformation() == null) {
			this.object().polylinesDo_(aBlock);
		} else {
			this.object().polylinesDo_(new StBlockClosure() {
				public Object value_(Object aPolyline) {
					aBlock.value_(((JunOpenGL3dPolyline) aPolyline).transform_(JunOpenGL3dTransformedObject.this.transformation()));
					return null;
				}
			});
		}
		return;
	}

	/**
	 * Answer the new JunOpenGL3dTransformedObject transformed with aTransformation.
	 * 
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#transform_(jp.co.sra.jun.geometry.transformations.Jun3dTransformation)
	 * @category transforming
	 */
	public JunOpenGL3dObject transform_(Jun3dTransformation aTransformation) {
		JunOpenGL3dTransformedObject newObject = (JunOpenGL3dTransformedObject) this.copy();
		if (this.transformation() == null) {
			newObject.transformation_((Jun3dTransformation) aTransformation);
		} else {
			newObject.transformation_((Jun3dTransformation) this.transformation().transform_(aTransformation));
		}
		return newObject;
	}

	/**
	 * Anser the reversed JunOpenGL3dObject of the receiver.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#reversed()
	 * @category converting
	 */
	public JunOpenGL3dObject reversed() {
		JunOpenGL3dTransformedObject temp = (JunOpenGL3dTransformedObject) this.copy();
		temp.object_(this.object().reversed());
		return temp;
	}

	/**
	 * Answer myself and my normal vectors object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#yourselfAndNormalVectorsObject()
	 * @category converting
	 */
	public JunOpenGL3dObject yourselfAndNormalVectorsObject() {
		return this.transformedObject().yourselfAndNormalVectorsObject();
	}

	/**
	 * Answer the number of polygons.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#numberOfPolygons()
	 * @category utilities
	 */
	public int numberOfPolygons() {
		return this.object().numberOfPolygons();
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#toLispList()
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		return this.transformedObject().toLispList();
	}

	/**
	 * Write the VRML1.0 string of the receiver on the writer.
	 * 
	 * @param writer java.io.Writer
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#vrml10On_(java.io.Writer)
	 * @category vrml support
	 */
	public void vrml10On_(Writer writer) {
		this.transformedObject().vrml10On_(writer);
	}

	/**
	 * Write the VRML2.0 string of the receiver on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#vrml20On_(java.io.Writer)
	 * @category vrml support
	 */
	public void vrml20On_(Writer aWriter) {
		this.transformedObject().vrml20On_(aWriter);
	}

	/**
	 * Write my shape as VRML2.0 on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#vrml20On_(java.io.PrintWriter, java.lang.String)
	 * @category vrml support
	 */
	public void vrml20On_(PrintWriter pw, String leader) {
		this.transformedObject().vrml20On_(pw, leader);
	}
}
