package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * JunOpenGL3dNurbsCurveTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/20 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dNurbsCurveTestExamples.java,v 8.10 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dNurbsCurveTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunOpenGL3dObject nurbs = JunOpenGL3dNurbsCurve.Circle();
		nurbs.name_("example");
		nurbs.paint_(Color.red);
		nurbs.show();
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunOpenGL3dNurbsCurve nurbs = ExampleBezierCurve();
		nurbs.name_("example");
		nurbs.paint_(Color.blue);
		nurbs.show();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dNurbsCurveTestExamples();
	}

	/**
	 * Create an instance of JunOpenGL3dNurbsCurve which represents a Bezier
	 * curve.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve
	 * @category Examples
	 */
	protected static JunOpenGL3dNurbsCurve ExampleBezierCurve() {
		Jun3dPoint[] controlPoints = new Jun3dPoint[5];
		controlPoints[0] = new Jun3dPoint(1, -1, 0);
		controlPoints[1] = new Jun3dPoint(-1, -1, 0);
		controlPoints[2] = new Jun3dPoint(-1, 1, 0);
		controlPoints[3] = new Jun3dPoint(1, 1, 0);
		controlPoints[4] = new Jun3dPoint(1, -1, 0);
		return JunOpenGL3dNurbsCurve.BezierControlPoints_(controlPoints);
	}
}
