package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLParallelLight class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/10/23 (by MATSUDA Ryouichi)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLParallelLight.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLParallelLight extends JunOpenGLLight {

	protected Jun3dPoint direction;

	/**
	 * Create a new instance of JunOpenGLParallelLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight
	 * @category Instance creation
	 */
	public static JunOpenGLParallelLight At3dPoint_(Jun3dPoint a3dPoint) {
		return At3dPoint_color_(a3dPoint, DefaultColor());
	}

	/**
	 * Create a new instance of JunOpenGLParallelLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight
	 * @category Instance creation
	 */
	public static JunOpenGLParallelLight At3dPoint_color_(Jun3dPoint a3dPoint, Color aColor) {
		return At3dPoint_color_alpha_(a3dPoint, aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLParallelLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight
	 * @category Instance creation
	 */
	public static JunOpenGLParallelLight At3dPoint_color_alpha_(Jun3dPoint a3dPoint, Color aColor, float aNumber) {
		JunOpenGLParallelLight aLight = new JunOpenGLParallelLight();
		aLight.position_(a3dPoint);
		aLight.color_(aColor);
		aLight.alpha_(aNumber);
		return aLight;
	}

	/**
	 * Create a new instance of JunOpenGLParallelLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight
	 * @category Instance creation
	 */
	public static JunOpenGLParallelLight Direction_color_(Jun3dPoint a3dPoint, Color aColor) {
		return Direction_color_alpha_(a3dPoint, aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLParallelLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight
	 * @category Instance creation
	 */
	public static JunOpenGLParallelLight Direction_color_alpha_(Jun3dPoint a3dPoint, Color aColor, float aNumber) {
		JunOpenGLParallelLight aLight = new JunOpenGLParallelLight();
		aLight.direction_(a3dPoint);
		aLight.color_(aColor);
		aLight.alpha_(aNumber);
		return aLight;
	}

	/**
	 * Answer my current direction.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint direction() {
		return direction;
	}

	/**
	 * Set my new direction.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void direction_(Jun3dPoint a3dPoint) {
		direction = a3dPoint;
	}

	/**
	 * Answer my current position.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint position() {
		return (Jun3dPoint) this.direction().negated();
	}

	/**
	 * Set my new position.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public final void position_(Jun3dPoint a3dPoint) {
		this.direction_(a3dPoint.negated());
	}

	/**
	 * Lighting on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#lightingOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category lighting
	 */
	public void lightingOn_(JunOpenGLRenderingContext aRenderingContext) {
		int index = aRenderingContext.getLightIndex();
		aRenderingContext.lightIndex_position_direction_cutoffAngle_color_alpha_(index, null, this.direction(), null, this.color(), this.alpha());
		aRenderingContext.enableLightIndex_(index);
		aRenderingContext.enableLighting();
	}

	/**
	 * Transformation on the light.
	 * 
	 * @param aJun3dTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLLight
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#transform_(jp.co.sra.jun.geometry.transformations.Jun3dTransformation)
	 * @category transforming
	 */
	public JunOpenGLLight transform_(Jun3dTransformation aJun3dTransformation) {
		JunOpenGLParallelLight transformed = (JunOpenGLParallelLight) this.copy();
		transformed.direction_(this.direction().transform_(aJun3dTransformation).minus_(Jun3dPoint.Zero().transform_(aJun3dTransformation)));
		return transformed;
	}

}
