package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.smalltalk.StValued;

import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunOpenGLLight class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/10/23 (by MATSUDA Ryouichi)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLLight.java,v 8.12 2008/02/20 06:32:34 nisinaka Exp $
 */
public abstract class JunOpenGLLight extends JunAbstractObject implements StValued {

	protected Color color = Color.white;
	protected float alpha = 1.0f;

	/**
	 * Answer the default color.
	 * 
	 * @return java.awt.Color
	 * @category Defaults
	 */
	public static final Color DefaultColor() {
		return Color.white;
	}

	/**
	 * Answer the default alpha.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultAlpha() {
		return 1.0f;
	}

	/**
	 * Create a new instance of JunOpenGLLight and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunOpenGLLight() {
		super();
	}

	/**
	 * Answer my current color.
	 * 
	 * @return java.awt.Color
	 * @category accessing
	 */
	public Color color() {
		return color;
	}

	/**
	 * Set my new color.
	 * 
	 * @param aColor java.awt.Color
	 * @category accessing
	 */
	public void color_(Color aColor) {
		color = aColor;
	}

	/**
	 * Answer my current alpha.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float alpha() {
		return alpha;
	}

	/**
	 * Set my new alpha.
	 * 
	 * @param aNumber float
	 * @category accessing
	 */
	public void alpha_(float aNumber) {
		alpha = aNumber;
	}

	/**
	 * Answer the value.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object value() {
		return this;
	}

	/**
	 * Lighting on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category lighting
	 */
	public abstract void lightingOn_(JunOpenGLRenderingContext aRenderingContext);

	/**
	 * Answer true if the receiver is a kind of JunOpenGLLight, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isLight() {
		return true;
	}

	/**
	 * Transformation on the light.
	 * 
	 * @param aJun3dTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLLight
	 * @category transforming
	 */
	public abstract JunOpenGLLight transform_(Jun3dTransformation aJun3dTransformation);

}
