package jp.co.sra.jun.opengl.illusion;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLIllusionTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/09/27 (by nisinaka)
 *  @updated   2006/10/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun655 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLIllusionTestExamples.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLIllusionTestExamples extends JunTestExamples {
	/**
	 * Example_1 : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_1() {
		JunOpenGLDisplayModel displayModel = JunOpenGLIllusion.FaceDisplayModelFor_(JunOpenGLIllusion.Face());
		displayModel.open();
		displayModel.grabButton().value_(true);
		JunOpenGLDisplayController aController = (JunOpenGLDisplayController) displayModel.getController();
		aController.movementVector_(new Jun2dPoint(-0.05, 0));
		aController.createMovementProcess();

		return true;
	}

	/**
	 * Example_2 : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_2() {
		JunOpenGLDisplayModel displayModel = JunOpenGLIllusion.FaceDisplayModelFor_(JunOpenGLIllusion.FaceWithBoundingBoxAndAxes());
		displayModel.open();
		displayModel.grabButton().value_(true);
		JunOpenGLDisplayController aController = (JunOpenGLDisplayController) displayModel.getController();
		aController.movementVector_(new Jun2dPoint(-0.05, 0));
		aController.createMovementProcess();

		return true;
	}

	/**
	 * Example_3 : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_3() {
		JunOpenGLDisplayModel displayModel = JunOpenGLIllusion.FaceDisplayModelFor_(JunOpenGLIllusion.Face());
		displayModel.open();
		displayModel.grabButton().value_(true);
		JunOpenGLDisplayController aController = (JunOpenGLDisplayController) displayModel.getController();
		aController.movementVector_(new Jun2dPoint(0, -0.05));
		aController.createMovementProcess();

		return true;
	}

	/**
	 * Example_4 : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_4() {
		JunOpenGLDisplayModel displayModel = JunOpenGLIllusion.FaceDisplayModelFor_(JunOpenGLIllusion.FaceWithBoundingBoxAndAxes());
		displayModel.open();
		displayModel.grabButton().value_(true);
		JunOpenGLDisplayController aController = (JunOpenGLDisplayController) displayModel.getController();
		aController.movementVector_(new Jun2dPoint(0, -0.05));
		aController.createMovementProcess();

		return true;
	}

	/**
	 * Example_5a : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_5a() {
		JunOpenGLIllusion.FaceIllusionMovie1();
		return true;
	}

	/**
	 * Example_5a : Shows JunOpenGLIllusion.
	 * 
	 * @return boolean
	 * @category Examples Illusion
	 */
	public static boolean Example_5b() {
		JunOpenGLIllusion.FaceIllusionMovie2();
		return true;
	}

	/**
	 * Example01_1 : Shows JunOpenGLIllusion01.
	 * 
	 * @return boolean
	 * @category Examples Illusion01
	 */
	public static boolean Example01_1() {
		JunOpenGLIllusion illusion = new JunOpenGLIllusion01();
		illusion.show();

		return true;
	}

	/**
	 * Example01_2 : Shows JunOpenGLIllusion01.
	 * 
	 * @return boolean
	 * @category Examples Illusion01
	 */
	public static boolean Example01_2() {
		JunOpenGLIllusion illusion = new JunOpenGLIllusion01();
		illusion.frameFactor_(2);
		illusion.frameFactorOfStageAt_put_(3, 4);
		illusion.frameFactorOfStageAt_put_(4, 3);
		illusion.show();

		return true;
	}

	/**
	 * Example01_3 : Shows JunOpenGLIllusion01.
	 * 
	 * @return boolean
	 * @category Examples Illusion01
	 */
	public static boolean Example01_3() {
		JunOpenGLIllusion illusion = new JunOpenGLIllusion01();
		illusion.framesPerSecond_(2);
		illusion.show();

		return true;
	}

	/**
	 * Example02_1 : Shows JunOpenGLIllusion02.
	 * 
	 * @return boolean
	 * @category Examples Illusion02
	 */
	public static boolean Example02_1() {
		JunOpenGLIllusion illusion = new JunOpenGLIllusion02();
		illusion.show();

		return true;
	}

	/**
	 * Example02_2 : Shows JunOpenGLIllusion02.
	 * 
	 * @return boolean
	 * @category Examples Illusion02
	 */
	public static boolean Example02_2() {
		JunOpenGLIllusion02 illusion = new JunOpenGLIllusion02();
		illusion.numberOfParts_(15);
		illusion.colorBar().cyanBounds_(new double[] { 0, 0 });
		illusion.colorBar().magentaBounds_(new double[] { 0, 1 });
		illusion.colorBar().yellowBounds_(new double[] { 0, 1 });
		illusion.show();

		return true;
	}

	/**
	 * Example02_3 : Shows JunOpenGLIllusion02.
	 * 
	 * @return boolean
	 * @category Examples Illusion02
	 */
	public static boolean Example02_3() {
		JunOpenGLIllusion02 illusion = new JunOpenGLIllusion02();
		illusion.numberOfParts_(15);
		illusion.colorBar().cyanBounds_(new double[] { 0, 1 });
		illusion.colorBar().magentaBounds_(new double[] { 0, 1 });
		illusion.colorBar().yellowBounds_(new double[] { 0, 0 });
		for (int stageIndex = 1; stageIndex <= illusion.numberOfStages(); stageIndex++) {
			int localIndex = stageIndex % 3;
			if (localIndex == 1) {
				illusion.frameFactorOfStageAt_put_(stageIndex, 3);
			} else if (localIndex == 2) {
				illusion.frameFactorOfStageAt_put_(stageIndex, 4);
			} else if (localIndex == 0) {
				illusion.frameFactorOfStageAt_put_(stageIndex, 2);
			}
		}
		illusion.show();

		return true;
	}

	/**
	 * Example02_4 : Shows JunOpenGLIllusion02.
	 * 
	 * @return boolean
	 * @category Examples Illusion02
	 */
	public static boolean Example02_4() {
		JunOpenGLIllusion02 illusion = new JunOpenGLIllusion02();
		illusion.framesPerSecond_(10);
		illusion.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLIllusionTestExamples();
	}
}
