package jp.co.sra.jun.opengl.grapher;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dNodeTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/12/15 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dNodeTestExamples.java,v 8.10 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGL3dNodeTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dNode node = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(10, 20, 30), new Jun3dPoint(1, 2, 3), JunOpenGL3dObject.SampleColor());
		JunOpenGLDisplayModel.Show_(node);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dNode node = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(10, 20, 30), new Jun3dPoint(1, 2, 3), JunOpenGL3dObject.SampleColor());
		JunLispList list = node.showLispList();
		node = new JunOpenGL3dNode(list);
		node.showLispList();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		String string = "Smalltalk";
		JunOpenGLTexture texture = JunOpenGLTexture.TextureForString_foreColor_backColor_(string, Color.red, Color.green);
		JunOpenGL3dNode node = JunOpenGL3dNode.Location_extent_entity_(new Jun3dPoint(10, 20, 30), new Jun3dPoint(texture.width(), texture.height(), 10), string);
		node.texture_(texture);
		JunOpenGLDisplayModel.Show_(node);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGL3dNodeTestExamples();
	}
}
