package jp.co.sra.jun.opengl.grapher;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dGraphTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/12/07 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dGraphTestExamples.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGL3dGraphTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dNode node1 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node2 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node3 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dArc arc1 = JunOpenGL3dArc.From_to_(node1, node2);
		JunOpenGL3dArc arc2 = JunOpenGL3dArc.From_to_(node1, node3);
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.addNode_(node1);
		graph.addNode_(node2);
		graph.addNode_(node3);
		graph.addArc_(arc1);
		graph.addArc_(arc2);
		graph.arrange();
		graph.show();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dNode node1 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node2 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node3 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node4 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node5 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node6 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dArc arc1 = JunOpenGL3dArc.From_to_(node1, node2);
		JunOpenGL3dArc arc2 = JunOpenGL3dArc.From_to_(node1, node3);
		JunOpenGL3dArc arc3 = JunOpenGL3dArc.From_to_(node2, node5);
		JunOpenGL3dArc arc4 = JunOpenGL3dArc.From_to_(node4, node6);
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.addNode_(node1);
		graph.addNode_(node2);
		graph.addNode_(node3);
		graph.addNode_(node4);
		graph.addNode_(node5);
		graph.addNode_(node6);
		graph.addArc_(arc1);
		graph.addArc_(arc2);
		graph.addArc_(arc3);
		graph.addArc_(arc4);
		graph.arrange();
		graph.show();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_(_SubclassHierachyLispStringForMagnitude());
		final JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);

		final JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.displayObject_(graph);
		grapher.open();

		graph.arrange_(new StBlockClosure() {
			public Object value_(Object each) {
				JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
					public Object value() {
						graph.flushDisplayObject();
						grapher.resetView();
						return null;
					}
				}, JunSensorUtility.ShiftDown() ? 0 : 8);
				return null;
			}
		});

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForStream()));
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(2, 1, 4));
		graph.arrange();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);
				node.texture_(JunOpenGLTexture.TextureForString_foreColor_backColor_(node.entity().toString(), Color.black, color));
				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) each;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);
				return null;
			}
		});
		graph.flushDisplayObject();
		graph.show();

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForMagnitude())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForCollection())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForStream())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForView())));
		graph.arrange2();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);
				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) each;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);
				return null;
			}
		});
		graph.flushDisplayObject();
		graph.show();

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForObject()));
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(10, 1, 1));
		graph.arrange2();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);
				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) each;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);
				return null;
			}
		});
		graph.flushDisplayObject();
		graph.show();

		return true;
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_(_SubclassHierachyLispStringForMagnitude());
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrange();
		list = (JunLispCons) graph.showLispList();

		JunOpenGL3dGraph graph2 = new JunOpenGL3dGraph(list);
		graph2.showLispList();

		return true;
	}

	/**
	 * Example8:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dNode node1 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node2 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node3 = JunOpenGL3dNode.Extent_color_(new Jun3dPoint(3, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dArc arc1 = JunOpenGL3dArc.From_to_(node1, node2);
		JunOpenGL3dArc arc2 = JunOpenGL3dArc.From_to_(node1, node3);
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.addNode_(node1);
		graph.addNode_(node2);
		graph.addNode_(node3);
		graph.addArc_(arc1);
		graph.addArc_(arc2);
		graph.arrange();

		JunLispCons list = (JunLispCons) graph.showLispList();
		graph = new JunOpenGL3dGraph(list);
		graph.showLispList();

		return true;
	}

	/**
	 * ExampleZ:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleZ() {
		_ExampleGraph().show();

		return true;
	}

	/**
	 * Answer the example graph.
	 * 
	 * @return jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraph
	 */
	protected static JunOpenGL3dGraph _ExampleGraph() {
		JunLispList list = (JunLispCons) JunLispParser.Parse_((_SubclassHierachyLispStringForMagnitude()));
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(2, 1, 4));
		graph.arrange2();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object object) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) object;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);
				node.texture_(JunOpenGLTexture.TextureForString_foreColor_backColor_(node.entity().toString(), Color.black, color));
				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object object) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) object;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);
				arc.crank_(true);
				return null;
			}
		});
		graph.flushDisplayObject();

		return graph;
	}

	/**
	 * Answer the sbuclass hierachy lisp string for collection.
	 * 
	 * @return java.lang.String
	 */
	protected static String _SubclassHierachyLispStringForCollection() {
		return "(Collection (Bag)" + "  (KeyedCollection (ColorPreferencesCollection (ChainedColorPreferences)" + "      (ColorPreferencesDictionary)" + "      (LookPreferences))" + "    (MethodDictionary)" + "    (Palette (ColorPalette (FixedPalette)"
				+ "        (MappedPalette (MonoMappedPalette)))" + "      (CoveragePalette))" + "    (StopsDictionary))" + "  (LensContainer (LensBaseContainer)" + "    (LensCompositeContainer))"
				+ "  (SequenceableCollection (ArrayedCollection (Array (BOSSReaderMap)" + "        (DependentsCollection)" + "        (JunLispScannerTable)" + "        (JunLispSmallTypeTable)" + "        (JunVrmlKeywordTable (JunVrmlKeywordTable10)"
				+ "	  (JunVrmlKeywordTable20))" + "        (JunVrmlScannerTable (JunVrmlScannerTable10)" + "	  (JunVrmlScannerTable20))" + "        (ScannerTable)" + "        (SegmentedCollection (LargeArray)" + "	  (LargeWordArray)))"
				+ "      (CharacterArray (String (ByteEncodedString (ByteString)" + "	    (ISO8859L1String)" + "	    (MacString)" + "	    (OS2String))" + "	  (GapString)" + "	  (Symbol (ByteSymbol)" + "	    (TwoByteSymbol))" + "	  (TwoByteString))"
				+ "        (Text))" + "      (IntegerArray (ByteArray (BinaryStorageBytes)" + "	  (BOSSBytes))" + "        (WordArray))" + "      (List (DependentList)" + "        (LensStreamList))" + "      (RunArray)" + "      (TableAdaptor)"
				+ "      (TwoDList)" + "      (WeakArray))" + "    (Interval (SlidingInterval)" + "      (TextLineInterval))" + "    (JunGraph (JunTree)" + "      (JunUndirectedGraph))" + "    (JunLispList (JunLispCons)" + "      (JunLispNil))"
				+ "    (JunSequence (JunAbstractMatrix (JunBooleanMatrix)" + "        (JunMatrix (JunLinearEquations)))" + "      (JunSingleLinkedList (JunDoubleLinkedList)))" + "    (LinkedList (HandlerList)" + "      (Semaphore))"
				+ "    (OrderedCollection (FontDescriptionBundle)" + "      (LinkedOrderedCollection)" + "      (SortedCollection (SortedCollectionWithPolicy)" + "        (SPActiveLines)" + "        (SPSortedLines))))"
				+ "  (Set (Dictionary (CEnvironment)" + "      (IdentityDictionary (PropertyListDictionary)" + "        (WeakDictionary (HandleRegistry (ExternalRegistry))"
				+ "	  (WeakAssociationDictionary (LinkedWeakAssociationDictionary (ExternalDictionary)))))" + "      (LensLinkedDictionary (LensProtectedLinkedDictionary))" + "      (LensRegistry (LensWeakRegistry (LensObjectRegistry)))"
				+ "      (PoolDictionary (SystemDictionary)))" + "    (IdentitySet (ObjectRegistry)" + "      (SignalCollection))))" + "";
	}

	/**
	 * Answer the subclass hierachy lisp string for magnitude.
	 * 
	 * @return java.lang.String
	 */
	protected static String _SubclassHierachyLispStringForMagnitude() {
		return "(Magnitude (ArithmeticValue (Number (FixedPoint)" + "      (Fraction)" + "      (Integer (LargeInteger (LargeNegativeInteger)" + "	  (LargePositiveInteger))" + "        (SmallInteger))" + "      (LimitedPrecisionReal (Double)"
				+ "        (Float)))" + "    (Point))" + "  (Character)" + "  (Date)" + "  (LookupKey (Association (LensLinkedAssociation)" + "      (WeakKeyAssociation))" + "    (VariableBinding))" + "  (Time))" + "";
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 */
	protected static String _SubclassHierachyLispStringForObject() {
		return "(Object (Behavior (ClassDescription (Class)" + "      (Metaclass)))" + "  (BinaryObjectStorage (HelpAccessor))" + "  (BlockClosure)" + "  (Boolean (False)" + "    (True))" + "  (Border (EtchedBorder))"
				+ "  (BorderDecorationPolicy (EmulationBorderDecorationPolicy (CUABorderDecorationPolicy)" + "      (MacBorderDecorationPolicy)" + "      (MotifBorderDecorationPolicy)" + "      (Win3BorderDecorationPolicy))"
				+ "    (SmalltalkBorderDecorationPolicy))" + "  (BOSSCompiledCodeHolder)" + "  (BOSSContents)" + "  (BOSSRegisteredObject)" + "  (BOSSSpecialObjectLoader)" + "  (BOSSTransporter (BOSSReader (BOSSDebugReader))" + "    (BOSSWriter))"
				+ "  (ByteCodeStream (CodeStream (RecodeStream)))" + "  (ByteFieldDescriptor)" + "  (CDatum (CArray)" + "    (CComposite)" + "    (CPointer (CCompositePointer))" + "    (CProcedurePointer (CCallback)))" + "  (CellProperties)"
				+ "  (Change (ClassRelatedChange (ClassChange (ClassDefinitionChange)" + "        (ClassOtherChange (ClassCommentChange)))" + "      (MethodChange (MethodDefinitionChange)" + "        (MethodOtherChange)))" + "    (OtherChange))"
				+ "  (CharacterAttributes (VariableCharacterAttributes (PlatformCharacterAttributes)))" + "  (CharacterComposer)" + "  (CharacterEncoder (ByteCharacterEncoder)" + "    (LargeCharacterEncoder)" + "    (ShiftJISCharacterEncoder)"
				+ "    (UnicodeCharacterEncoder))" + "  (ClassBuilder)" + "  (ClassCategoryReader)" + "  (ClassOrganizer (SystemOrganizer))" + "  (CMacroDefinition)" + "  (CodeLabel)" + "  (CodeReader)" + "  (Collection (Bag)"
				+ "    (KeyedCollection (ColorPreferencesCollection (ChainedColorPreferences)" + "        (ColorPreferencesDictionary)" + "        (LookPreferences))" + "      (MethodDictionary)" + "      (Palette (ColorPalette (FixedPalette)"
				+ "	  (MappedPalette (MonoMappedPalette)))" + "        (CoveragePalette))" + "      (StopsDictionary))" + "    (LensContainer (LensBaseContainer)" + "      (LensCompositeContainer))"
				+ "    (SequenceableCollection (ArrayedCollection (Array (BOSSReaderMap)" + "	  (DependentsCollection)" + "	  (JunLispScannerTable)" + "	  (JunLispSmallTypeTable)" + "	  (JunVrmlKeywordTable (JunVrmlKeywordTable10)"
				+ "	    (JunVrmlKeywordTable20))" + "	  (JunVrmlScannerTable (JunVrmlScannerTable10)" + "	    (JunVrmlScannerTable20))" + "	  (ScannerTable)" + "	  (SegmentedCollection (LargeArray)" + "	    (LargeWordArray)))"
				+ "        (CharacterArray (String (ByteEncodedString (ByteString)" + "	      (ISO8859L1String)" + "	      (MacString)" + "	      (OS2String))" + "	    (GapString)" + "	    (Symbol (ByteSymbol)" + "	      (TwoByteSymbol))"
				+ "	    (TwoByteString))" + "	  (Text))" + "        (IntegerArray (ByteArray (BinaryStorageBytes)" + "	    (BOSSBytes))" + "	  (WordArray))" + "        (List (DependentList)" + "	  (LensStreamList))" + "        (RunArray)"
				+ "        (TableAdaptor)" + "        (TwoDList)" + "        (WeakArray))" + "      (Interval (SlidingInterval)" + "        (TextLineInterval))" + "      (JunGraph (JunTree)" + "        (JunUndirectedGraph))"
				+ "      (JunLispList (JunLispCons)" + "        (JunLispNil))" + "      (JunSequence (JunAbstractMatrix (JunBooleanMatrix)" + "	  (JunMatrix (JunLinearEquations)))" + "        (JunSingleLinkedList (JunDoubleLinkedList)))"
				+ "      (LinkedList (HandlerList)" + "        (Semaphore))" + "      (OrderedCollection (FontDescriptionBundle)" + "        (LinkedOrderedCollection)" + "        (SortedCollection (SortedCollectionWithPolicy)" + "	  (SPActiveLines)"
				+ "	  (SPSortedLines))))" + "    (Set (Dictionary (CEnvironment)" + "        (IdentityDictionary (PropertyListDictionary)" + "	  (WeakDictionary (HandleRegistry (ExternalRegistry))"
				+ "	    (WeakAssociationDictionary (LinkedWeakAssociationDictionary (ExternalDictionary)))))" + "        (LensLinkedDictionary (LensProtectedLinkedDictionary))" + "        (LensRegistry (LensWeakRegistry (LensObjectRegistry)))"
				+ "        (PoolDictionary (SystemDictionary)))" + "      (IdentitySet (ObjectRegistry)" + "        (SignalCollection))))" + "  (ColumnReorderAgent)" + "  (ColumnResizeAgent)" + "  (CompiledCode (CompiledBlock)"
				+ "    (CompiledMethod (AnnotatedMethod (MarkedMethod))" + "      (ExternalMethod)))" + "  (CompilerErrorHandler (InteractiveCompilerErrorHandler)" + "    (LoggingCompilerErrorHandler)"
				+ "    (NonInteractiveCompilerErrorHandler (QueryCompilerErrorHandler))" + "    (SilentCompilerErrorHandler))" + "  (ComposedBlock)" + "  (CompoundTextEncodingDefinition)" + "  (CompoundTextStateNode)"
				+ "  (Controller (ComboBoxButtonController)" + "    (ControllerWithMenu (BitEditor (ColorBitEditor))" + "      (DataSetController (PaintedDataSetController))" + "      (JunDisplayController (JunZoomableDisplayController))"
				+ "      (JunOpenGLDisplayController (JunOpenGLEmbeddedDisplayController)" + "        (JunOpenGLPlotterController))" + "      (JunOpenGLRotationController)" + "      (JunOpenGLShowController)" + "      (LDMCompositeViewController)"
				+ "      (LDMElementViewController)" + "      (ModalController (UIPainterController))" + "      (ParagraphEditor (TextEditorController (InputBoxController (ComboBoxInputBoxController))))"
				+ "      (SequenceController (ComboBoxListController)" + "        (EmulatedSequenceController)))" + "    (DataSetControllerProxy)" + "    (JunButtonController)" + "    (JunColorChoiceController)" + "    (JunGaugeController)"
				+ "    (JunHistogramController)" + "    (JunPlotterController)" + "    (JunThumbWheelController)" + "    (JunTrackSliderController)" + "    (LauncherController)" + "    (MenuBarButtonController)"
				+ "    (MenuController (MenuAsPopUpController)" + "      (MenuAsSubmenuController)" + "      (MenuFromMenuBarController)" + "      (MenuFromMenuButtonController))" + "    (MenuItemController)" + "    (NoController)"
				+ "    (ScrollbarController (EmulationScrollBarController))" + "    (SelectController (BasicButtonController (ToggleButtonController (RadioButtonController))" + "        (TriggerButtonController))" + "      (ColoredAreaController)"
				+ "      (MenuButtonController)" + "      (SliderController)" + "      (TabBarController))" + "    (StandardSystemController (ApplicationStandardSystemController (ApplicationDialogController (DropDownListController))"
				+ "        (UIPainterSystemController)))" + "    (WidgetController))" + "  (ControlManager)" + "  (ControlMode (DrawingMode (DragMode (CornerDragMode)" + "        (DividerResizingDragMode)" + "        (NullDragMode)"
				+ "        (OrientationResizeMode)" + "        (SelectionDragMode)" + "        (SpecDragMode (PlacementMode (DragPlacementMode)" + "	    (SelectPlacementMode))))" + "      (SelectMode)))" + "  (CStructureLayout)"
				+ "  (CType (CCompoundType (CCompositeType)" + "      (CEnumerationType))" + "    (COopType)" + "    (CPointerType (CArrayType))" + "    (CProcedureType)" + "    (CQualifiedType (CTypedefType))" + "    (CScalarType (CIntegerType)"
				+ "      (CLimitedPrecisionRealType))" + "    (CVoidType))" + "  (DatabaseCommand)" + "  (DatabaseTypeMapping)" + "  (DataSetColumn)" + "  (DeferredBlock)" + "  (DefineOpcodePool)" + "  (Delay)" + "  (DependencyTransformer)" + "  (Dialog)"
				+ "  (DispatchTable)" + "  (DitherUpTo4)" + "  (Document)" + "  (DocumentRenderer)" + "  (DragDropContext)" + "  (DragDropData)" + "  (DragDropManager)" + "  (DropSource (ConfigurableDropSource))"
				+ "  (DropTarget (ConfigurableDropTarget))" + "  (DSVDependencyAgent)" + "  (EncodedStreamConstructor (ExternalEncodedStreamConstructor)" + "    (FileEncodedStreamConstructor)" + "    (InternalEncodedStreamConstructor))" + "  (Exception)"
				+ "  (ExternalConnection (FileConnection))" + "  (ExternalDatabaseBuffer)" + "  (ExternalDatabaseColumnDescription)" + "  (ExternalDatabaseError)" + "  (ExternalDatabaseFramework (ExternalDatabaseConnection)"
				+ "    (ExternalDatabaseSession)" + "    (ExternalDatabaseTransaction))" + "  (ExternalInterface (InputManager (MSWindowsInputManager)" + "      (NullInputManager)" + "      (X11InputManager))" + "    (JunOpenGLInterface)"
				+ "    (JunWin32Interface)" + "    (OSSystemSupport (MacSystemSupport (PowerMacSystemSupport))" + "      (OS2SystemSupport)" + "      (UnixSystemSupport)" + "      (Win32sSystemSupport)"
				+ "      (Win95SystemSupport (WinNTSystemSupport))))" + "  (ExternalInterfaceHolder)" + "  (ExternalLibrary)" + "  (ExternalLibraryHolder)" + "  (ExternalObject (ExternalProcedure)" + "    (ExternalVariable))" + "  (Filename (MacFilename)"
				+ "    (PCFilename (FATFilename)" + "      (HPFSFilename)" + "      (NTFSFilename))" + "    (UnixFilename))" + "  (FontDescription)" + "  (FontPolicy)" + "  (Geometric (Bezier)" + "    (Circle)" + "    (EllipticalArc)"
				+ "    (LineSegment)" + "    (Polyline)" + "    (Rectangle (CharacterBlock))" + "    (Spline))" + "  (GraphicsAttributes)" + "  (GraphicsContext (HostPrinterGraphicsContext)" + "    (PostScriptGraphicsContext)"
				+ "    (ScreenGraphicsContext))" + "  (GraphicsDevice (HostGraphicsDevice (HostPrinter)" + "      (Screen))" + "    (PostScriptPrinter)" + "    (Printer))" + "  (GraphicsMedium (DisplaySurface (UnmappableSurface (Mask)"
				+ "        (Pixmap))" + "      (Window (ScheduledWindow (ApplicationWindow))" + "        (TransientWindow)))" + "    (HostPrintJob)" + "    (MockMedium)" + "    (PostScriptFile))" + "  (HelpElement (HelpBook)" + "    (HelpChapter)"
				+ "    (HelpExample)" + "    (HelpLibrary)" + "    (HelpPage))" + "  (HelpForwarder)" + "  (HelpSeeAlso)" + "  (ImageReader (BMPImageReader))" + "  (ImageRenderer (ErrorDiffusion)" + "    (PaintRenderer (NearestPaint)"
				+ "      (OrderedDither)))" + "  (ImplementationFont (CompositeFont)" + "    (DeviceFont (PostScriptPrinterFont)" + "      (ScreenFont (MacFont)" + "        (MSWindowsFont (OS2Font))" + "        (XFont)))" + "    (SyntheticFont))"
				+ "  (InputSensor (TranslatingSensor)" + "    (WindowSensor (ApplicationWindowSensor)))" + "  (InputState)" + "  (InstructionClient (InstructionPrinter)" + "    (InstructionStream (CodeRegenerator)" + "      (Context (BlockContext)"
				+ "        (MethodContext))" + "      (Decompiler)))" + "  (InverseColorMap)" + "  (InverseColorMapInitializer)" + "  (IOBuffer (PositionalIOBuffer))" + "  (JunBitField)" + "  (JunBlueButtonMenuEnhancements)"
				+ "  (JunBrowserMenuEnhancements)" + "  (JunBSplineFunction)" + "  (JunChangeSourceEncoder)" + "  (JunChartData (JunChartDataWithNumericalKeys))" + "  (JunChartDataSheet)" + "  (JunClassReview (JunCodeReview))" + "  (JunColorSpuit)"
				+ "  (JunCursorAnimator)" + "  (JunCursors)" + "  (JunEncyclopedia)" + "  (JunFromUser)" + "  (JunGeometry (JunAngle)" + "    (JunBoundingBox (Jun2dBoundingBox)" + "      (Jun3dBoundingBox))" + "    (JunCoordinateAngles)"
				+ "    (JunCoordinateSystem (Jun2dCoordinateSystem)" + "      (Jun3dCoordinateSystem))" + "    (JunCurve (JunLine (Jun2dLine)" + "        (Jun3dLine))" + "      (JunNurbsCurve))" + "    (JunEulerianAngles (JunEulerianAnglesXYZ)"
				+ "      (JunEulerianAnglesZYZ))" + "    (JunLocalGeometry)" + "    (JunPoint (Jun2dPoint)" + "      (Jun3dPoint))" + "    (JunSurface (JunCompoundSurface)" + "      (JunNurbsSurface)" + "      (JunPlane (JunPolygon))"
				+ "      (JunSphere)" + "      (JunSphereSurface))" + "    (JunTransformation (Jun2dTransformation)" + "      (Jun3dTransformation)))" + "  (JunGeometryTransformer)" + "  (JunGraphNode)" + "  (JunHistoryNode)" + "  (JunHtmlReportWriter)"
				+ "  (JunImageDispenser)" + "  (JunImageProcessor)" + "  (JunImageStream (JunBmpImageStream)" + "    (JunBosImageStream)" + "    (JunGifImageStream)" + "    (JunJpegImageStream)" + "    (JunPictImageStream))" + "  (JunJAVAImageTransfer)"
				+ "  (JunJAVALispTransfer)" + "  (JunJAVATransfer)" + "  (JunKeyboardMapEnhancements)" + "  (JunLispScanner (JunLispParser))" + "  (JunLispSmallCompiler)" + "  (JunLispTable)" + "  (JunMessageTransformer)" + "  (JunNashSVD)"
				+ "  (JunOpenGL2dTrimCurve (JunOpenGL2dTrimPolylineLoop))" + "  (JunOpenGL3dObject (JunOpenGL3dCompoundObject)" + "    (JunOpenGL3dPrimitiveObject (JunOpenGL3dNurbsCurve)" + "      (JunOpenGL3dNurbsSurface)"
				+ "      (JunOpenGL3dTransformedObject)" + "      (JunOpenGL3dVertex)" + "      (JunOpenGL3dVertexesObject (JunOpenGL3dPolygon)" + "        (JunOpenGL3dPolyline (JunOpenGL3dPolylineLoop)))))"
				+ "  (JunOpenGLDisplayObjectPicker (JunOpenGLTopologicalElementPicker))" + "  (JunOpenGLFluxAbstract (JunOpenGLFluxImmutableObject)" + "    (JunOpenGLFluxMutableObject)" + "    (JunOpenGLFluxObject))" + "  (JunOpenGLFluxMaker)"
				+ "  (JunOpenGLForeignHeap)" + "  (JunOpenGLLight (JunOpenGLAmbientLight)" + "    (JunOpenGLParallelLight)" + "    (JunOpenGLSpotLight))" + "  (JunOpenGLObjectPicker)" + "  (JunOpenGLProjection (JunOpenGLParallelProjection)"
				+ "    (JunOpenGLPerspective))" + "  (JunOpenGLProjector)" + "  (JunOpenGLRenderingContext (JunOpenGLDIBSectionRenderingContext (JunOpenGLPickingRenderingContext))" + "    (JunOpenGLWindowRenderingContext))" + "  (JunOpenGLStipple)"
				+ "  (JunOpenGLTexture)" + "  (JunPen)" + "  (JunPenGeometry (JunPenAngle)" + "    (JunPenDirection)" + "    (JunPenLocation)" + "    (JunPenTransformation))" + "  (JunRevisionManager)" + "  (JunScavenger)" + "  (JunSensorUtility)"
				+ "  (JunSingleLink (JunDoubleLink))" + "  (JunSolidModelingEngine)" + "  (JunSourceCodeChunks)" + "  (JunSourceCodeDifference)" + "  (JunSourceCodeSaver)" + "  (JunSpyRecord)" + "  (JunStandardLibraryEnhancements)" + "  (JunSVD)"
				+ "  (JunTopology (JunAbstractOperator (JunCompoundOperator)" + "      (JunEulerOperator (JunKCLMPL)" + "        (JunKDEV)" + "        (JunKEL)" + "        (JunKEML)" + "        (JunKEV)" + "        (JunKEVVL)" + "        (JunKVE)"
				+ "        (JunMCLKPL)" + "        (JunMDEV)" + "        (JunMEKL)" + "        (JunMEL)" + "        (JunMEV)" + "        (JunMEVVL)" + "        (JunMVE))" + "      (JunGeometricOperator (JunKCV)" + "        (JunKSF)" + "        (JunMCV)"
				+ "        (JunMSF)" + "        (JunTCV)" + "        (JunTSF)" + "        (JunTV))" + "      (JunGlobalOperator (JunADD)" + "        (JunLineSCALE)" + "        (JunMIRROR)" + "        (JunMOVE)" + "        (JunNEGATE)"
				+ "        (JunPlaneSCALE)" + "        (JunPointSCALE)" + "        (JunROTATE)" + "        (JunSEPARATE))" + "      (JunSetOperator (JunDIFF)" + "        (JunINTER)" + "        (JunUNION)))" + "    (JunTopologicalElement (JunBody)"
				+ "      (JunEdge)" + "      (JunLoop)" + "      (JunVertex))" + "    (JunTopologicalElementProxy (JunEdgeProxy)" + "      (JunLoopProxy)" + "      (JunVertexProxy)))" + "  (JunTranscriptFile)" + "  (JunTreeNode (JunCategoryTreeNode)"
				+ "    (JunClassTreeNode)" + "    (JunObjectTreeNode))" + "  (JunUndeclarationCheck)" + "  (JunUniFileName)" + "  (JunVisualTransporter)" + "  (JunVoronoi2dObject (JunVoronoi2dDot (JunVoronoi2dPoint))" + "    (JunVoronoi2dLine)"
				+ "    (JunVoronoi2dProcessor)" + "    (JunVoronoi2dSide)" + "    (JunVoronoi2dTriangle))" + "  (JunVrmlCompiler)" + "  (JunVrmlField (JunVrmlMFField (JunVrmlMFColorField)" + "      (JunVrmlMFFloatField)" + "      (JunVrmlMFLongField)"
				+ "      (JunVrmlMFStringField)" + "      (JunVrmlMFVec2fField)" + "      (JunVrmlMFVec3fField))" + "    (JunVrmlSFField (JunVrmlSFBoolField)" + "      (JunVrmlSFEnumField)" + "      (JunVrmlSFFloatField)" + "      (JunVrmlSFImageField)"
				+ "      (JunVrmlSFRotationField)" + "      (JunVrmlSFStringField)" + "      (JunVrmlSFVec3fField)))" + "  (JunVrmlNode (JunVrmlAbstractGeometryNode (JunVrmlBoxNode)" + "      (JunVrmlCubeNode)" + "      (JunVrmlIndexedFaceSetNode10)"
				+ "      (JunVrmlIndexedFaceSetNode20)" + "      (JunVrmlIndexedLineSetNode10)" + "      (JunVrmlIndexedLineSetNode20)" + "      (JunVrmlSphereNode))" + "    (JunVrmlAbstractGroupingNode (JunVrmlSeparatorNode)" + "      (JunVrmlShapeNode)"
				+ "      (JunVrmlTransformNode))" + "    (JunVrmlAbstractPropertyNode (JunVrmlAppearanceNode)" + "      (JunVrmlCoordinate3Node)" + "      (JunVrmlCoordinateNode)" + "      (JunVrmlMaterialNode)" + "      (JunVrmlNavigationInfoNode)"
				+ "      (JunVrmlPixelTextureNode)" + "      (JunVrmlTexture2Node)" + "      (JunVrmlTextureCoordinateNode (JunVrmlTextureCoordinate2Node))" + "      (JunVrmlViewpointNode)" + "      (JunVrmlWorldInfoNode))" + "    (JunVrmlNull))"
				+ "  (JunVrmlNodeVisitor (JunVrmlGenerator (JunVrmlGenerator10)" + "      (JunVrmlGenerator20))" + "    (JunVrmlSemanticsChecker))" + "  (JunVrmlScanner (JunVrmlParser (JunVrmlParser10)" + "      (JunVrmlParser20)))"
				+ "  (JunVrmlSyntaxTreeBuilder (JunVrmlSyntaxTreeBuilder10)" + "    (JunVrmlSyntaxTreeBuilder20))" + "  (JunWaitUtility)" + "  (KeyboardEvent)" + "  (KeyboardProcessor)" + "  (Layout (LayoutOrigin (AlignmentOrigin)"
				+ "      (LayoutFrame)))" + "  (LDMAbstractVisualBuilder (LDMGraphBuilder (LDMProtoMapBuilder))" + "    (LDMIndentedListBuilder))" + "  (LDMArc)" + "  (LDMElementProxy (LDMReversingElementProxy))" + "  (LDMGraph)" + "  (LDMNodeChild)"
				+ "  (LDMPerspective)" + "  (LDMRelationsGenerator)" + "  (LDMRelationship (LDMFirstOrderRel (LDMSpecialRel))" + "    (LDMHighOrderRel (LDMDiadicRel (LDMComposedRel)" + "        (LDMOrRel))" + "      (LDMMonadicRel (LDMLimitingRel)"
				+ "        (LDMNonReflexiveRel)" + "        (LDMTransitiveClosureRel))))" + "  (LDMVariable (LDMFocusVariable))" + "  (LensBasicTransporter (LensSQLTransporter))" + "  (LensColumnSizeConstraint)" + "  (LensExceptionInfo)"
				+ "  (LensGlobalDescriptor)" + "  (LensMetadata (LensDatabaseContext)" + "    (LensDatabaseIndex)" + "    (LensDatabaseTable)" + "    (LensDatabaseTableColumn)" + "    (LensDataModel)" + "    (LensReferenceType)"
				+ "    (LensStructureVariable)" + "    (LensTableKey)" + "    (LensType (LensDataType)" + "      (LensEncodedType)" + "      (LensEnumerationType)" + "      (LensStructureType (LensCollectionType))))" + "  (LensPolicy)"
				+ "  (LensTransactionPolicy)" + "  (LensTranscoder)" + "  (LensWeakCollection)" + "  (LineInformationTable (OptimizedLineInformationTable))" + "  (Link (Process)" + "    (SignalHandler))" + "  (Locale)"
				+ "  (LocaleSensitiveDataReader (NumberReader)" + "    (TimestampReader))" + "  (Magnitude (ArithmeticValue (Number (FixedPoint)" + "        (Fraction)" + "        (Integer (LargeInteger (LargeNegativeInteger)"
				+ "	    (LargePositiveInteger))" + "	  (SmallInteger))" + "        (LimitedPrecisionReal (Double)" + "	  (Float)))" + "      (Point))" + "    (Character)" + "    (Date)" + "    (LookupKey (Association (LensLinkedAssociation)"
				+ "        (WeakKeyAssociation))" + "      (VariableBinding))" + "    (Time))" + "  (MC_BTreeNode)" + "  (MC_FileBTree)" + "  (MemoryPolicy)" + "  (Menu)" + "  (MenuAdornment)" + "  (MenuBuilder)" + "  (MenuItem)" + "  (MenuItemAdornment)"
				+ "  (Message (ExternalMessage)" + "    (MessageSend))" + "  (MessageCatalog (IndexedFileMessageCatalog))" + "  (MessageChannel)" + "  (MethodNodeHolder)" + "  (Model (ApplicationModel (AdHocQueryTool)" + "      (Browser (Debugger)"
				+ "        (HierarchyBrowser)" + "        (JunCategoryTreeBrowser)" + "        (JunTreeBrowser)" + "        (MethodListBrowser)" + "        (ParcelBrowser))" + "      (ChangeList)" + "      (CodingAssistant)" + "      (ExamplesBrowser)"
				+ "      (ExternalInterfaceBuilder)" + "      (ExternalInterfaceFinder)" + "      (FileBrowser)" + "      (HelpBrowser)" + "      (Inspector (ChangeSetInspector)" + "        (CompiledCodeInspector)" + "        (ContextInspector)"
				+ "        (DictionaryInspector)" + "        (JunTreeInspector)" + "        (SequenceableCollectionInspector (OrderedCollectionInspector)))" + "      (JunButtonModel)" + "      (JunColorChoiceModel (JunColorChoiceHBS)"
				+ "        (JunColorChoiceHSB)" + "        (JunColorChoiceSBH))" + "      (JunDisplayModel (JunZoomableDisplayModel))" + "      (JunDumpModel)" + "      (JunGaugeModel)" + "      (JunHistogramModel)" + "      (JunLauncher)"
				+ "      (JunLispInterpreter)" + "      (JunMessageSpy)" + "      (JunOpenGLDisplayLight)" + "      (JunOpenGLDisplayModel (JunChartAbstract (JunChartWithNumericalKeys (JunChartPlotWithNumericalKeys (JunChartLineWithNumericalKeys)))"
				+ "	  (JunChartWithRoundShape (JunChartPie)" + "	    (JunChartRadar))" + "	  (JunChartWithSymbolicKeys (JunChartBand)" + "	    (JunChartBar)" + "	    (JunChartPlot (JunChartLine))))" + "        (JunChartCombination)"
				+ "        (JunOpenGL3dGrapher)" + "        (JunOpenGLEmbeddedDisplayModel)" + "        (JunOpenGLFluxModel)" + "        (JunOpenGLPlotter)" + "        (JunTestSolidModelingVersionBrowser))" + "      (JunOpenGLRotationApplicationModel)"
				+ "      (JunOpenGLRotationModel)" + "      (JunOpenGLShowModel)" + "      (JunParameterizedBodyModel)" + "      (JunParameterModel)" + "      (JunParametersModel)" + "      (JunPlotter)" + "      (JunProgress)" + "      (JunThumbWheel)"
				+ "      (JunTrackSliderModel (JunTrackerModel))" + "      (JunTreeTest)" + "      (JunUniFileModel)" + "      (LabelConstructor)" + "      (LensApplicationModel (LensDataManager)" + "        (LensMainApplication (LensTemporaryMain)))"
				+ "      (LensApplicationSpecEditor)" + "      (LensApplicationStructureView)" + "      (LensBrowsingToolModel (LensGraphView))" + "      (LensEditor)" + "      (LensMappingEditor)" + "      (ParcelList)" + "      (QueryEditor)"
				+ "      (SimpleDialog (LensApplicationCreationDialog)" + "        (LensDataModelGenerator)" + "        (LensKeyEditor)" + "        (LensReferenceNameDialog)" + "        (LensTablesSelector)" + "        (SimpleHelp))"
				+ "      (SimpleListEditor)" + "      (SpecModel (IntegratedSpecModel (ColorToolModel)" + "	  (DataSetCallbacksSpecModel)" + "	  (DataSetSpecColumnDetailsModel)" + "	  (DataSetSpecColumnModel)" + "	  (PositionToolModel))"
				+ "        (LensDFBasicsSliceModel)" + "        (LensDFConnectionSliceModel))" + "      (UIFinderVW2)" + "      (UIPainter)" + "      (UIPainterWatcher (MenuEditor)" + "        (UICanvasTool)" + "        (UIMaskEditor)"
				+ "        (UIMenuEditor)" + "        (UIPropertiesTool))" + "      (UIPalette)" + "      (UISettings)" + "      (VisualLauncher))" + "    (ChangeSet)" + "    (Explainer)" + "    (JunOpenGLRotationPolyline)" + "    (JunPaintedBody)"
				+ "    (JunParameter)" + "    (JunParameterizedBody)" + "    (JunParameterizedOperator)" + "    (JunSystem)" + "    (JunTreeList)" + "    (LDMAbstractBody (LDMRelationsBody))" + "    (LDMBrowserModel)" + "    (LDMSelectionService)"
				+ "    (LensApplicationSpec)" + "    (LensSession)" + "    (ScrollValueHolder)" + "    (SelectionInList (MultiSelectionInList))" + "    (SelectionInTable)" + "    (SyntaxError)" + "    (TableInterface)"
				+ "    (UIDataReference (LensGraphReference (LensContainerReference)" + "        (LensVariableReference)))" + "    (ValueModel (ComputedValue (BlockValue))" + "      (JunImageHolder)" + "      (JunOpenGL3dGraphAbstract (JunOpenGL3dArc)"
				+ "        (JunOpenGL3dGraph)" + "        (JunOpenGL3dNode))" + "      (PluggableAdaptor (TypeConverter))" + "      (ProtocolAdaptor (AspectAdaptor)" + "        (IndexedAdaptor (SlotAdaptor)))" + "      (RangeAdaptor)"
				+ "      (ValueHolder (BufferedValueHolder)" + "        (HelpProxy)" + "        (LensRowHolder)" + "        (Project)" + "        (TextCollector))))" + "  (NameScope (LocalScope (LensScope))" + "    (NullScope)" + "    (StaticScope))"
				+ "  (ObjectMemory)" + "  (ObjectTracer (CodeWriteAnalysisTracer)" + "    (CodeWriter))" + "  (OSErrorHolder (OSHandle (Cursor)" + "      (ExternalProcess (UnixProcess))"
				+ "      (IOAccessor (BlockableIOAccessor (UnixIOAccessor (UnixDiskFileAccessor)" + "	    (UnixPipeAccessor)))" + "        (MacIOAccessor (MacDiskFileAccessor))" + "        (PCIOAccessor (PCDiskFileAccessor)))))" + "  (Paint (DevicePaint)"
				+ "    (Pattern)" + "    (SimplePaint (ColorValue)" + "      (CoverageValue))" + "    (SymbolicPaint (HierarchicalSymbolicPaint)))" + "  (PaintPolicy (LuminanceBasedColorPolicy))" + "  (Parcel)" + "  (PortableFilename)"
				+ "  (PostScriptFontBody)" + "  (PrintConverter)" + "  (PrintPolicy (NumberPrintPolicy)" + "    (StringPrintPolicy)" + "    (TimestampPrintPolicy))" + "  (ProcessHandle)" + "  (ProcessorScheduler)" + "  (ProgramNode (MethodNode)"
				+ "    (ParameterNode)" + "    (StatementNode (ReturnNode)" + "      (ValueNode (ArithmeticLoopNode)" + "        (AssignmentNode)" + "        (CascadeNode)" + "        (ConditionalNode)" + "        (LeafNode (BlockNode)"
				+ "	  (LiteralNode)" + "	  (VariableNode))" + "        (LoopNode)" + "        (SequenceNode)" + "        (SimpleMessageNode (MessageNode)))))" + "  (ProgramNodeBuilder (LensMethodGenerator))" + "  (ProgramNodeEnumerator (JunMethodReview)"
				+ "    (ReadBeforeWrittenTester))" + "  (Promise)" + "  (QueryOperation (LensQuery))" + "  (QueryOperationAccessor)" + "  (RangeMap)" + "  (RasterOp)" + "  (RecursionLock)" + "  (RemoteString)" + "  (ResourceRetriever)" + "  (RowAdaptor)"
				+ "  (Scanner (ChangeScanner)" + "    (CScanner (CParser (CExpressionParser (CDeclarationParser)" + "	  (CPreprocessor))))" + "    (MessageFileParser)" + "    (Parser (ExtendedParser)))" + "  (SequenceableCollectionSorter)"
				+ "  (SharedQueue)" + "  (Signal)" + "  (SimpleBorder (BeveledBorder)" + "    (Win3Border))" + "  (SmalltalkCompiler (Compiler (ExtendedCompiler)" + "      (LensCompiler)" + "      (QueryCompiler)))"
				+ "  (SourceFileManager (SourceCodeStream))" + "  (SPFillLine)" + "  (Stream (ExternalDatabaseAnswerStream (LensAnswerStream (QueryStream)))"
				+ "    (JunProbabilityDistribution (JunContinuousProbability (JunExponentialDistribution (JunGammaDistribution))" + "        (JunNormalDistribution)" + "        (JunUniformDistribution))"
				+ "      (JunDiscreteProbability (JunBernoulliDistribution (JunBinomialDistribution)" + "	  (JunGeometricDistribution))" + "        (JunPoissonDistribution)"
				+ "        (JunSampleSpace (JunSampleSpaceWithReplacement (JunSampleSpaceWithoutReplacement)))))" + "    (JunRandomStream)" + "    (PeekableStream (EncodedStream)"
				+ "      (PositionableStream (ExternalStream (BufferedExternalStream (ExternalReadStream (CodeReaderStream)" + "	      (ExternalReadAppendStream)" + "	      (ExternalReadWriteStream))" + "	    (ExternalWriteStream (CodeWriterStream))))"
				+ "        (InternalStream (ReadStream)" + "	  (WriteStream (ReadWriteStream (ByteCodeReadWriteStream))" + "	    (TextStream)))))" + "    (Random))" + "  (StreamEncoder (ByteStreamEncoder)" + "    (CompoundTextStreamEncoder)"
				+ "    (JapaneseEUCStreamEncoder)" + "    (JISStreamEncoder)" + "    (ShiftJISStreamEncoder (HP15StreamEncoder))" + "    (UnicodeStreamEncoder)" + "    (UTF8StreamEncoder))" + "  (StreamPolicy)" + "  (StringCollationPolicy)"
				+ "  (StringParameterSubstitution)" + "  (SystemError)" + "  (SystemUtils)" + "  (SystemVariable)" + "  (TextAttributes (VariableSizeTextAttributes))" + "  (TextMeasurer (CharacterScanner (CharacterBlockScanner)"
				+ "      (CompositionScanner)" + "      (DisplayScanner)))" + "  (Timestamp)" + "  (TimeZone)" + "  (UIAspectPath (LensAspectPath))" + "  (UIBuilder)" + "  (UIDefiner)" + "  (UIDispatcher)" + "  (UILookPolicy (CUALookPolicy)"
				+ "    (DefaultLookPolicy)" + "    (MacLookPolicy)" + "    (MotifLookPolicy)" + "    (Win3LookPolicy))" + "  (UISpecEnumerator (AspectEnumerator)" + "    (FilteredSpecEnumerator)" + "    (LensSpecReplicator))"
				+ "  (UISpecification (ComponentSpec (NamedSpec (ArbitraryComponentSpec)" + "        (CompositeSpec)" + "        (DividerSpec)" + "        (GroupBoxSpec)" + "        (LabelSpec)" + "        (RegionSpec)"
				+ "        (SubCanvasSpec (EmbeddedDetailSpec))" + "        (WidgetSpec (ButtonSpec (ActionButtonSpec (LinkedDetailSpec))" + "	    (CheckBoxSpec)" + "	    (MenuButtonSpec)" + "	    (RadioButtonSpec))" + "	  (DataSetColumnSpec)"
				+ "	  (MenuComponentSpec (DataSetSpec)" + "	    (LDMBrowserSpec)" + "	    (SequenceViewSpec (ComboBoxListSpec))" + "	    (TableViewSpec)" + "	    (TextEditorSpec (InputFieldSpec (ComboBoxSpec))))" + "	  (MultiSpec)" + "	  (NoteBookSpec)"
				+ "	  (SliderSpec))))" + "    (FullSpec)" + "    (SpecCollection (CompositeSpecCollection))" + "    (SubSpec (UIEventCallbackSubSpec))" + "    (WindowSpec))" + "  (UndefinedObject)" + "  (UninterpretedBytes (GraphicsHandle))"
				+ "  (UserMessage)" + "  (VariableDefinition (InstanceVariable (LensInstanceVariable))" + "    (LocalVariable (ArgumentVariable)" + "      (TemporaryVariable))" + "    (PseudoVariable)" + "    (ReceiverVariable)" + "    (RemoteVariable)"
				+ "    (StaticVariable (UndeclaredVariable)))" + "  (VisualComponent (DragHandle)" + "    (Icon)" + "    (JunVoronoi2dDiagram (JunDelaunay2dDiagram))" + "    (JunWinDIBSection (JunWinDIBSectionDepth1)"
				+ "      (JunWinDIBSectionDepth24 (JunOpenGLPickingMedium)))" + "    (Label (AlignmentLabel)" + "      (LabelAndIcon))" + "    (LDMVisualTreeConnection (LDMBroomConnection))" + "    (OpaqueImage (OpaqueImageWithEnablement))"
				+ "    (PixelArray (CachedImage)" + "      (Image (Depth16Image)" + "        (Depth1Image)" + "        (Depth24Image)" + "        (Depth2Image)" + "        (Depth32Image)" + "        (Depth4Image)" + "        (Depth8Image)))"
				+ "    (RowVisual (RowLabelVisual))" + "    (TextLines (ComposedText (InputFieldComposedText))" + "      (TextList))" + "    (VisualBlock)" + "    (VisualPart (CompositePart (BorderDecorator (TableDecorator))" + "        (ComboBoxView)"
				+ "        (ComposingComposite (MenuBar (CUAMenuBar)" + "	    (MacMenuBar)" + "	    (MotifMenuBar)" + "	    (Win3MenuBar)))" + "        (CUAScrollBar)" + "        (DependentComposite (CompositeView (LDMBrowserBodyView)"
				+ "	    (LDMCompositeView (LDMGraphCompositeView))" + "	    (LDMElementView)" + "	    (MenuView (CUAMenuView)" + "	      (MacMenuView)" + "	      (MotifMenuView)" + "	      (Win3MenuView))" + "	    (UIPainterView))"
				+ "	  (JunParametersComposite))" + "        (NoteBookComposite)" + "        (ReComposingComposite)" + "        (SubCanvas))" + "      (DependentPart (View (AutoScrollingView (ComposedTextView (TextCollectorView)"
				+ "	      (TextEditorView (InputFieldView (ComboBoxInputFieldView))))" + "	    (TableView (GeneralSelectionTableView)))" + "	  (BitView (ColorBitView))" + "	  (BooleanWidgetView (ActionButton)" + "	    (LabeledBooleanView (LDMArrowView)))"
				+ "	  (ColoredArea)" + "	  (DirectBitView)" + "	  (JunButtonView)" + "	  (JunColorChoiceView)" + "	  (JunGaugeView)" + "	  (JunHistogramView)" + "	  (JunOpenGLDisplayView (JunOpenGLEmbeddedDisplayView)" + "	    (JunOpenGLPlotterView)"
				+ "	    (JunOpenGLShowView))" + "	  (JunOpenGLRotationView)" + "	  (JunPlotterView)" + "	  (JunProgressView)" + "	  (JunThumbWheelView)" + "	  (JunTrackSliderView)" + "	  (LauncherView)" + "	  (MenuItemView (CUAMenuItemView)"
				+ "	    (MacMenuItemView)" + "	    (MotifMenuItemView)" + "	    (Win3MenuItemView))" + "	  (NotifierView)" + "	  (Scrollbar (EmulationScrollBar (CUAScrollBarSlider)" + "	      (EmulationFixedThumbScrollBar (MacScrollBar)"
				+ "	        (Win3ScrollBar))" + "	      (MotifScrollBar)))" + "	  (SimpleView (BasicButtonView (ComboBoxButtonView (CUAComboBoxButtonView)" + "	        (MacComboBoxButtonView)" + "	        (MotifComboBoxButtonView)"
				+ "	        (Win3ComboBoxButtonView))" + "	      (LabeledButtonView (CheckButtonView (CUACheckButtonView)" + "		  (DefaultLookCheckButtonView)" + "		  (MacCheckButtonView)" + "		  (MotifCheckButtonView)" + "		  (Win3CheckButtonView))"
				+ "	        (PushButtonView (ActionButtonView (CUAActionButtonView)" + "		    (MacActionButtonView)" + "		    (MotifActionButtonView)" + "		    (UndecoratedActionButtonView)" + "		    (Win3ActionButtonView))"
				+ "		  (MenuBarButtonView (CUAMenuBarButtonView)" + "		    (MacMenuBarButtonView)" + "		    (MotifMenuBarButtonView)" + "		    (Win3MenuBarButtonView))" + "		  (MenuButtonView (CUAMenuButtonView)" + "		    (MacMenuButtonView)"
				+ "		    (MotifMenuButtonView)" + "		    (UndecoratedMenuButtonView)" + "		    (Win3MenuButtonView)))" + "	        (RadioButtonView (CUARadioButtonView)" + "		  (DefaultLookRadioButtonView)" + "		  (MacRadioButtonView)"
				+ "		  (MotifRadioButtonView)" + "		  (Win3RadioButtonView)))" + "	      (ScrollerButtonView (CUAScrollerButtonView)" + "	        (MotifScrollerButton)" + "	        (VisualPairButton)))"
				+ "	    (ScrollingView (JunDisplayView (JunZoomableDisplayView))" + "	      (SelectionView (DataSetView (PaintedDataSetView))" + "	        (SequenceView (ComboBoxListView)" + "		  (MultiSelectionSequenceView))"
				+ "	        (TabBarView (HorizontalTabBarView)" + "		  (VerticalTabBarView))))" + "	    (SliderView (MacSliderView)" + "	      (Win3SliderView)))))" + "      (MotifMenuItemSeparatorComponent)" + "      (SimpleComponent (GroupBox)"
				+ "        (PassiveLabel)" + "        (VisualBinderComponent)" + "        (VisualDivider)" + "        (VisualRegion))" + "      (Wrapper (GeometricWrapper (FillingWrapper)" + "	  (StrokingWrapper))" + "        (GraphicsAttributesWrapper)"
				+ "        (GridWrapper)" + "        (PassivityWrapper)" + "        (ReversingWrapper (StrikeOutWrapper))" + "        (ScalingWrapper)" + "        (TranslatingWrapper (LayoutWrapper (BoundedWrapper (BorderedWrapper (MenuBarWrapper))"
				+ "	      (BoundingWrapper)))" + "	  (LDMAbstractElementWrapper (LDMGraphElementWrapper)" + "	    (LDMListElementWrapper))" + "	  (ScrollWrapper (DataSetScrollWrapper)" + "	    (SlaveScrollWrapper)))" + "        (WidgetStateWrapper)"
				+ "        (WidgetWrapper (SpecWrapper)))))" + "  (WidgetDragDropCallbacks)" + "  (WidgetPolicy (CUAWidgetPolicy)" + "    (MacWidgetPolicy)" + "    (MotifWidgetPolicy)" + "    (SmalltalkWidgetPolicy)" + "    (Win3WidgetPolicy))"
				+ "  (WidgetState)" + "  (WindowDisplayPolicy (DoubleBufferingWindowDisplayPolicy)))" + "";
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 */
	protected static String _SubclassHierachyLispStringForStream() {
		return "(Stream (ExternalDatabaseAnswerStream (LensAnswerStream (QueryStream)))" + "  (JunProbabilityDistribution (JunContinuousProbability (JunExponentialDistribution (JunGammaDistribution))" + "      (JunNormalDistribution)"
				+ "      (JunUniformDistribution))" + "    (JunDiscreteProbability (JunBernoulliDistribution (JunBinomialDistribution)" + "        (JunGeometricDistribution))" + "      (JunPoissonDistribution)"
				+ "      (JunSampleSpace (JunSampleSpaceWithReplacement (JunSampleSpaceWithoutReplacement)))))" + "  (JunRandomStream)" + "  (PeekableStream (EncodedStream)"
				+ "    (PositionableStream (ExternalStream (BufferedExternalStream (ExternalReadStream (CodeReaderStream)" + "	    (ExternalReadAppendStream)" + "	    (ExternalReadWriteStream))" + "	  (ExternalWriteStream (CodeWriterStream))))"
				+ "      (InternalStream (ReadStream)" + "        (WriteStream (ReadWriteStream (ByteCodeReadWriteStream))" + "	  (TextStream)))))" + "  (Random))" + "";
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 */
	protected static String _SubclassHierachyLispStringForView() {
		return "(View (AutoScrollingView (ComposedTextView (TextCollectorView)" + "      (TextEditorView (InputFieldView (ComboBoxInputFieldView))))" + "    (TableView (GeneralSelectionTableView)))" + "  (BitView (ColorBitView))"
				+ "  (BooleanWidgetView (ActionButton)" + "    (LabeledBooleanView (LDMArrowView)))" + "  (ColoredArea)" + "  (DirectBitView)" + "  (JunButtonView)" + "  (JunColorChoiceView)" + "  (JunGaugeView)" + "  (JunHistogramView)"
				+ "  (JunOpenGLDisplayView (JunOpenGLEmbeddedDisplayView)" + "    (JunOpenGLPlotterView)" + "    (JunOpenGLShowView))" + "  (JunOpenGLRotationView)" + "  (JunPlotterView)" + "  (JunProgressView)" + "  (JunThumbWheelView)"
				+ "  (JunTrackSliderView)" + "  (LauncherView)" + "  (MenuItemView (CUAMenuItemView)" + "    (MacMenuItemView)" + "    (MotifMenuItemView)" + "    (Win3MenuItemView))" + "  (NotifierView)"
				+ "  (Scrollbar (EmulationScrollBar (CUAScrollBarSlider)" + "      (EmulationFixedThumbScrollBar (MacScrollBar)" + "        (Win3ScrollBar))" + "      (MotifScrollBar)))"
				+ "  (SimpleView (BasicButtonView (ComboBoxButtonView (CUAComboBoxButtonView)" + "        (MacComboBoxButtonView)" + "        (MotifComboBoxButtonView)" + "        (Win3ComboBoxButtonView))"
				+ "      (LabeledButtonView (CheckButtonView (CUACheckButtonView)" + "	  (DefaultLookCheckButtonView)" + "	  (MacCheckButtonView)" + "	  (MotifCheckButtonView)" + "	  (Win3CheckButtonView))"
				+ "        (PushButtonView (ActionButtonView (CUAActionButtonView)" + "	    (MacActionButtonView)" + "	    (MotifActionButtonView)" + "	    (UndecoratedActionButtonView)" + "	    (Win3ActionButtonView))"
				+ "	  (MenuBarButtonView (CUAMenuBarButtonView)" + "	    (MacMenuBarButtonView)" + "	    (MotifMenuBarButtonView)" + "	    (Win3MenuBarButtonView))" + "	  (MenuButtonView (CUAMenuButtonView)" + "	    (MacMenuButtonView)"
				+ "	    (MotifMenuButtonView)" + "	    (UndecoratedMenuButtonView)" + "	    (Win3MenuButtonView)))" + "        (RadioButtonView (CUARadioButtonView)" + "	  (DefaultLookRadioButtonView)" + "	  (MacRadioButtonView)"
				+ "	  (MotifRadioButtonView)" + "	  (Win3RadioButtonView)))" + "      (ScrollerButtonView (CUAScrollerButtonView)" + "        (MotifScrollerButton)" + "        (VisualPairButton)))"
				+ "    (ScrollingView (JunDisplayView (JunZoomableDisplayView))" + "      (SelectionView (DataSetView (PaintedDataSetView))" + "        (SequenceView (ComboBoxListView)" + "	  (MultiSelectionSequenceView))"
				+ "        (TabBarView (HorizontalTabBarView)" + "	  (VerticalTabBarView))))" + "    (SliderView (MacSliderView)" + "      (Win3SliderView))))" + "";
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGL3dGraphTestExamples();
	}

}
