package jp.co.sra.jun.opengl.flux;

import java.awt.Dimension;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;

/**
 * JunOpenGLFluxViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/20 (by MATSUDA Ryouichi)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/03/16 (by nisinaka)
 *  @updated   2006/10/13 (by nisinaka)
 *  @updated   2007/08/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxViewSwing.java,v 8.15 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxViewSwing extends JunOpenGLDisplayViewSwing implements JunOpenGLFluxView {

	/**
	 * Create a new instance of <code>JunOpenGLFluxViewSwing</code> and initialize it.
	 * 
	 * @param aFluxModel jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @category Instance creation
	 */
	public JunOpenGLFluxViewSwing(JunOpenGLFluxModel aFluxModel) {
		super(aFluxModel);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 1f, -20, 1f, -39));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().pickButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLFluxModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLFluxModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -38, 0.5f, 61, 1f, -20));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLFluxModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().focusButton()), WindowSpecLayout.Position(1f, -19, 0.5f, -80, 1f, -1, 0.5f, -62));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().dollyButton()), WindowSpecLayout.Position(1f, -18, 0.5f, 62, 1f, -2, 0.5f, 78));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().trackerModel().previousButton()), WindowSpecLayout.Position(0f, 21, 1f, -19, 0f, 39, 1f, -1));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().trackerModel().nextButton()), WindowSpecLayout.Position(0f, 40, 1f, -19, 0f, 58, 1f, -1));
		this.add(new JunTrackSliderViewSwing(this.getOpenGLFluxModel().trackerModel()), WindowSpecLayout.Position(0f, 59, 1f, -19, 1f, -59, 1f, -1));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().trackerModel().loopButton()), WindowSpecLayout.Position(1f, -58, 1f, -19, 1f, -40, 1f, -1));
		this.add(new JunButtonViewSwing(this.getOpenGLFluxModel().trackerModel().playButton()), WindowSpecLayout.Position(1f, -39, 1f, -19, 1f, -21, 1f, -1));
		this.setPreferredSize(new Dimension(300, 320));
	}

	/**
	 * Answer my model as JunOpenGLFluxModel.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @category model accessing
	 */
	public JunOpenGLFluxModel getOpenGLFluxModel() {
		return (JunOpenGLFluxModel) this.model();
	}

}
