package jp.co.sra.jun.opengl.display;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewSwing;

/**
 * JunOpenGLStereoDisplayViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/10/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStereoDisplayViewSwing.java,v 8.11 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLStereoDisplayViewSwing extends JunOpenGLDisplayViewSwing implements JunOpenGLStereoDisplayView {
	protected JCheckBox crossingView;

	/**
	 * Create a new instance of <code>JunOpenGLStereoDisplayViewSwing</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @category Instance creation
	 */
	public JunOpenGLStereoDisplayViewSwing(JunOpenGLStereoDisplayModel aModel) {
		super(aModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		crossingView = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.leftDisplayView()._onBorderedPanel(), WindowSpecLayout.Position(0.5f, 1, 0f, 1, 1f, -20, 1f, -20));
		this.add(this.rightDisplayView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 0.5f, -1, 1f, -20));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().pickButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -19, 0.5f, 61, 1f, -1));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().focusButton()), WindowSpecLayout.Position(1f, -19, 0.5f, -80, 1f, -1, 0.5f, -62));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().dollyButton()), WindowSpecLayout.Position(1f, -19, 0.5f, 62, 1f, -1, 0.5f, 80));
		this.add(this.crossingView(), WindowSpecLayout.Position(0.8f, 0, 1f, -18, 1f, -20, 1f, -1));
		this.setPreferredSize(new Dimension(540, 300));
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing#defaultModel()
	 * @category defaults
	 */
	protected StModel defaultModel() {
		return new JunOpenGLShowModel();
	}

	/**
	 * Answer the receiver's left display view as JunOpenGLAngledDisplayViewSwing.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLAngledDisplayViewSwing
	 * @category interface opening
	 */
	public JunOpenGLAngledDisplayViewSwing leftDisplayView() {
		return new JunOpenGLAngledDisplayViewSwing(this.getOpenGLStereoDisplayModel(), this.getOpenGLStereoDisplayModel().stereoAngle());
	}

	/**
	 * Answer the receiver's right display view as JunOpenGLAngledDisplayViewSwing.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLAngledDisplayViewSwing
	 * @category interface opening
	 */
	public JunOpenGLAngledDisplayViewSwing rightDisplayView() {
		return new JunOpenGLAngledDisplayViewSwing(this.getOpenGLStereoDisplayModel(), this.getOpenGLStereoDisplayModel().stereoAngle().negated());
	}

	/**
	 * Answer the receiver's crossing view as JCheckBox.
	 * 
	 * @return javax.swing.JCheckBox
	 * @category interface opening
	 */
	public JCheckBox crossingView() {
		if (crossingView == null) {
			final JunOpenGLStereoDisplayModel aStereoModel = this.getOpenGLStereoDisplayModel();
			crossingView = new JCheckBox($String("Crossing"), this.getOpenGLStereoDisplayModel().crossing());
			crossingView.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (crossingView.isSelected() != aStereoModel.crossing()) {
						aStereoModel.crossing_(crossingView.isSelected());
					}
				}
			});
		}
		return crossingView;
	}

	/**
	 * Answer the receiver's model as JunOpenGLStereoDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @category model accessing
	 */
	public JunOpenGLStereoDisplayModel getOpenGLStereoDisplayModel() {
		return (JunOpenGLStereoDisplayModel) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (this.isShowing() == false) {
			return;
		}
		if (e.getAspect() == $("crossing")) {
			if (this.crossingView().isSelected() != this.getOpenGLStereoDisplayModel().crossing()) {
				this.crossingView().setSelected(this.getOpenGLStereoDisplayModel().crossing());
			}
			return;
		}
		super.update_(e);
	}
}
