package jp.co.sra.jun.opengl.display;

import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewAwt;

/**
 * JunOpenGLStereoDisplayViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/10/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStereoDisplayViewAwt.java,v 8.11 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLStereoDisplayViewAwt extends JunOpenGLDisplayViewAwt implements JunOpenGLStereoDisplayView {
	protected Checkbox crossingView;

	/**
	 * Create a new instance of <code>JunOpenGLStereoDisplayViewAwt</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @category Instance creation
	 */
	public JunOpenGLStereoDisplayViewAwt(JunOpenGLStereoDisplayModel aModel) {
		super(aModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		crossingView = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.leftDisplayView()._onBorderedPanel(), WindowSpecLayout.Position(0.5f, 1, 0f, 1, 1f, -20, 1f, -20));
		this.add(this.rightDisplayView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 0.5f, -1, 1f, -20));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().pickButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -19, 0.5f, 61, 1f, -1));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().focusButton()), WindowSpecLayout.Position(1f, -19, 0.5f, -80, 1f, -1, 0.5f, -62));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().dollyButton()), WindowSpecLayout.Position(1f, -19, 0.5f, 62, 1f, -1, 0.5f, 80));
		this.add(this.crossingView(), WindowSpecLayout.Position(0.8f, 0, 1f, -18, 1f, -20, 1f, -1));
		this.setSize(540, 300);

		this.getOpenGLDisplayModel().builder().componentAt_put_($("leftDisplayView"), this.leftDisplayView().toComponent());
		this.getOpenGLDisplayModel().builder().componentAt_put_($("rightDisplayView"), this.rightDisplayView().toComponent());
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt#defaultModel()
	 * @category defaults
	 */
	protected StModel defaultModel() {
		return new JunOpenGLShowModel();
	}

	/**
	 * Answer the receiver's left display view as JunOpenGLAngledDisplayViewAwt.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLAngledDisplayViewAwt
	 * @category interface opening
	 */
	public JunOpenGLAngledDisplayViewAwt leftDisplayView() {
		return new JunOpenGLAngledDisplayViewAwt(this.getOpenGLStereoDisplayModel(), this.getOpenGLStereoDisplayModel().stereoAngle());
	}

	/**
	 * Answer the receiver's right display view as JunOpenGLAngledDisplayViewAwt.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLAngledDisplayViewAwt
	 * @category interface opening
	 */
	public JunOpenGLAngledDisplayViewAwt rightDisplayView() {
		return new JunOpenGLAngledDisplayViewAwt(this.getOpenGLStereoDisplayModel(), this.getOpenGLStereoDisplayModel().stereoAngle().negated());
	}

	/**
	 * Answer the receiver's crossing view as Checkbox.
	 * 
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox crossingView() {
		if (crossingView == null) {
			final JunOpenGLStereoDisplayModel aStereoModel = this.getOpenGLStereoDisplayModel();
			crossingView = new Checkbox($String("Crossing"), this.getOpenGLStereoDisplayModel().crossing());
			crossingView.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (crossingView.getState() != aStereoModel.crossing()) {
						aStereoModel.crossing_(crossingView.getState());
					}
				}
			});
		}
		return crossingView;
	}

	/**
	 * Answer the receiver's model as JunOpenGLStereoDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @category model accessing
	 */
	public JunOpenGLStereoDisplayModel getOpenGLStereoDisplayModel() {
		return (JunOpenGLStereoDisplayModel) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @see jp.co.sra.smalltalk.StViewPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (this.isShowing() == false) {
			return;
		}
		if (e.getAspect() == $("crossing")) {
			if (this.crossingView().getState() != this.getOpenGLStereoDisplayModel().crossing()) {
				this.crossingView().setState(this.getOpenGLStereoDisplayModel().crossing());
			}
			return;
		}
		super.update_(e);
	}
}
