package jp.co.sra.jun.opengl.display;

import java.util.Map;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLStereoDisplayModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/10/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStereoDisplayModel.java,v 8.11 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLStereoDisplayModel extends JunOpenGLDisplayModel {
	protected StValueHolder crossingHolder;

	/**
	 * Create a new instance of <code>JunOpenGLStereoDisplayModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGLStereoDisplayModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunOpenGLStereoDisplayModel</code> and initialize it.
	 * 
	 * @param anOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Instance creation
	 */
	public JunOpenGLStereoDisplayModel(JunOpenGL3dObject anOpenGL3dObject) {
		super(anOpenGL3dObject);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		crossingHolder = null;
	}

	/**
	 * Answer the receive's crossing value.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean crossing() {
		return this.crossingHolder()._booleanValue();
	}

	/**
	 * Set the receive's crossing value.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void crossing_(boolean aBoolean) {
		this.crossingHolder().value_(aBoolean);
	}

	/**
	 * Post create display projector.
	 * 
	 * @param aProjector jp.co.sra.jun.opengl.projection.JunOpenGLProjector
	 * @return jp.co.sra.jun.opengl.projection.JunOpenGLProjector
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#postCreateDisplayProjector_(jp.co.sra.jun.opengl.projection.JunOpenGLProjector)
	 * @category accessing
	 */
	protected JunOpenGLProjector postCreateDisplayProjector_(JunOpenGLProjector aProjector) {
		if (this.defaultStereoscope() == $("crossing")) {
			this.crossing_(true);
		} else {
			this.crossing_(false);
		}
		return aProjector;
	}

	/**
	 * Answer the receiver's crossing holder.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	public StValueHolder crossingHolder() {
		if (crossingHolder == null) {
			crossingHolder = new StValueHolder(false);
			crossingHolder.compute_(new StBlockClosure() {
				public Object value_(Object arg) {
					JunOpenGLStereoDisplayModel.this.changed_($("crossing"));
					return null;
				}
			});
		}
		return crossingHolder;
	}

	/**
	 * Answer the current default stereoscope.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category defaults
	 */
	public StSymbol defaultStereoscope() {
		return this.defaultProjectionTable().containsKey(("stereoscope")) ? (StSymbol) this.defaultProjectionTable().get($("stereoscope")) : $("noncrossing");
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOpenGLStereoDisplayViewAwt(this);
		} else {
			return new JunOpenGLStereoDisplayViewSwing(this);
		}
	}

	/**
	 * Answer this window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Stereo Viewfinder");
	}

	/**
	 * Post get projection table.
	 * 
	 * @param aDictionary java.util.Map
	 * @return java.util.Map
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#postGetProjectionTable_(java.util.Map)
	 * @category projection
	 */
	protected Map postGetProjectionTable_(Map aDictionary) {
		aDictionary.put($("stereoscope"), (this.crossing() ? $("crossing") : $("noncrossing")));
		return aDictionary;
	}

	/**
	 * Post put projection table.
	 * 
	 * @param aDictionary java.util.Map
	 * @param aProjector jp.co.sra.jun.opengl.projection.JunOpenGLProjector
	 * @return java.util.Map
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#postPutProjectionTable_into_(java.util.Map, jp.co.sra.jun.opengl.projection.JunOpenGLProjector)
	 * @category projection
	 */
	protected Map postPutProjectionTable_into_(Map aDictionary, JunOpenGLProjector aProjector) {
		if (aDictionary.containsKey($("stereoscope"))) {
			if ((StSymbol) aDictionary.get($("stereoscope")) == $("crossing")) {
				this.crossing_(true);
			} else {
				this.crossing_(false);
			}
		}
		return aDictionary;
	}

	/**
	 * Render the display objects on the redering context with the specified angle.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @category rendering
	 */
	public void renderOn_angle_(JunOpenGLRenderingContext renderingContext, JunAngle anAngle) {
		this.renderOn_angle_withDisplayList_(renderingContext, anAngle, null);
	}

	/**
	 * Render the display objects on the redering context with the specified angle and display list.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param displayListHolder jp.co.sra.smalltalk.StValueHolder
	 * @category rendering
	 */
	public void renderOn_angle_withDisplayList_(JunOpenGLRenderingContext renderingContext, JunAngle anAngle, StValueHolder displayListHolder) {
		JunOpenGLProjector aProjector = (JunOpenGLProjector) this.displayProjector().copy();
		if (anAngle != null) {
			Jun3dTransformation transformation = Jun3dTransformation.Rotate_around_((this.crossing() ? anAngle.negated() : anAngle), new Jun3dLine(new Jun3dPoint(0, 0, 0), aProjector.upVector()));
			JunOpenGLProjection aProjection = (JunOpenGLProjection) aProjector.projection().copy();
			aProjection.eyePoint_(transformation.applyTo_(aProjection.eyePoint()));
			aProjector.projection_(aProjection);
		}
		this.renderOn_projector_withDisplayList_(renderingContext, aProjector, displayListHolder);
	}

	/**
	 * Render the display objects on the redering context with the specified projector and display list.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @param projector jp.co.sra.jun.opengl.projection.JunOpenGLProjector
	 * @param displayListHolder jp.co.sra.smalltalk.StValueHolder
	 * @category rendering
	 */
	public void renderOn_projector_withDisplayList_(JunOpenGLRenderingContext renderingContext, JunOpenGLProjector projector, StValueHolder displayListHolder) {
		if (renderingContext == null) {
			return;
		}
		renderingContext.clear();
		JunOpenGLLight[] lightCollection = this.displayLightCollection();
		JunOpenGL3dObject renderingObject = this.displayObject();
		if (renderingObject == null) {
			projector.projectOn_(renderingContext);
		} else {
			if (this.selectedObjects().isEmpty()) {
				projector.project_withLights_on_withDisplayList_(renderingObject, lightCollection, renderingContext, displayListHolder);
			} else {
				JunOpenGLProjector aProjector = (JunOpenGLProjector) projector.copy();
				if (projector.presentation() == $("solidPresentation")) {
					aProjector.wireframePresentation();
				}
				if (projector.presentation() == $("wireframePresentation")) {
					aProjector.wireframePresentation();
				}
				if (projector.presentation() == $("hiddenlinePresentation")) {
					aProjector.hiddenlinePresentation();
				}
				aProjector.project_withLights_on_withDisplayList_(renderingObject, lightCollection, renderingContext, displayListHolder);

				if (projector.presentation() == $("solidPresentation")) {
					aProjector.solidPresentation();
				}
				if (projector.presentation() == $("wireframePresentation")) {
					aProjector.solidPresentation();
				}
				if (projector.presentation() == $("hiddenlinePresentation")) {
					aProjector.solidPresentation();
				}

				JunOpenGL3dObject[] selectedObjects = (JunOpenGL3dObject[]) this.selectedObjects().toArray(new JunOpenGL3dObject[this.selectedObjects().size()]);
				for (int i = 0; i < selectedObjects.length; i++) {
					aProjector.project_on_(selectedObjects[i], renderingContext);
				}
			}
		}
	}

	/**
	 * Answer the receiver's stereo angle.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @category private
	 */
	protected JunAngle stereoAngle() {
		return JunAngle.FromDeg_(1.5);
	}
}
