package jp.co.sra.jun.opengl.display;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLDisplayLightViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   UNKNOWN
 *  @updated   2000/01/25 (by MATSUDA Ryouichi)
 *  @updated   2003/05/13 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun608 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayLightViewSwing.java,v 8.12 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayLightViewSwing extends JunAbstractViewJPanel implements JunOpenGLDisplayLightView {
	protected JunColorChoiceViewSwing colorChoiceView;
	protected ButtonGroup lightState;
	protected JRadioButton lightStateOn;
	protected JRadioButton lightStateOff;
	protected ButtonGroup lightKind;
	protected JRadioButton lightKindAmbient;
	protected JRadioButton lightKindParallel;
	protected JRadioButton lightKindPoint;
	protected JRadioButton lightKindSpot;
	protected JTextField positionTextValue;
	protected JTextField directionTextValue;
	protected JTextField cutoffAngleTextValue;

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewSwing</code> and initialize it.
	 *
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public JunOpenGLDisplayLightViewSwing(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		super(anOpenGLDisplayLight);
	}

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewSwing</code> for an ambient light.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightViewSwing
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public static JunOpenGLDisplayLightViewSwing ForAmbientLight(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		return new JunOpenGLDisplayLightViewSwing(anOpenGLDisplayLight) {
			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
				this.add(new JLabel(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
				this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
				this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
				this.setPreferredSize(new Dimension(234, 198));
			}
		};
	}

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewSwing</code> for a position light.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightViewSwing
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public static JunOpenGLDisplayLightViewSwing ForPositionLight(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		return new JunOpenGLDisplayLightViewSwing(anOpenGLDisplayLight) {
			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
				this.add(new JLabel(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
				this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
				this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
				this.add(new JLabel(JunSystem.$String("Kind") + ":"), WindowSpecLayout.Position(0.5f, 1, 0f, 128));
				this.add(this.lightKindParallel(), WindowSpecLayout.Position(0.5f, 10, 0f, 151));
				this.add(this.lightKindPoint(), WindowSpecLayout.Position(0.5f, 10, 0f, 174));
				this.add(this.lightKindSpot(), WindowSpecLayout.Position(0.5f, 10, 0f, 197));
				this.add(new JLabel(JunSystem.$String("Position") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 220));
				this.add(this.positionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 243, 1f, -1, 0f, 265));
				this.add(new JLabel(JunSystem.$String("Direction") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 266));
				this.add(this.directionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 289, 1f, -1, 0f, 311));
				this.add(new JLabel(JunSystem.$String("Cutoff angle") + ": (" + JunSystem.$String("degree") + ")"), WindowSpecLayout.Position(0f, 1, 0f, 312));
				this.add(this.cutoffAngleTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 335, 1f, -1, 0f, 357));
				this.setPreferredSize(new Dimension(234, 358));
			}
		};
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
		this.add(new JLabel(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
		this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
		this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
		this.add(new JLabel(JunSystem.$String("Kind") + ":"), WindowSpecLayout.Position(0.5f, 1, 0f, 128));
		this.add(this.lightKindAmbient(), WindowSpecLayout.Position(0.5f, 10, 0f, 151));
		this.add(this.lightKindParallel(), WindowSpecLayout.Position(0.5f, 10, 0f, 174));
		this.add(this.lightKindPoint(), WindowSpecLayout.Position(0.5f, 10, 0f, 197));
		this.add(this.lightKindSpot(), WindowSpecLayout.Position(0.5f, 10, 0f, 220));
		this.add(new JLabel(JunSystem.$String("Position") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 242));
		this.add(this.positionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 266, 1f, -1, 0f, 288));
		this.add(new JLabel(JunSystem.$String("Direction") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 289));
		this.add(this.directionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 312, 1f, -1, 0f, 334));
		this.add(new JLabel(JunSystem.$String("Cutoff angle") + ": (" + JunSystem.$String("degree") + ")"), WindowSpecLayout.Position(0f, 1, 0f, 335));
		this.add(this.cutoffAngleTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 358, 1f, -1, 0f, 380));
		this.setPreferredSize(new Dimension(234, 381));
	}

	/**
	 * Answer my color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing
	 * @category interface opening
	 */
	public JunColorChoiceViewSwing colorChoiceView() {
		if (colorChoiceView == null) {
			colorChoiceView = new JunColorChoiceViewSwing(this.getOpenGLDisplayLight().lightColor());
		}
		return colorChoiceView;
	}

	/**
	 * Answer the text field of the cutoff angle text value.
	 *
	 * @return javax.swing.JTextField
	 * @category interface opening
	 */
	public JTextField cutoffAngleTextValue() {
		if (cutoffAngleTextValue == null) {
			cutoffAngleTextValue = new JTextField((String) this.getOpenGLDisplayLight().cutoffAngleTextValue().value());
			cutoffAngleTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
		}
		return cutoffAngleTextValue;
	}

	/**
	 * Answer the text field of the direction text value.
	 *
	 * @return javax.swing.JTextField
	 * @category interface opening
	 */
	public JTextField directionTextValue() {
		if (directionTextValue == null) {
			directionTextValue = new JTextField((String) this.getOpenGLDisplayLight().directionTextValue().value());
			directionTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("parallel") || this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
		}
		return directionTextValue;
	}

	/**
	 * Answer the button group of the light states.
	 * 
	 * @return javax.swing.ButtonGroup
	 * @category interface opening
	 */
	public ButtonGroup lightKind() {
		if (lightKind == null) {
			lightKind = new ButtonGroup();
		}
		return lightKind;
	}

	/**
	 * Answer the radio button for the light kind AMBIENT.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightKindAmbient() {
		if (lightKindAmbient == null) {
			lightKindAmbient = new JRadioButton(JunSystem.$String("Ambient Light", "Ambient"), this.getOpenGLDisplayLight().lightKind().value() == $("ambient"));
			lightKindAmbient.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(false);
					directionTextValue().setVisible(false);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("ambient"));
				}
			});
			this.lightKind().add(lightKindAmbient);
		}
		return lightKindAmbient;
	}

	/**
	 * Answer the radio button for the light kind PARALLEL.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightKindParallel() {
		if (lightKindParallel == null) {
			lightKindParallel = new JRadioButton(JunSystem.$String("Parallel Light", "Parallel"), this.getOpenGLDisplayLight().lightKind().value() == $("parallel"));
			lightKindParallel.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(false);
					directionTextValue().setVisible(true);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("parallel"));
				}
			});
			this.lightKind().add(lightKindParallel);
		}
		return lightKindParallel;
	}

	/**
	 * Answer the radio button for the light kind POINT.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightKindPoint() {
		if (lightKindPoint == null) {
			lightKindPoint = new JRadioButton(JunSystem.$String("Point Light", "Point"), this.getOpenGLDisplayLight().lightKind().value() == $("point"));
			lightKindPoint.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(true);
					directionTextValue().setVisible(false);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("point"));
				}
			});
			this.lightKind().add(lightKindPoint);
		}
		return lightKindPoint;
	}

	/**
	 * Answer the radio button for the light kind SPOT.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightKindSpot() {
		if (lightKindSpot == null) {
			lightKindSpot = new JRadioButton(JunSystem.$String("Spot Light", "Spot"), this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
			lightKindSpot.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(true);
					directionTextValue().setVisible(true);
					cutoffAngleTextValue().setVisible(true);
					getOpenGLDisplayLight().lightKind().value_($("spot"));
				}
			});
			this.lightKind().add(lightKindSpot);
		}
		return lightKindSpot;
	}

	/**
	 * Answer the button group of the light states.
	 * 
	 * @return javax.swing.ButtonGroup
	 * @category interface opening
	 */
	public ButtonGroup lightState() {
		if (lightState == null) {
			lightState = new ButtonGroup();
		}
		return lightState;
	}

	/**
	 * Answer the radio button for the light state OFF.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightStateOff() {
		if (lightStateOff == null) {
			lightStateOff = new JRadioButton(JunSystem.$String("Off"), this.getOpenGLDisplayLight().lightState()._booleanValue() == false);
			lightStateOff.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getOpenGLDisplayLight().beOff();
				}
			});
			this.lightState().add(lightStateOff);
		}
		return lightStateOff;
	}

	/**
	 * Answer the radio button for the light state ON.
	 *
	 * @return javax.swing.JRadioButton
	 * @category interface opening
	 */
	public JRadioButton lightStateOn() {
		if (lightStateOn == null) {
			lightStateOn = new JRadioButton(JunSystem.$String("On"), this.getOpenGLDisplayLight().lightState()._booleanValue() == true);
			lightStateOn.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getOpenGLDisplayLight().beOn();
				}
			});
			this.lightState().add(lightStateOn);
		}
		return lightStateOn;
	}

	/**
	 * Answer the TextField of the position text value.
	 *
	 * @return javax.swing.JTextField
	 * @category interface opening
	 */
	public JTextField positionTextValue() {
		if (positionTextValue == null) {
			positionTextValue = new JTextField((String) this.getOpenGLDisplayLight().textValue().value());
			positionTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("point") || this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
			positionTextValue.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getOpenGLDisplayLight().textValueChanged_(positionTextValue.getText());
				}
			});
		}
		return positionTextValue;
	}

	/**
	 * Answer my model as JunOpenGLDisplayLight.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightView#getOpenGLDisplayLight()
	 * @category model accessing
	 */
	public JunOpenGLDisplayLight getOpenGLDisplayLight() {
		return (JunOpenGLDisplayLight) this.model();
	}
}
