package jp.co.sra.jun.opengl.cosmos;

import java.awt.event.WindowEvent;
import java.util.Vector;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.gl4jun.GLjInterface;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLMacrocosmModel class
 * 
 *  @author    nisinaka
 *  @created   2004/01/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLMacrocosmModel.java,v 8.12 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLMacrocosmModel extends JunOpenGLDisplayModel {

	protected JunOpenGLDisplayModel insideModel;
	protected JunOpenGL3dObject stencilObject;
	protected JunOpenGL3dPolygon[] stencilPolygons;

	/**
	 * Initialize the JunOpenGLMacrocosmModel.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		// this.useDisplayList_(false);
		insideModel = null;
		stencilObject = null;
		stencilPolygons = null;
	}

	/**
	 * Answer my current inside model.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category accessing
	 */
	public JunOpenGLDisplayModel insideModel() {
		if (insideModel == null) {
			this.insideModel_(new JunOpenGLDisplayModel());
		}

		return insideModel;
	}

	/**
	 * Set my new inside model.
	 * 
	 * @param displayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category accessing
	 */
	public void insideModel_(JunOpenGLDisplayModel displayModel) {
		if (displayModel == this) {
			return;
		}

		if (insideModel != null) {
			if (insideModel.myDependents().contains(this)) {
				insideModel.removeDependent_(this);
			}
		}

		insideModel = displayModel;

		if (insideModel.myDependents() == null || insideModel.myDependents().contains(this) == false) {
			insideModel.addDependent_(this);
		}
	}

	/**
	 * Answer my current stencil object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject stencilObject() {
		if (stencilObject == null) {
			this.stencilObject_(new JunOpenGL3dCompoundObject());
		}

		return stencilObject;
	}

	/**
	 * Set my new stencil object.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public void stencilObject_(JunOpenGL3dObject a3dObject) {
		stencilObject = a3dObject;
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (this.displayObject() == null) {
			return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 0));
		}

		return this.displayObject().boundingBox().merge_(this.stencilObject().boundingBox());
	}

	/**
	 * Answer the window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Macrocosm");
	}

	/**
	 * Invoked when a window is in the process of being closed.
	 * 
	 * @param e java.awt.event.WindowEvent
	 * @see jp.co.sra.smalltalk.StApplicationModel#noticeOfWindowClose()
	 * @category interface closing
	 */
	public void noticeOfWindowClose(WindowEvent e) {
		super.noticeOfWindowClose(e);

		if (insideModel != null) {
			insideModel.closeRequest();
		}
	}

	/**
	 * Answer the array of all display lights.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight[]
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#displayLights()
	 * @category lighting
	 */
	public synchronized JunOpenGLDisplayLight[] displayLights() {
		if (displayLights == null) {
			displayLights = new JunOpenGLDisplayLight[5];
			displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(false, StColorValue.Brightness_(0.1), this.defaultLightPoint());
			displayLights[1] = new JunOpenGLDisplayLight();
			displayLights[2] = new JunOpenGLDisplayLight();
			displayLights[3] = new JunOpenGLDisplayLight();
			displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());

			for (int i = 0; i < displayLights.length; i++) {
				displayLights[i].compute_(new StBlockClosure() {
					public Object value() {
						JunOpenGLMacrocosmModel.this.updateLightMenuIndication();
						JunOpenGLMacrocosmModel.this.changed_($("light"));
						return null;
					}
				});
			}
		}

		return displayLights;
	}

	/**
	 * Render the display objects on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.objects.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext renderingContext) {
		renderingContext.clear();
		GLjInterface.Current().glEnable(GLjInterface.GL_STENCIL_TEST);
		GLjInterface.Current().glStencilMask(GLjInterface.GL_TRUE);
		GLjInterface.Current().glClear(GLjInterface.GL_STENCIL_BUFFER_BIT);
		this.computeStencilPolygons();

		try {
			this.renderStencilObjectOn_(renderingContext);
			this.renderInsideModelOn_((JunOpenGLRenderingContext) renderingContext.clone());
			this.renderDisplayObjectOn_(renderingContext);
		} finally {
			GLjInterface.Current().glDisable(GLjInterface.GL_STENCIL_TEST);
			GLjInterface.Current().glStencilMask(GLjInterface.GL_FALSE);
		}
	}

	/**
	 * Render the stencil object on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.objects.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	protected void renderStencilObjectOn_(JunOpenGLRenderingContext renderingContext) {
		GLjInterface.Current().glColorMask(false, false, false, false);
		renderingContext.disableDepthMask();

		try {
			GLjInterface.Current().glStencilFunc(GLjInterface.GL_ALWAYS, 1, 1);
			GLjInterface.Current().glStencilOp(GLjInterface.GL_REPLACE, GLjInterface.GL_REPLACE, GLjInterface.GL_REPLACE);
			for (int i = 0; i < stencilPolygons.length; i++) {
				this.displayProjector().project_on_(stencilPolygons[i], renderingContext);
			}
		} finally {
			renderingContext.enableDepthMask();
			GLjInterface.Current().glColorMask(true, true, true, true);
		}
	}

	/**
	 * Render the inside model on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.objects.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	protected void renderInsideModelOn_(JunOpenGLRenderingContext renderingContext) {
		GLjInterface.Current().glStencilFunc(GLjInterface.GL_EQUAL, 1, 1);
		GLjInterface.Current().glStencilOp(GLjInterface.GL_KEEP, GLjInterface.GL_KEEP, GLjInterface.GL_KEEP);
		this.insideModel().displayProjector().project_withLights_on_(this.insideModel.displayObject(), this.insideModel().displayLightCollection(), renderingContext);
	}

	/**
	 * Render the display object on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.objects.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dModel#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	protected void renderDisplayObjectOn_(JunOpenGLRenderingContext renderingContext) {
		GLjInterface.Current().glStencilFunc(GLjInterface.GL_NOTEQUAL, 1, 1);
		GLjInterface.Current().glStencilOp(GLjInterface.GL_KEEP, GLjInterface.GL_KEEP, GLjInterface.GL_KEEP);
		JunOpenGLLight[] lightCollection = displayLightCollection();
		JunOpenGL3dObject renderingObject = this.displayObject();
		if (renderingObject == null) {
			this.displayProjector().projectOn_(renderingContext);
		} else {
			if (this.selectedObjects().isEmpty()) {
				this.displayProjector().project_withLights_on_(renderingObject, lightCollection, renderingContext);
			} else {
				JunOpenGLProjector aProjector = (JunOpenGLProjector) this.displayProjector().copy();
				if (this.displayProjector().presentation() == $("solidPresentation")) {
					aProjector.wireframePresentation();
				} else if (this.displayProjector().presentation() == $("wireframePresentation")) {
					aProjector.wireframePresentation();
				} else if (this.displayProjector().presentation() == $("hiddenlinePresentation")) {
					aProjector.hiddenlinePresentation();
				}

				aProjector.project_withLights_on_(renderingObject, lightCollection, renderingContext);

				if (this.displayProjector().presentation() == $("solidPresentation")) {
					aProjector.solidPresentation();
				} else if (this.displayProjector().presentation() == $("wireframePresentation")) {
					aProjector.solidPresentation();
				} else if (this.displayProjector().presentation() == $("hiddenlinePresentation")) {
					aProjector.solidPresentation();
				}

				Object[] objects = this.selectedObjects().toArray();
				for (int i = 0; i < objects.length; i++) {
					aProjector.project_on_((JunOpenGL3dObject) objects[i], renderingContext);
				}

			}
		}
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument evt.getAspect() is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		super.update_(evt);

		if (evt.getAspect() != $("state")) {
			this.changed_(evt);
		}
	}

	/**
	 * Compute the stencil polygons.
	 * 
	 * @category private
	 */
	protected void computeStencilPolygons() {
		final Vector collection = new Vector(32);
		this.stencilObject().polygonsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) anObject;
				Jun3dPoint[] vertexes = aPolygon.vertexes();
				double valueF = (new JunPlane(vertexes[0], vertexes[1], vertexes[2])).valueF_(JunOpenGLMacrocosmModel.this.eyePoint());
				if (valueF > 0) {
					collection.add(aPolygon);
				}
				return null;
			}
		});
		stencilPolygons = (JunOpenGL3dPolygon[]) collection.toArray(new JunOpenGL3dPolygon[collection.size()]);
	}

}
