package jp.co.sra.jun.opengl.chart;

import java.util.Vector;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunChartWithSymbolicKeys class
 * 
 *  @author    nisinaka
 *  @created   1998/11/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartWithSymbolicKeys.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public abstract class JunChartWithSymbolicKeys extends JunChartAbstract {

	public static final double DefaultLeftMargin = 0.05;
	public static final double DefaultRightMargin = 0.05;
	public static final double DefaultInterval = 0.05;

	protected double leftMargin;
	protected double rightMargin;
	protected double interval;

	/**
	 * Create a new instance of JunChartWithSymbolicKeys and initialize it.
	 *
	 * @category Instance creation
	 */
	protected JunChartWithSymbolicKeys() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	protected JunChartWithSymbolicKeys(Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	protected JunChartWithSymbolicKeys(Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	protected JunChartWithSymbolicKeys(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		leftMargin = DefaultLeftMargin;
		rightMargin = DefaultRightMargin;
		interval = DefaultInterval;
	}

	/**
	 * Answer the left margin of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double leftMargin() {
		return leftMargin;
	}

	/**
	 * Set the left margin of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void leftMargin_(double aNumber) {
		leftMargin = aNumber;
	}

	/**
	 * Answer the right margin of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double rightMargin() {
		return rightMargin;
	}

	/**
	 * Set the right margin of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void rightMargin_(double aNumber) {
		rightMargin = aNumber;
	}

	/**
	 * Answer the interval between the chart elements of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double interval() {
		return interval;
	}

	/**
	 * Set the interval between the chart elements of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void interval_(double aNumber) {
		interval = aNumber;
	}

	/**
	 * Initialize the receiver with the attributes of the chart.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartWithSymbolicKeys
	 * @category copying
	 */
	protected void _copyAttributes(JunChartWithSymbolicKeys aChart) {
		super._copyAttributes(aChart);
		aChart.leftMargin_(leftMargin);
		aChart.rightMargin_(rightMargin);
		aChart.interval_(interval);
	}

	/**
	 * Create a JunOpenGL3dObject of x-axis labels.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createXAxisLabels() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		int size = this.data().sheet().rowSize();
		double width = (1 - this.leftMargin() - this.rightMargin() - this.interval() * (size - 1)) / size;
		double x = this.leftMargin() + (width / 2);
		for (int i = 0; i < size; i++) {
			Jun3dPoint[] points = { new Jun3dPoint(x, 0, 0), new Jun3dPoint(x, -0.05, 0) };
			compoundObject.add_(new JunOpenGL3dPolyline(points, this.axisColor()));
			compoundObject.add_(this.label_topCenterAt_(this.xAxisLabels()[i], new Jun3dPoint(x, -0.05, 0)));
			x += (width + this.interval());
		}

		return compoundObject;
	}
}
