package jp.co.sra.jun.opengl.chart;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunChartWithNumericalKeys class
 * 
 *  @author    nisinaka
 *  @created   1999/01/13 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartWithNumericalKeys.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public abstract class JunChartWithNumericalKeys extends JunChartAbstract {

	/**
	 * Answer the class for the chart data of this chart.
	 * 
	 * @return java.lang.Class
	 * @category Accessing
	 */
	public static Class ChartDataClass() {
		return JunChartDataWithNumericalKeys.class;
	}

	/**
	 * Create a new instance of JunChartWithNumericalKeys and initialize it.
	 *
	 * @category Instance creation
	 */
	protected JunChartWithNumericalKeys() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	protected JunChartWithNumericalKeys(java.util.Vector aCollectionOfSample) {
		this();
		this.data_(new JunChartDataWithNumericalKeys(aCollectionOfSample));
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	protected JunChartWithNumericalKeys(java.util.Vector aCollectionOfSample, int numberOfKeys) {
		this();
		this.data_(new JunChartDataWithNumericalKeys(aCollectionOfSample, numberOfKeys));
	}

	/**
	 * Create a new instance of a Chart and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	protected JunChartWithNumericalKeys(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Set the information about the key range.
	 * 
	 * @param minimumNumber double
	 * @param maximumNumber double
	 * @category accessing
	 */
	public void keyRangeFrom_to_(double minimumNumber, double maximumNumber) {
		((JunChartDataWithNumericalKeys) this.data()).keyRangeFrom_to_(minimumNumber, maximumNumber);
	}

	/**
	 * Set the information about the key range.
	 * 
	 * @param minimumNumber double
	 * @param maximumNumber double
	 * @param interval double
	 * @category accessing
	 */
	public void keyRangeFrom_to_(double minimumNumber, double maximumNumber, double interval) {
		((JunChartDataWithNumericalKeys) this.data()).keyRangeFrom_to_by_(minimumNumber, maximumNumber, interval);
	}

	/**
	 * Action for a menu : Spawn a line chart.
	 * 
	 * @category menu messages
	 */
	public void spawnLineChart() {
		JunChartLineWithNumericalKeys aChart = new JunChartLineWithNumericalKeys();
		this._copyAttributes(aChart);
		aChart.open();
	}

	/**
	 * Action for a menu : Spawn a plot chart.
	 * 
	 * @category menu messages
	 */
	public void spawnPlotChart() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys();
		this._copyAttributes(aChart);
		aChart.open();
	}

	/**
	 * Create a JunOpenGL3dObject of x-axis labels.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createXAxisLabels() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunChartDataWithNumericalKeys data = (JunChartDataWithNumericalKeys) this.data();
		double minimumNumber = data.minimumOfKeyRange();
		double maximumNumber = data.maximumOfKeyRange();
		double interval = data.intervalOfKeyRange();
		for (double aNumber = (Math.floor(minimumNumber / interval) + 1) * interval; aNumber <= Math.floor(maximumNumber / interval) * interval; aNumber += interval) {
			if (aNumber != minimumNumber && aNumber != maximumNumber) {
				double x = data.normalizeKey_(aNumber);
				Jun3dPoint[] points = { new Jun3dPoint(x, 0, 0), new Jun3dPoint(x, -0.05, 0) };
				compoundObject.add_(new JunOpenGL3dPolyline(points, this.axisColor()));
				compoundObject.add_(this.label_topCenterAt_(String.valueOf(aNumber), new Jun3dPoint(x, -0.05, 0)));
			}
		}

		return compoundObject;
	}
}
