package jp.co.sra.jun.opengl.chart;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunChartPlot class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartPlot.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartPlot extends JunChartWithSymbolicKeys {

	public static final double DefaultPointSize = 0.01;

	protected double pointSize;

	/**
	 * Create a new instance of JunChartPlot and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunChartPlot() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	public JunChartPlot(java.util.Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartPlot(java.util.Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	public JunChartPlot(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		pointSize = DefaultPointSize;
	}

	/**
	 * Answer the point size of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double pointSize() {
		return pointSize;
	}

	/**
	 * Set the point size of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void pointSize_(double aNumber) {
		pointSize = aNumber;
	}

	/**
	 * Initialize the receiver with the attributes of the chart.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartPlot
	 * @category copying
	 */
	protected void _copyAttributes(JunChartPlot aChart) {
		super._copyAttributes(aChart);
		aChart.pointSize_(pointSize);
	}

	/**
	 * Create a JunOpenGL3dObject which represents the chart.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category private
	 */
	protected JunOpenGL3dCompoundObject createChart3dObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunChartData myData = this.data();
		JunChartDataSheet[] sheets = myData.sheets();
		if (sheets == null) {
			return compoundObject;
		}

		for (int n = 0; n < sheets.length; n++) {
			JunChartDataSheet sheet = sheets[n];
			double z = this.intervalBetweenCharts() * n;
			int rowSize = sheet.rowSize();
			for (int i = 0; i < rowSize; i++) {
				Object[] keys = sheet.valuesAtRow_(i);
				Object[] values = sheet.valuesAtRow_(i);
				double width = (1 - this.leftMargin() - this.rightMargin() - this.interval() * (rowSize - 1)) / rowSize;
				double x = this.leftMargin() + ((width + this.interval) * i) + (width / 2);
				for (int j = 0; j < values.length; j++) {
					JunOpenGL3dObject vertex = this.createSmallCubeAt_(new Jun3dPoint(x, myData.normalizeValue_(((Number) values[j]).doubleValue()), z));
					vertex.paint_(this.nextColor());
					compoundObject.add_(vertex);
					this.registerVisualObject_withValue_(vertex, new Object[] { keys, values[j] });
				}
			}
		}

		return compoundObject;
	}

	/**
	 * Create a small cube to represents the point.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createSmallCubeAt_(Jun3dPoint a3dPoint) {
		double size = this.pointSize();
		JunOpenGL3dObject vertex = JunOpenGL3dObject.Box_(new Jun3dPoint(size, size, size));
		vertex = vertex.translatedBy_((Jun3dPoint) a3dPoint.minus_(size / 2));
		return vertex;
	}
}
