package jp.co.sra.jun.opengl.chart;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunChartCombination class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun642 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartCombination.java,v 8.13 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartCombination extends JunOpenGLDisplayModel {

	protected static double DefaultIntervalBetweenCharts = 0.3;

	protected ArrayList charts;
	protected HashMap visualObjectDictionary;
	protected double intervalBetweenCharts;

	/**
	 * Create a new instance of JunChartCombination and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunChartCombination() {
		super();
	}

	/**
	 * Create a new instance of JunChartCombination and initialize it with the collection of charts.
	 * 
	 * @param aCollection java.util.Collection
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static JunChartCombination Charts_(Collection aCollection) {
		JunChartCombination aChart = new JunChartCombination();
		aChart.charts_(aCollection);
		return aChart;
	}

	/**
	 * Create a new instance of JunChartCombination with the chart.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static JunChartCombination With_(JunChartAbstract aChart) {
		JunChartCombination aChartCombination = new JunChartCombination();
		aChartCombination.add_(aChart);
		return aChartCombination;
	}

	/**
	 * Create a new instance of JunChartCombination with the chart.
	 * 
	 * @param aChart1 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart2 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static JunChartCombination With_with_(JunChartAbstract aChart1, JunChartAbstract aChart2) {
		JunChartCombination aChartCombination = new JunChartCombination();
		aChartCombination.add_(aChart1);
		aChartCombination.add_(aChart2);
		return aChartCombination;
	}

	/**
	 * Create a new instance of JunChartCombination with the chart.
	 * 
	 * @param aChart1 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart2 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart3 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * 
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static JunChartCombination With_with_with_(JunChartAbstract aChart1, JunChartAbstract aChart2, JunChartAbstract aChart3) {
		JunChartCombination aChartCombination = new JunChartCombination();
		aChartCombination.add_(aChart1);
		aChartCombination.add_(aChart2);
		aChartCombination.add_(aChart3);
		return aChartCombination;
	}

	/**
	 * Create a new instance of JunChartCombination with the chart.
	 * 
	 * @param aChart1 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart2 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart3 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @param aChart4 jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static JunChartCombination With_with_with_with_(JunChartAbstract aChart1, JunChartAbstract aChart2, JunChartAbstract aChart3, JunChartAbstract aChart4) {
		JunChartCombination aChartCombination = new JunChartCombination();
		aChartCombination.add_(aChart1);
		aChartCombination.add_(aChart2);
		aChartCombination.add_(aChart3);
		aChartCombination.add_(aChart4);
		return aChartCombination;
	}

	/**
	 * Create a new instance of JunChartCombination and initialize it with the collection of charts.
	 * 
	 * @param aCollection java.util.Vector
	 * @return jp.co.sra.jun.opengl.chart.JunChartCombination
	 * @category Instance creation
	 */
	public static final JunChartCombination WithAll_(Vector aCollection) {
		return JunChartCombination.Charts_(aCollection);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		//this.initializeLights();
		this.initializeProjector();
		charts = null;
		visualObjectDictionary = null;
		intervalBetweenCharts = DefaultIntervalBetweenCharts;
	}

	/**
	 * Initialize the lights.
	 * 
	 * @category initialize-release
	 */
	protected void initializeLights() {
		JunOpenGLDisplayLight[] lights = this.displayLights();
		for (int i = 0; i < lights.length; i++) {
			lights[i].beOff();
		}
	}

	/**
	 * Initialize the default projector.
	 * 
	 * @category initialize-release
	 */
	protected void initializeProjector() {
		this.defaultEyePoint_(new Jun3dPoint(0.5, 0.5, 100.0));
		this.defaultSightPoint_(new Jun3dPoint(0.5, 0.5, 0.0));
		this.defaultUpVector_(new Jun3dPoint(0, 1, 0));
	}

	/**
	 * Add the chart to the receiver.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartAbstract
	 * @category accessing
	 */
	public void add_(JunChartAbstract aChart) {
		this.charts().add(aChart);
		this.flushDisplayObject();
	}

	/**
	 * Answer the collection of charts.
	 * 
	 * @return java.util.ArrayList
	 * @category accessing
	 */
	public ArrayList charts() {
		if (charts == null) {
			charts = new ArrayList();
		}
		return charts;
	}

	/**
	 * Set the collection of charts.
	 * 
	 * @param aCollection java.util.Collection
	 * @category accessing
	 */
	public void charts_(Collection aCollection) {
		charts = new ArrayList();
		charts.addAll(aCollection);
		this.flushDisplayObject();
	}

	/**
	 * Answer the JunOpenGL3dObject to show.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject displayObject() {
		if (super.displayObject() == null) {
			super.displayObject_(this.asJunOpenGL3dObject());
		}
		return super.displayObject();
	}

	/**
	 * Answer the interval between charts of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double intervalBetweenCharts() {
		return intervalBetweenCharts;
	}

	/**
	 * Set the inteval between charts of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void intervalBetweenCharts_(double aNumber) {
		intervalBetweenCharts = aNumber;
	}

	/**
	 * Answer the Object which corresponds to the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object valueForVisualObject_(JunOpenGL3dObject a3dObject) {
		if (a3dObject == null) {
			return null;
		}

		return this.visualObjectDictionary.get(a3dObject);
	}

	/**
	 * Answer the hash map for all visual objects.
	 * 
	 * @return java.util.HashMap
	 * @category accessing
	 */
	public HashMap visualObjectDictionary() {
		if (visualObjectDictionary == null) {
			visualObjectDictionary = new HashMap();
		}
		return visualObjectDictionary;
	}

	/**
	 * Convert the receiver as a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		int size = this.charts().size();
		JunChartAbstract[] arrayOfCharts = new JunChartAbstract[size];
		this.charts().toArray(arrayOfCharts);
		for (int i = 0; i < size; i++) {
			JunOpenGL3dObject[] components = ((JunOpenGL3dCompoundObject) arrayOfCharts[i].displayObject().translatedBy_(new Jun3dPoint(0, 0, this.intervalBetweenCharts() * i))).components();
			compoundObject.addAll_(components);
			HashMap dictionary = arrayOfCharts[i].visualObjectDictionary();
			Iterator keys = dictionary.keySet().iterator();
			while (keys.hasNext()) {
				Object key = keys.next();
				Object value = dictionary.get(key);
				this.visualObjectDictionary().put(key, value);
			}
		}

		return compoundObject;
	}

	/**
	 * Answer the block closure to evaluate which an object is picked.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category defaults
	 */
	protected StBlockClosure defaultActionForPickedObject() {
		return new StBlockClosure();
	}

	/**
	 * Flush the cache for display objects.
	 * 
	 * @category flushing
	 */
	protected void flushDisplayObject() {
		super.flushDisplayObject();
		visualObjectDictionary = null;
	}

	/**
	 * Answer the JunOpenGL3dObject at the specified point on the view.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param anEvent java.awt.event.MouseEvent
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category manipulating
	 */
	public JunOpenGL3dObject pick_with_(Jun2dPoint aPoint, MouseEvent anEvent) {
		JunOpenGL3dObject pickedObject = super.pick_with_(aPoint, anEvent);
		if (pickedObject != null) {
			this.pickedObject_(pickedObject);
		}
		return pickedObject;
	}

	/**
	 * The JunOpenGL3dObject is picked. Do something according to the definition.
	 * 
	 * @param anObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category manipulating
	 */
	protected void pickedObject_(JunOpenGL3dObject anObject) {
		this.defaultActionForPickedObject().value_(anObject);
	}

	/**
	 * Answer the title string.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#windowTitle()
	 * @category interface opening
	 */
	public String windowTitle() {
		return $String("3D Chart");
	}

}
