package jp.co.sra.jun.metaball.solid;

import java.util.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.transformations.*;

/**
 * JunTransformedMetaballSolid class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTransformedMetaballSolid.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunTransformedMetaballSolid extends JunMetaballSolid {
	/** inversed transformation. */
	protected Jun3dTransformation transformationInv;

	/**
	 * Create a new instance of JunTransformedMetaballSolid and set it with
	 * ransformation, threshold
	 * 
	 * @param aNumber
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaballSolid
	 */
	public static JunTransformedMetaballSolid Threshold_transform_(double aNumber, Jun3dTransformation aJun3dTransformation) {
		JunTransformedMetaballSolid solid;
		solid = (JunTransformedMetaballSolid) JunMetaballSolid.Threshold_(aNumber);
		solid.setTransformation_(aJun3dTransformation);

		return solid;
	}

	/**
	 * Create a new instance of JunTransformedMetaballSolid and set it with
	 * collection of JunMetaball, transformation, threshold
	 * 
	 * @param aCollectionOfJunMetaball
	 * @param aNumber
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaballSolid
	 */
	public static JunTransformedMetaballSolid WithAll_threshold_transform_(Vector aCollectionOfJunMetaball, double aNumber, Jun3dTransformation aJun3dTransformation) {
		JunTransformedMetaballSolid solid;
		solid = JunTransformedMetaballSolid.Threshold_transform_(aNumber, aJun3dTransformation);
		solid.addAll_(aCollectionOfJunMetaball);

		return solid;
	}

	/**
	 * Answer the JunTransformedMetaballSolid which is applied the specified
	 * transformation.
	 * 
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaballSolid
	 */
	public JunTransformedMetaballSolid transform_(Jun3dTransformation aJun3dTransformation) {
		Jun3dTransformation aT;
		aT = (Jun3dTransformation) transformationInv.inverse().transform_(aJun3dTransformation);

		return JunTransformedMetaballSolid.WithAll_threshold_transform_(metaballs, threshold, aT);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return super.valueAt_((Jun3dPoint) aJun3dPoint.transform_(transformationInv));
	}

	/**
	 * set the specified transformation.
	 * 
	 * @param aJun3dTransformation
	 */
	protected void setTransformation_(Jun3dTransformation aJun3dTransformation) {
		this.transformationInv = (Jun3dTransformation) aJun3dTransformation.inverse();
	}
}
