package jp.co.sra.jun.metaball.solid;

import java.awt.Color;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.atoms.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.system.support.*;

/**
 * JunMetaballSolidTestExamples class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaballSolidTestExamples.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMetaballSolidTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		try {
			JunMetaballSolid solid;
			JunMetaSphere ball1;
			JunMetaSphere ball2;
			JunMetaSphere ball3;
			Jun3dPoint aPoint;

			solid = new JunMetaballSolid();
			solid.threshold_(1.0d);
			aPoint = new Jun3dPoint(0.0, 0.0, 0.0);
			ball1 = JunMetaSphere.Center_order_weight_(aPoint, 2, 0.4);
			aPoint = new Jun3dPoint(0.0, 0.0, 1.0);
			ball2 = JunMetaSphere.Center_order_weight_(aPoint, 2, 0.4);
			aPoint = new Jun3dPoint(0.0, 0.0, -1.0);
			ball3 = JunMetaSphere.Center_order_weight_(aPoint, 2, 0.4);
			solid.add_(ball1);
			solid.add_(ball2);
			solid.add_(ball3);

			StInterval xInterval = new StInterval(-2, 2, 0.2);
			StInterval yInterval = new StInterval(-2, 2, 0.2);
			StInterval zInterval = new StInterval(-2, 2, 0.2);
			JunOpenGL3dObject aJunOpenGL3dObject = solid.asJunOpenGL3dObjectXInterval_yInterval_zInterval_(xInterval, yInterval, zInterval);
			aJunOpenGL3dObject.paint_(Color.white);
			aJunOpenGL3dObject.show();

			//return solid;
			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example2() {
		try {
			JunMetaballSolid solid;
			JunMetaSphere cray;
			JunMetaSphere finger;
			Jun3dPoint aPoint;

			solid = JunMetaballSolid.Threshold_(1.0d);
			aPoint = new Jun3dPoint(0.0, 0.0, 0.0);
			cray = JunMetaSphere.Center_order_weight_(aPoint, 2, 1.0);
			aPoint = new Jun3dPoint(1.0, 0.0, 0.0);
			finger = JunMetaSphere.Center_order_weight_(aPoint, 8, -0.1);

			JunOpenGL3dObject smallJunOpenGL3dObject;
			JunOpenGL3dObject largeJunOpenGL3dObject;
			largeJunOpenGL3dObject = JunOpenGL3dObject.Sphere_radius_(15, 1);
			largeJunOpenGL3dObject.paint_(Color.blue);
			aPoint = new Jun3dPoint(1.0, 0.0, 0.0);
			smallJunOpenGL3dObject = JunOpenGL3dObject.Sphere_radius_center_(15, 0.1, aPoint);
			smallJunOpenGL3dObject.paint_(Color.red);
			(new JunOpenGL3dCompoundObject(largeJunOpenGL3dObject, smallJunOpenGL3dObject)).show();

			solid.add_(cray);
			solid.add_(finger);

			StInterval xInterval = StInterval.From_to_by_(-2, 2, 0.2);
			StInterval yInterval = StInterval.From_to_by_(-2, 2, 0.2);
			StInterval zInterval = StInterval.From_to_by_(-2, 2, 0.2);
			JunOpenGL3dObject aJunOpenGL3dObject = solid.asJunOpenGL3dObjectXInterval_yInterval_zInterval_(xInterval, yInterval, zInterval);
			aJunOpenGL3dObject.paint_(Color.blue);
			aJunOpenGL3dObject.show();

			//return solid;
			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 * 
	 * @throws Exception DOCUMENT ME!
	 */
	public static void main(String[] args) throws Exception {
		new JunMetaballSolidTestExamples();
	}
}
