package jp.co.sra.jun.metaball.solid;

import java.util.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.csg.atoms.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.boundaries.*;
import jp.co.sra.jun.geometry.transformations.*;
import jp.co.sra.jun.metaball.abstracts.*;
import jp.co.sra.jun.octree.basic.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.solid.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMetaballSolid class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaballSolid.java,v 8.11 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMetaballSolid extends JunSolidModel {
	public static final double defaultThreshold = 1.0d;

	/** metaballs. */
	protected Vector metaballs;

	/** threshold. */
	protected double threshold;

	/**
	 * Create a new instance of <code>JunMetaballSolid</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunMetaballSolid() {
		super();
	}

	/**
	 * Create a new instance of JunMetaballSolid and initialize it with the
	 * threshold (double).
	 * 
	 * @param aNumber
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid Threshold_(double aNumber) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.threshold_(aNumber);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and initialize it with the
	 * threshold (int).
	 * 
	 * @param aNumber
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid Threshold_(int aNumber) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.threshold_((double) aNumber);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 1 metaball.
	 * 
	 * @param aJunMetaball
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_(JunMetaball aJunMetaball) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.add_(aJunMetaball);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 1 metaball and
	 * threshold.
	 * 
	 * @param aJunMetaball
	 * @param aNumber
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_threshold_(JunMetaball aJunMetaball, double aNumber) {
		JunMetaballSolid solid = JunMetaballSolid.Threshold_(aNumber);
		solid.add_(aJunMetaball);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 2 metaballs.
	 * 
	 * @param aJunMetaball1
	 * @param aJunMetaball2
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_with_(JunMetaball aJunMetaball1, JunMetaball aJunMetaball2) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.add_(aJunMetaball1);
		solid.add_(aJunMetaball2);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 2 metaballs
	 * and threshold.
	 * 
	 * @param aJunMetaball1
	 * @param aJunMetaball2
	 * @param aNumber
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_with_threshold_(JunMetaball aJunMetaball1, JunMetaball aJunMetaball2, double aNumber) {
		JunMetaballSolid solid = JunMetaballSolid.Threshold_(aNumber);
		solid.add_(aJunMetaball1);
		solid.add_(aJunMetaball2);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 3 metaballs.
	 * 
	 * @param aJunMetaball1
	 * @param aJunMetaball2
	 * @param aJunMetaball3
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_with_with_(JunMetaball aJunMetaball1, JunMetaball aJunMetaball2, JunMetaball aJunMetaball3) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.add_(aJunMetaball1);
		solid.add_(aJunMetaball2);
		solid.add_(aJunMetaball3);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 3 metaballs
	 * and threshold.
	 * 
	 * @param aJunMetaball1
	 * @param aJunMetaball2
	 * @param aJunMetaball3
	 * @param aNumber
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_with_with_threshold_(JunMetaball aJunMetaball1, JunMetaball aJunMetaball2, JunMetaball aJunMetaball3, double aNumber) {
		JunMetaballSolid solid = JunMetaballSolid.Threshold_(aNumber);
		solid.add_(aJunMetaball1);
		solid.add_(aJunMetaball2);
		solid.add_(aJunMetaball3);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with 4 metaballs.
	 * 
	 * @param aJunMetaball1
	 * @param aJunMetaball2
	 * @param aJunMetaball3
	 * @param aJunMetaball4
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid With_with_with_with_(JunMetaball aJunMetaball1, JunMetaball aJunMetaball2, JunMetaball aJunMetaball3, JunMetaball aJunMetaball4) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.add_(aJunMetaball1);
		solid.add_(aJunMetaball2);
		solid.add_(aJunMetaball3);
		solid.add_(aJunMetaball4);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with vectors of
	 * metaballs.
	 * 
	 * @param aCollectionOfJunMetaball
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid WithAll_(Vector aCollectionOfJunMetaball) {
		JunMetaballSolid solid = new JunMetaballSolid();
		solid.addAll_(aCollectionOfJunMetaball);

		return solid;
	}

	/**
	 * Create a new instance of JunMetaballSolid and set it with vectors of
	 * metaballs and threshold.
	 * 
	 * @param aCollectionOfJunMetaball
	 * @param aNumber
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 */
	public static final JunMetaballSolid WithAll_threshold_(Vector aCollectionOfJunMetaball, double aNumber) {
		JunMetaballSolid solid = JunMetaballSolid.Threshold_(aNumber);
		solid.addAll_(aCollectionOfJunMetaball);

		return solid;
	}

	/**
	 * add the specified element of JunMetaball.
	 * 
	 * @param aJunMetaball
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunMetaballSolid add_(JunMetaball aJunMetaball) {
		this.metaballs.addElement(aJunMetaball);

		return this;
	}

	/**
	 * add all the specified elements of JunMetaball.
	 * 
	 * @param aCollectionOfJunMetaball
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunMetaballSolid addAll_(Vector aCollectionOfJunMetaball) {
		int size = aCollectionOfJunMetaball.size();

		for (int i = 0; i < size; i++) {
			this.add_((JunMetaball) aCollectionOfJunMetaball.elementAt(i));
		}

		return this;
	}

	/**
	 * return the JunSolidCSG created on this.
	 * 
	 * @return jp.co.sra.jun.csg.atoms.JunSolidCSG
	 */
	public JunSolidCSG asCSGSolid() {
		return JunSolidCSG.On_(this);
	}

	/**
	 * return the JunBody created on this with x intervals, y intervals and z
	 * intervals.
	 * 
	 * @param xInterval StInterval
	 * @param yInterval StInterval
	 * @param zInterval StInterval
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody asJunBodyXInterval_yInterval_zInterval_(StInterval xInterval, StInterval yInterval, StInterval zInterval) {
		StBlockClosure evaluatingBlock;
		StBlockClosure dummyBlock;
		final JunMetaballSolid self = this; // urawaza
		evaluatingBlock = new StBlockClosure() {
			public Object value_value_value_(Object anObject1, Object anObject2, Object anObject3) {
				Jun3dPoint aJun3dPoint = new Jun3dPoint(((Double) anObject1).doubleValue(), ((Double) anObject2).doubleValue(), ((Double) anObject3).doubleValue());

				return new Double(self.valueAt_(aJun3dPoint));
			}
		};

		dummyBlock = new StBlockClosure();

		return JunBorderGenerator.ContourBodyFrom_at_sign_xInterval_yInterval_zInterval_interim_(evaluatingBlock, this.threshold, 1, xInterval, yInterval, zInterval, dummyBlock);
	}

	/**
	 * return the JunOctree created on this.
	 * 
	 * @param anInteger
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree;
	 */
	public jp.co.sra.jun.octree.basic.JunOctree asJunBoxelOctreeDepth_bounds_(int anInteger, Jun3dBoundingBox aJun3dBoundingBox) {
		final JunMetaballSolid self = this; // urawaza

		return JunOctree.FromBlock_depth_bounds_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint point = (Jun3dPoint) anObject;

				return new Boolean(self.containsPoint_(point));
			}
		}, anInteger, aJun3dBoundingBox);
	}

	/**
	 * return the JunOctree created on this.
	 * 
	 * @param anInteger
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree;
	 */
	public JunOctree asJunBrepsOctreeDepth_bounds_(int anInteger, Jun3dBoundingBox aJun3dBoundingBox) {
		final JunMetaballSolid self = this; // urawaza
		JunOctree octree = JunOctree.Bounds_(aJun3dBoundingBox);
		octree.brepsBlock_depth_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint point = (Jun3dPoint) anObject;

				return new Boolean(self.containsPoint_(point));
			}
		}, anInteger);

		return octree;
	}

	/**
	 * return the JunOpenGL3dObject created on this with x intervals, y
	 * intervals and z intervals.
	 * 
	 * @param xInterval StInterval
	 * @param yInterval StInterval
	 * @param zInterval StInterval
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObjectXInterval_yInterval_zInterval_(StInterval xInterval, StInterval yInterval, StInterval zInterval) {
		JunOpenGL3dObject aJunOpenGL3dObject;
		aJunOpenGL3dObject = (JunOpenGL3dObject) this.asJunBodyXInterval_yInterval_zInterval_(xInterval, yInterval, zInterval).asJunOpenGL3dObject();
		aJunOpenGL3dObject.paint_(null);

		return aJunOpenGL3dObject;
	}

	/**
	 * Answer true if the receiver contains the specified point, otherwise false.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return boolean
	 * @see jp.co.sra.jun.solid.abstracts.JunSolidModel#containsPoint_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category testing
	 */
	public boolean containsPoint_(Jun3dPoint aJun3dPoint) {
		return this.valueAt_(aJun3dPoint) >= 0;
	}

	/**
	 * remove the specified element of JunMetaball.
	 * 
	 * @param aJunMetaball
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunMetaballSolid remove_(JunMetaball aJunMetaball) {
		this.metaballs.removeElement(aJunMetaball);

		return this;
	}

	/**
	 * remove the specified element of JunMetaball. if none eval errorBlock.
	 * 
	 * @param aJunMetaball
	 * @param errorBlock
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunMetaball remove_ifAbsent_(JunMetaball aJunMetaball, StBlockClosure errorBlock) {
		if (this.metaballs.contains(aJunMetaball)) {
			this.metaballs.removeElement(aJunMetaball);

			return aJunMetaball;
		} else {
			return (JunMetaball) errorBlock.value();
		}
	}

	/**
	 * answer the threshold.
	 * 
	 * @return double
	 */
	public double threshold() {
		return this.threshold;
	}

	/**
	 * set the threshold.
	 * 
	 * @param aNumber
	 */
	public void threshold_(double aNumber) {
		this.threshold = aNumber;
	}

	/**
	 * Answer the JunTransformedMetaballSolid which is applied the specified
	 * transformation.
	 * 
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaballSolid
	 */
	public JunTransformedMetaballSolid transform_(Jun3dTransformation aJun3dTransformation) {
		return JunTransformedMetaballSolid.WithAll_threshold_transform_(metaballs, this.threshold, aJun3dTransformation);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint
	 * @return double
	 * @see jp.co.sra.jun.solid.abstracts.JunSolidModel#valueAt_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		double value = 0;

		for (int i = 0; i < metaballs.size(); i++) {
			JunMetaball metaball = (JunMetaball) metaballs.elementAt(i);
			value += metaball.valueAt_(aJun3dPoint);
		}

		return value - this.threshold;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		this.threshold = defaultThreshold;
		this.metaballs = new Vector();
	}
}
