package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.transformations.*;
import jp.co.sra.jun.metaball.abstracts.*;

/**
 * JunTransformedMetaball class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTransformedMetaball.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunTransformedMetaball extends JunMetaball {
	/** metaball. */
	private JunMetaball metaball;

	/** inversed transformation. */
	private Jun3dTransformation transformationInv;

	/**
	 * Create a new instance of JunTransformedMetaball and set it with solid,
	 * insideValue and outsideValue.
	 * 
	 * @param aJunMetaball
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunSolidMetaball
	 */
	public static JunTransformedMetaball On_transform_(JunMetaball aJunMetaball, Jun3dTransformation aJun3dTransformation) {
		JunTransformedMetaball aJunTransformedMetaball = new JunTransformedMetaball();
		aJunTransformedMetaball.setMetaball_transformation_(aJunMetaball, aJun3dTransformation);

		return aJunTransformedMetaball;
	}

	/**
	 * Answer the JunTransformedMetaball which is applied the specified
	 * transformation.
	 * 
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunTransformedMetaball
	 */
	public JunTransformedMetaball transform_(Jun3dTransformation aJun3dTransformation) {
		return JunTransformedMetaball.On_transform_(metaball, (Jun3dTransformation) transformationInv.inverse().transform_(aJun3dTransformation));
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return metaball.valueAt_((Jun3dPoint) aJun3dPoint.transform_(transformationInv));
	}

	/**
	 * set the JunTransformedMetaball which is applied the specified metaball
	 * and transformation.
	 * 
	 * @param aJunMetaball
	 * @param aJun3dTransformation
	 * 
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaball
	 */
	protected JunTransformedMetaball setMetaball_transformation_(JunMetaball aJunMetaball, Jun3dTransformation aJun3dTransformation) {
		this.metaball = aJunMetaball;
		this.transformationInv = (Jun3dTransformation) aJun3dTransformation.inverse();

		return this;
	}
}
