package jp.co.sra.jun.graphics.navigator;

import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.movie.framework.JunMovieViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunMultiMediaNavigatorViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/11/30 (by m-asada)
 *  @updated   2007/03/14 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun656 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaNavigatorViewAwt.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMultiMediaNavigatorViewAwt extends JunAbstractViewPanel implements JunMultiMediaNavigatorView {
	protected JunFileNavigatorViewAwt fileView;
	protected JunMultiMediaTextViewAwt textView;
	protected JunMultiMediaImageViewAwt imageView;
	protected JunMultiMediaMovieViewAwt movieView;
	protected JunMultiMediaBodyViewAwt bodyView;

	/**
	 * Create a new instance of <code>JunMultiMediaNavigatorViewAwt</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigator
	 * @category Instance creation
	 */
	public JunMultiMediaNavigatorViewAwt(JunMultiMediaNavigator aModel) {
		super(aModel);
	}

	/**
	 * Answer the receiver's model as <code>JunMultiMediaNavigator</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigator
	 * @see jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigatorView#getMultiMediaNavigator()
	 * @category accessing
	 */
	public JunMultiMediaNavigator getMultiMediaNavigator() {
		return (JunMultiMediaNavigator) this.model();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewAwt#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		fileView = null;
		textView = null;
		imageView = null;
		movieView = null;
		bodyView = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileView(), WindowSpecLayout.Position(0f, 0, 1f, -281, 1f, 0, 1f, 0));
		this.add(this.textView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -281));
		this.add(this.imageView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -281));
		this.add(this.movieView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -281));
		this.add(this.bodyView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -281));
		this.setSize(500, 600);
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.graphics.navigator.JunFileNavigatorViewAwt
	 * @category user interface
	 */
	public JunFileNavigatorViewAwt fileView() {
		if (fileView == null) {
			fileView = new JunFileNavigatorViewAwt(this.getMultiMediaNavigator().fileModel());
		}
		return fileView;
	}

	/**
	 * Answer my text view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewAwt
	 * @category user interface
	 */
	public JunMultiMediaTextViewAwt textView() {
		if (textView == null) {
			textView = new JunMultiMediaTextViewAwt(this.getMultiMediaNavigator().textModel());
			textView.setVisible(false);
		}
		return textView;
	}

	/**
	 * Answer my image view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewAwt
	 * @category user interface
	 */
	public JunMultiMediaImageViewAwt imageView() {
		if (imageView == null) {
			imageView = new JunMultiMediaImageViewAwt(this.getMultiMediaNavigator().imageModel());
			imageView.setVisible(false);
		}
		return imageView;
	}

	/**
	 * Answer my movie view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewAwt
	 * @category user interface
	 */
	public JunMultiMediaMovieViewAwt movieView() {
		if (movieView == null) {
			movieView = new JunMultiMediaMovieViewAwt(this.getMultiMediaNavigator().movieModel());
			movieView.setVisible(false);
		}
		return movieView;
	}

	/**
	 * Answer my body view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyViewAwt
	 * @category user interface
	 */
	public JunMultiMediaBodyViewAwt bodyView() {
		if (bodyView == null) {
			bodyView = new JunMultiMediaBodyViewAwt(this.getMultiMediaNavigator().bodyModel());
			bodyView.setVisible(false);
		}
		return bodyView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		super._setupKeyboard(aWindow);

		KeyListener keyListener = this.movieView().getMoviePlayer()._keyListener();
		if (keyListener == null) {
			return;
		}

		final JunMovieViewAwt moviePlayerView = this.movieView().movieView();
		moviePlayerView.addKeyListener(keyListener);
		moviePlayerView.addMouseListener(new MouseAdapter() {
			public void mouseEntered(MouseEvent e) {
				if (aWindow.isActive() && aWindow.getFocusOwner() != moviePlayerView) {
					moviePlayerView.requestFocus();
				}
			}
		});
	}
}
