package jp.co.sra.jun.graphics.navigator;

import java.awt.Point;
import java.util.Map;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.graphics.list.JunFileList;

/**
 * JunEmbeddedFileList class
 * 
 *  @author    nisinaka
 *  @created   2004/01/22 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEmbeddedFileList.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public abstract class JunEmbeddedFileList extends JunFileList {
	protected JunFileNavigator fileNavigator;

	/**
	 * Create a new instance of <code>JunEmbeddedFileList</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunEmbeddedFileList() {
		super(null);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release 
	 */
	protected void initialize() {
		super.initialize();
		fileNavigator = null;
	}

	/**
	 * Answer my current file navigator.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileNavigator
	 * @category accessing
	 */
	public JunFileNavigator fileNavigator() {
		return fileNavigator;
	}

	/**
	 * Set my new file navigator.
	 * 
	 * @param aFileNavigator jp.co.sra.jun.graphics.navigator.JunFileNavigator
	 * @category accessing
	 */
	public void fileNavigator_(JunFileNavigator aFileNavigator) {
		fileNavigator = aFileNavigator;
	}

	/**
	 * Select an item at the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.graphics.graphics.abstracts.JunAbstractItem
	 * @see jp.co.sra.jun.graphics.list.JunFileList#selectItemAt_(java.awt.Point)
	 * @category selection
	 */
	public JunAbstractItem selectItemAt_(Point aPoint) {
		if (this.isNull()) {
			return null;
		}
		if (this.isFile()) {
			return null;
		}

		JunAbstractItem newSelectedItem = this.whichItemAt_(aPoint);
		if (newSelectedItem == null) {
			return null;
		}

		JunAbstractItem oldSelectedItem = this.selectedItem();
		if (newSelectedItem.equals(oldSelectedItem)) {
			return newSelectedItem;
		}

		this.deselectItem_(oldSelectedItem);
		this.selectedItem_(newSelectedItem);
		return newSelectedItem;
	}

	/**
	 * Update the contents.
	 * 
	 * @see jp.co.sra.jun.graphics.list.JunFileList#updateContents()
	 * @category menu messages
	 */
	public synchronized void updateContents() {
		super.updateContents();

		JunFileNavigator aFileNavigator = this.fileNavigator();
		if (aFileNavigator == null) {
			return;
		}

		JunEmbeddedCenterFileList fileList = aFileNavigator.centerList();
		if (fileList.selectedFile() != null) {
			aFileNavigator.centerDirectoryItemPressed_(fileList.selectedFile());
			aFileNavigator.fixScrollingOffset();
		}
	}

	/**
	 * Create the key stroke dispatch table.
	 * 
	 * @return java.util.Map
	 * @category keyboard 
	 */
	protected Map createKeyStrokeDispatchTable() {
		return null;
	}

	/**
	 * Answer my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunEmbeddedFileListViewAwt(this);
		} else {
			return new JunEmbeddedFileListViewSwing(this);
		}
	}
}
