package jp.co.sra.jun.graphics.list;

import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.graphics.framework.JunGraphicModel;
import jp.co.sra.jun.graphics.map.JunSequenceMap;

/**
 * JunSequenceList class
 * 
 *  @author    nisinaka
 *  @created   2004/01/09 (by nisinaka)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSequenceList.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunSequenceList extends JunGraphicModel {
	protected JunSequenceMap sequenceMap;

	/**
	 * Create a new instance of <code>JunSequenceList</code> and initialize it.
	 * This constructor may not be called directly, but defined for my subclasses.
	 * 
	 * @category Instance creation
	 */
	public JunSequenceList() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSequenceList</code> and initialize it.
	 * 
	 * @param aSequenceMap jp.co.sra.jun.graphics.map.JunSequenceMap
	 * @category Instance creation
	 */
	public JunSequenceList(JunSequenceMap aSequenceMap) {
		super();
		this.sequenceMap_(aSequenceMap);
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		sequenceMap = null;
	}

	/**
	 * Answer my current sequence map.
	 * 
	 * @return jp.co.sra.jun.graphics.map.JunSequenceMap
	 * @category accessing
	 */
	public JunSequenceMap sequenceMap() {
		if (sequenceMap == null) {
			sequenceMap = this.makeSequenceMap();
		}
		return sequenceMap;
	}

	/**
	 * Set my new sequence map.
	 * 
	 * @param aSequenceMap jp.co.sra.jun.graphics.map.JunSequenceMap
	 * @category accessing
	 */
	public void sequenceMap_(JunSequenceMap aSequenceMap) {
		sequenceMap = aSequenceMap;
	}

	/**
	 * Answer my display object.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicModel#displayObject()
	 * @category accessing
	 */
	public StDisplayable displayObject() {
		return this.sequenceMap();
	}

	/**
	 * Answer the index of the specified item.
	 * 
	 * @param anItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @return int
	 * @category accessing
	 */
	public int indexOfItem_(JunAbstractItem anItem) {
		return this.sequenceMap().componentItems().indexOf(anItem);
	}

	/**
	 * Answer the item at the specified index.
	 * 
	 * @param anIndex int
	 * @return jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category accessing
	 */
	public JunAbstractItem itemAt_(int anIndex) {
		return this.sequenceMap().componentItemAt_(anIndex);
	}

	/**
	 * Enumerate all items and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object itemsDo_(StBlockClosure aBlock) {
		Object[] items = this.sequenceMap().componentItems().toArray();
		for (int i = 0; i < items.length; i++) {
			Object result = aBlock.value_(items[i]);
			if (result != null) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Answer my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunSequenceListViewAwt(this);
		} else {
			return new JunSequenceListViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Sequence");
	}

	/**
	 * Make a sequence map.
	 * 
	 * @return jp.co.sra.jun.graphics.map.JunSequenceMap
	 * @category making
	 */
	protected JunSequenceMap makeSequenceMap() {
		return new JunSequenceMap();
	}

	/**
	 * Answer the receiver's scroll offset.
	 * 
	 * @return java.awt.Point
	 * @category scrolling
	 */
	public Point scrollOffset() {
		JunSequenceListView aView = (JunSequenceListView) this.getView();
		return (aView == null) ? new Point(0, 0) : aView.scrollOffset();
	}

	/**
	 * Set the receiver's new scroll offset.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollOffset_(Point aPoint) {
		JunSequenceListView aView = (JunSequenceListView) this.getView();
		if (aView != null) {
			aView.scrollTo_(aPoint);
		}
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		return this.sequenceMap().isEmpty();
	}
}
