package jp.co.sra.jun.goodies.utilities;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunControlUtilityTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/09/29 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunControlUtilityTestExamples.java,v 8.13 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunControlUtilityTestExamples extends JunTestExamples {

	/**
	 * Example_NextMillisecondClockValue_:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_NextMillisecondClockValue_() {
		int tick = 50;
		for (int i = 0; i < 1000; i++) {
			long time = JunControlUtility.NextMillisecondClockValue_(tick);
			long currentTime = System.currentTimeMillis();
			System.out.println(time + " - " + currentTime + " = " + (currentTime - time));
		}

		return true;
	}

	/**
	 * Example_Do_forMilliseconds_:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Do_forMilliseconds_() {
		long startTime = System.currentTimeMillis();
		JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
			public Object value() {
				for (int i = 0; i < 10; i++) {
					System.out.print(" d");
				}
				return null;
			}
		}, 1000);

		System.out.println("\n" + (System.currentTimeMillis() - startTime));

		return true;
	}

	/**
	 * Example_HoldForMilliseconds_untilDo_:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_HoldForMilliseconds_untilDo_() {
		long startTime = System.currentTimeMillis();

		JunControlUtility.HoldForMilliseconds_untilDo_(10000, new StBlockClosure() {
			public Object value() {
				System.out.print("u ");
				return Boolean.valueOf(JunSensorUtility.AnyButtonPressed());
			}
		});

		System.out.println("\n" + (System.currentTimeMillis() - startTime));

		return true;
	}

	/**
	 * Example_HoldForMilliseconds_whileDo_:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_HoldForMilliseconds_whileDo_() {
		long startTime = System.currentTimeMillis();

		JunControlUtility.HoldForMilliseconds_whileDo_(10000, new StBlockClosure() {
			public Object value() {
				System.out.print("w ");
				return Boolean.valueOf(JunSensorUtility.NoButtonPressed());
			}
		});

		System.out.println("\n" + (System.currentTimeMillis() - startTime));

		return true;
	}

	/**
	 * Example_WaitUntilTimeMillis_:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_WaitUntilTimeMillis_() {
		long startTime = System.currentTimeMillis();
		JunControlUtility.WaitUntilTimeMillis_(startTime + 1000);
		System.out.println(System.currentTimeMillis() - startTime);

		return true;
	}

	/**
	 * Test the sleep.
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test_Sleep() {
		int tick = 50;
		for (int i = 0; i < 10; i++) {
			System.out.println(System.currentTimeMillis());
			try {
				Thread.sleep(tick);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		System.out.println(System.currentTimeMillis());

		return true;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunControlUtilityTestExamples();
	}

}
