package jp.co.sra.jun.goodies.track;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunTrackerModelTestExamples class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/24 (by MATSUDA Ryouichi)
 *  @updated   2002/10/27 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2006/02/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTrackerModelTestExamples.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTrackerModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Example1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunTrackerModel tracker = new JunTrackerModel();
		tracker.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		tracker.open();

		return true;
	}

	/**
	 * Example2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunTrackerModel tracker = new JunTrackerModel();
		tracker.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		tracker.loop();
		tracker.open();

		return true;
	}

	/**
	 * Example3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunTrackerModel tracker = new JunTrackerModel();
		tracker.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		tracker.backAndForth();
		tracker.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunTrackerModelTestExamples();
	}
}
