package jp.co.sra.jun.goodies.track;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunTrackSliderModelTestExamples class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/19 (by MATSUDA Ryouichi)
 *  @updated   2002/10/28 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun475 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTrackSliderModelTestExamples.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTrackSliderModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Example1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunTrackSliderModel slider = new JunTrackSliderModel();
		slider.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		for (int i = 0; i <= 100; i++) {
			slider.value_(i / 100.0);
		}

		return true;
	}

	/**
	 * Example2: Open JunTrackSlider.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunTrackSliderModel slider = new JunTrackSliderModel();
		slider.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		slider.open();

		return true;
	}

	/**
	 * Example3: Open JunTrackSlider with markers.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunTrackSliderModel slider = new JunTrackSliderModel();
		slider.enableMarkers();
		slider.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		slider.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunTrackSliderModelTestExamples();
	}
}
