package jp.co.sra.jun.goodies.track;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunSimpleSliderModelTestExamples class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/27 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun475 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleSliderModelTestExamples.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunSimpleSliderModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunSimpleSliderModel slider = new JunSimpleSliderModel();
		slider.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		for (int i = 0; i <= 100; i++) {
			slider.value_(i / 100.0);
		}

		return true;
	}

	/**
	 * Example2: Open JunSimpleSlider.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunSimpleSliderModel slider = new JunSimpleSliderModel();
		slider.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		slider.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunSimpleSliderModelTestExamples();
	}
}
