package jp.co.sra.jun.goodies.track;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunSimpleSliderModel class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/27 (by Hoshi Takanori)
 *  @updated   2004/09/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleSliderModel.java,v 8.11 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunSimpleSliderModel extends JunApplicationModel implements StBlockValued {

	protected StValueHolder valueHolder;

	/**
	 * Create a new instance of <code>JunSimpleSliderModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSimpleSliderModel() {
		super();
	}

	/**
	 * Answer a BlockValue.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category constructing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return new StBlockValue(aBlock, this);
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunSimpleSliderViewAwt(this);
		} else {
			return new JunSimpleSliderViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Simple Slider");
	}

	/**
	 * Answer my value as double.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double doubleValue() {
		return ((Number) this.value()).doubleValue();
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" (");
		aWriter.write(String.valueOf(this.value()));
		aWriter.write(')');
	}

	/**
	 * Get the value of valueHolder.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category accessing
	 */
	public Object value() {
		return valueHolder.value();
	}

	/**
	 * Set the value of valueHolder.
	 * 
	 * @param normalizedNumber double
	 * @category accessing
	 */
	public void value_(double normalizedNumber) {
		valueHolder.value_(Math.max(0, Math.min(normalizedNumber, 1)));
		this.changed_($("value"));
	}

	/**
	 * Get the valueHolder with double value.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category accessing
	 */
	public StValueHolder valueHolder() {
		if (valueHolder == null) {
			valueHolder = new StValueHolder(0.0d);
		}
		return valueHolder;
	}

	/**
	 * Initialize the JunSimpleSliderModel.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		valueHolder = null;
		this.valueHolder();
	}

}
