package jp.co.sra.jun.goodies.tools;

import java.io.File;
import java.net.MalformedURLException;

import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunTextFileToHtmlFileTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/03/31 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextFileToHtmlFileTestExamples.java,v 8.12 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextFileToHtmlFileTestExamples extends JunTestExamples {

	/**
	 * Example1: Request a text file and convert it to an html file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunTextFileToHtmlFile aConverter = JunTextFileToHtmlFile.Request();
		if (aConverter == null) {
			return false;
		}

		aConverter.convert();

		try {
			JunURL.Browse_(aConverter.htmlFile().toURL());
		} catch (MalformedURLException e) {
			System.err.println(e.getMessage());
		}

		return true;
	}

	/**
	 * Example2: Request a directory and convert text files in it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		if (aDirectory == null) {
			return false;
		}

		File[] files = aDirectory.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (JunStringUtility.StringMatch_and_(files[i].getName().toLowerCase(), "*.txt")) {
				System.out.print(files[i]);

				JunTextFileToHtmlFile aConverter = new JunTextFileToHtmlFile(files[i]);
				aConverter.convert();

				System.out.println(" -> " + aConverter.htmlFile());
			}
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunTextFileToHtmlFileTestExamples();
	}

}
