package jp.co.sra.jun.goodies.texteditor;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunTextEditorDialogTestExamples class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorDialogTestExamples.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextEditorDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Request a value with JunTextEditorDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Object value = JunTextEditorDialog.Request();
		System.out.println(value);

		return true;
	}

	/**
	 * Example2: Request a value with JunTextEditorDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Object value = JunTextEditorDialog.Request(JunSystem.$String("Input a new <1p>.", null, JunSystem.$String("Text")));
		System.out.println(value);

		return true;
	}

	/**
	 * Example3: Request a value with JunTextEditorDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Object value = JunTextEditorDialog.Request(JunSystem.$String("Input a new <1p>.", null, JunSystem.$String("Text")), new JunTextEditor(JunSystem.FullName()), new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("\t" + ((JunTextEditor) model).text());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("\t" + ((JunTextEditor) model).text());
				return Boolean.TRUE;
			}
		});
		System.out.println(value);

		return true;
	}

	/**
	 * Example4: Request a value with JunTextEditorDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Object value = JunTextEditorDialog.Request(JunSystem.$String("Input a new <1p>.", null, JunSystem.$String("Text")), JunSystem.Copyright());
		System.out.println(value);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunTextEditorDialogTestExamples();
	}
}
