package jp.co.sra.jun.goodies.tables;

import java.util.Iterator;
import java.util.Map;

import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunAdjacencyTable class
 * 
 *  @author    nisinaka
 *  @created   2006/04/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun592 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAdjacencyTable.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunAdjacencyTable extends JunAttributeTable {

	/**
	 * Create a new instance of JunAdjacencyTable and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunAdjacencyTable() {
		super();
	}

	/**
	 * Create a new instance of JunAdjacencyTable and initialize it.
	 *
	 * @param size int
	 * @category Instance creation
	 */
	public JunAdjacencyTable(int size) {
		super(size);
	}

	/**
	 * Create a new instance of JunAdjacencyTable and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunAdjacencyTable(JunLispList aList) {
		super(aList);
	}

	/**
	 * Answer my bindings as adjacencies.
	 * 
	 * @return java.util.Map.Entry[]
	 * @category accessing
	 */
	public Map.Entry[] adjacencies() {
		return this.bindings();
	}

	/**
	 * Answer the attributes at the first object with the last object. 
	 * 
	 * @param first java.lang.Object
	 * @param last java.lang.Object
	 * @return jp.co.sra.goodies.tables.JunAttributeTable
	 * @category accessing
	 */
	public JunAttributeTable at_with_(Object first, Object last) {
		JunAttributeTable table = (JunAttributeTable) this.at_(first);
		if (table != null) {
			table = (JunAttributeTable) table.at_(last);
		}
		return table;
	}

	/**
	 * Put the attributes at the first object with the last object.
	 * 
	 * @param first java.lang.Object
	 * @param last java.lang.Object
	 * @param attributes jp.co.sra.goodies.tables.JunAttributeTable
	 * @category accessing
	 */
	public void at_with_put_(Object first, Object last, JunAttributeTable attributes) {
		JunReferenceTable table = (JunReferenceTable) this.at_(first);
		if (table != null) {
			if (attributes == null) {
				table.removeKey_(last);
			} else {
				table.at_put_(last, attributes);
			}
		}
	}

	/**
	 * Add the node to the receiver. 
	 * 
	 * @param node java.lang.Object
	 * @return jp.co.sra.jun.goodies.tables.JunReferenceTable
	 * @category adding
	 */
	public JunReferenceTable add_(Object node) {
		JunReferenceTable table = (JunReferenceTable) this.at_(node);
		if (table != null) {
			return null;
		} else {
			table = new JunReferenceTable();
			this.at_put_(node, table);
			return table;
		}
	}

	/**
	 * Remove the node from the receiver.
	 * 
	 * @param node java.lang.Object
	 * @return java.lang.Object
	 * @category removing
	 */
	public Object remove_(Object node) {
		Iterator iterator = this.entries().iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			JunAttributeTable table = (JunAttributeTable) entry.getValue();
			table.removeKey_(node);
		}
		return this.removeKey_(node);
	}

	/**
	 * Connect the first object with the last object. 
	 * 
	 * @param first java.lang.Object
	 * @param last java.lang.Object
	 * @param isUndirected boolean
	 * @return java.lang.Boolean
	 * @category connecting
	 */
	public Boolean connect_with_undirected_(Object first, Object last, boolean isUndirected) {
		Boolean triplet = null;

		this.add_(first);
		this.add_(last);
		if ((first == null) ? (last == null) : first.equals(last)) {
			triplet = null;
		} else {
			triplet = Boolean.FALSE;
			if (this.at_with_(first, last) == null) {
				this.at_with_put_(first, last, new JunAttributeTable());
				triplet = Boolean.TRUE;
			}
			if (isUndirected) {
				if (this.at_with_(last, first) == null) {
					this.at_with_put_(last, first, new JunAttributeTable());
					triplet = Boolean.TRUE;
				}
			}
		}

		return triplet;
	}

	/**
	 * Disconnect the first object with the last object. 
	 * 
	 * @param first java.lang.Object
	 * @param last java.lang.Object
	 * @param isUndirected boolean
	 * @return java.lang.Boolean
	 * @category connecting
	 */
	public Boolean disconnect_with_undirected_(Object first, Object last, boolean isUndirected) {
		Boolean triplet = null;

		if ((first == null) ? (last == null) : first.equals(last)) {
			triplet = null;
		} else {
			triplet = Boolean.FALSE;
			if (this.at_with_(first, last) != null) {
				this.at_with_put_(first, last, null);
				triplet = Boolean.TRUE;
			}
			if (isUndirected) {
				if (this.at_with_(last, first) != null) {
					this.at_with_put_(last, first, null);
					triplet = Boolean.TRUE;
				}
			}
		}

		return triplet;
	}

}
