package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSpiroPenTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/03/29 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroPenTestExamples.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroPenTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSpiroPen spiroPen = new JunSpiroPen();
		JunDisplayModel aModel = new JunDisplayModel(spiroPen);
		aModel.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunSpiroPen spiroPen = new JunSpiroPen(JunSpiroPenTestExamples.ExamplePoints());
		JunDisplayModel aModel = new JunDisplayModel(spiroPen);
		aModel.open();
		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunSpiroPen spiroPen = new JunSpiroPen(JunSpiroPenTestExamples.ExamplePoints(), Color.red, 3);
		JunDisplayModel aModel = new JunDisplayModel(spiroPen);
		aModel.open();
		return true;
	}

	/**
	 * Answer the example points.
	 * 
	 * @return java.uitl.Collection
	 * @category Examples
	 */
	public static Collection ExamplePoints() {
		ArrayList anArray = new ArrayList();
		ExamplePoints1_(anArray);
		ExamplePoints2_(anArray);
		ExamplePoints3_(anArray);
		ExamplePoints4_(anArray);
		ExamplePoints5_(anArray);
		Jun2dPoint[] points = (Jun2dPoint[]) anArray.toArray(new Jun2dPoint[anArray.size()]);
		anArray = new ArrayList();
		for (int i = 0; i < points.length; i++) {
			anArray.add(points[i].translatedBy_(new Jun2dPoint(150, 150)));
		}
		return anArray;
	}

	/**
	 * Add the example points to the specified array.
	 * 
	 * @param anArray java.util.Collection
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection ExamplePoints1_(Collection anArray) {
		anArray.add(new Jun2dPoint(30.0, 50.0));
		anArray.add(new Jun2dPoint(38.975347736373, 57.994040489287));
		anArray.add(new Jun2dPoint(47.751423827963, 64.234824554502));
		anArray.add(new Jun2dPoint(56.028813813016, 68.631274946959));
		anArray.add(new Jun2dPoint(63.512779859043, 71.149179972765));
		anArray.add(new Jun2dPoint(69.923048275449, 71.811119742297));
		anArray.add(new Jun2dPoint(75.003253062124, 70.694606375408));
		anArray.add(new Jun2dPoint(78.529727201128, 67.928510362593));
		anArray.add(new Jun2dPoint(80.319353089987, 63.687899800111));
		anArray.add(new Jun2dPoint(80.2362125487, 58.187469532048));
		anArray.add(new Jun2dPoint(78.196814288217, 51.673781735043));
		anArray.add(new Jun2dPoint(74.173721414441, 44.416576750463));
		anArray.add(new Jun2dPoint(68.197452033855, 36.699441816579));
		anArray.add(new Jun2dPoint(60.356580711995, 28.810144863895));
		anArray.add(new Jun2dPoint(50.796025665505, 21.030950095516));
		anArray.add(new Jun2dPoint(39.713564313926, 13.62923138723));
		anArray.add(new Jun2dPoint(27.354676328868, 6.8486886449545));
		anArray.add(new Jun2dPoint(14.005866784188, 0.90145151499701));
		anArray.add(new Jun2dPoint(-0.013329284014254, -4.0386750630729));
		anArray.add(new Jun2dPoint(-14.359417218207, -7.8416070639961));
		anArray.add(new Jun2dPoint(-28.674809597829, -10.42484798825));
		anArray.add(new Jun2dPoint(-42.598185341748, -11.755705045849));
		anArray.add(new Jun2dPoint(-55.775020529575, -11.851788452021));
		anArray.add(new Jun2dPoint(-67.867964330893, -10.779783829088));
		anArray.add(new Jun2dPoint(-78.566737713241, -8.6525444191015));
		anArray.add(new Jun2dPoint(-87.597247119187, -5.6246049414522));
		anArray.add(new Jun2dPoint(-94.729629602185, -1.8862706945621));
		anArray.add(new Jun2dPoint(-99.784979219508, 2.3435177742714));
		anArray.add(new Jun2dPoint(-102.64054573895, 6.8253039337323));
		anArray.add(new Jun2dPoint(-103.23324461071, 11.307945649898));
		anArray.add(new Jun2dPoint(-101.56137016058, 15.537860443576));
		anArray.add(new Jun2dPoint(-97.684460385472, 19.268375618004));
		anArray.add(new Jun2dPoint(-91.721319779023, 22.268869591087));
		anArray.add(new Jun2dPoint(-83.84626443162, 24.333397331613));
		anArray.add(new Jun2dPoint(-74.283709394034, 25.288509380169));
		anArray.add(new Jun2dPoint(-63.301270189222, 25.0));
		anArray.add(new Jun2dPoint(-51.201596750788, 23.378354711281));
		anArray.add(new Jun2dPoint(-38.313197482597, 20.382709695671));
		anArray.add(new Jun2dPoint(-24.980542319685, 16.023183954342));
		anArray.add(new Jun2dPoint(-11.55375563771, 10.361498100227));
		anArray.add(new Jun2dPoint(1.6217780862267, 3.5098495530754));
		anArray.add(new Jun2dPoint(14.215571189587, -4.3719291213453));
		anArray.add(new Jun2dPoint(25.921636208511, -13.080845770107));
		anArray.add(new Jun2dPoint(36.467238231156, -22.376721510449));
		anArray.add(new Jun2dPoint(45.620526770693, -31.989474955113));
		anArray.add(new Jun2dPoint(53.196814288217, -41.627488454179));
		anArray.add(new Jun2dPoint(59.063312424034, -50.986790900081));
		anArray.add(new Jun2dPoint(63.142186855995, -59.760764034869));
		anArray.add(new Jun2dPoint(65.411845889854, -67.650060987553));
		anArray.add(new Jun2dPoint(65.906434655913, -74.372417555028));
		anArray.add(new Jun2dPoint(64.713564313926, -79.672038801992));
		anArray.add(new Jun2dPoint(61.970362106874, -83.328255842207));
		anArray.add(new Jun2dPoint(57.857981643019, -85.163169795563));
		anArray.add(new Jun2dPoint(52.594761708603, -85.048031195774));
		anArray.add(new Jun2dPoint(46.428264654331, -82.90814256075));
		anArray.add(new Jun2dPoint(39.626460591392, -78.726118177472));
		anArray.add(new Jun2dPoint(32.468350155005, -72.543386918387));
		anArray.add(new Jun2dPoint(25.234335603126, -64.459879444638));
		anArray.add(new Jun2dPoint(18.196656979667, -54.631898687919));
		anArray.add(new Jun2dPoint(11.61020677392, -43.268230197108));
		anArray.add(new Jun2dPoint(5.7040230700351, -30.624604941452));
		anArray.add(new Jun2dPoint(0.67373804835824, -16.996679684969));
		anArray.add(new Jun2dPoint(-3.3247733680596, -2.711747403588));
		anArray.add(new Jun2dPoint(-6.1803398874989, 11.880569111592));
		anArray.add(new Jun2dPoint(-7.8298769601668, 26.418354640305));
		anArray.add(new Jun2dPoint(-8.2600999713542, 40.537860443576));
		anArray.add(new Jun2dPoint(-7.5075158983105, 53.88406139601));
		anArray.add(new Jun2dPoint(-5.6566984684629, 66.120984449918));
		anArray.add(new Jun2dPoint(-2.836908298919, 76.94148832423));
		anArray.add(new Jun2dPoint(0.78282610271922, 86.076191252706));
		anArray.add(new Jun2dPoint(5.0, 93.301270189222));
		anArray.add(new Jun2dPoint(9.5860851217492, 98.444890208034));
		anArray.add(new Jun2dPoint(14.29489351002, 101.39206582837));
		anArray.add(new Jun2dPoint(18.871572539146, 102.0878052649));
		anArray.add(new Jun2dPoint(23.061930140296, 100.53844258739));
		anArray.add(new Jun2dPoint(26.621778086227, 96.811119742297));
		anArray.add(new Jun2dPoint(29.325980179994, 91.031438529198));
		anArray.add(new Jun2dPoint(30.976901386371, 83.379360081341));
		anArray.add(new Jun2dPoint(31.411973053296, 74.083484340999));
		anArray.add(new Jun2dPoint(30.510117780286, 63.413892695431));
		anArray.add(new Jun2dPoint(28.196814288217, 51.673781735043));
		anArray.add(new Jun2dPoint(24.447626646027, 39.19015358708));
		anArray.add(new Jun2dPoint(19.290071997164, 26.303857275691));
		anArray.add(new Jun2dPoint(12.803754897237, 13.359295145148));
		anArray.add(new Jun2dPoint(5.1187527833753, 0.69411794172578));
		anArray.add(new Jun2dPoint(-3.5877058752956, -11.37076861277));
		anArray.add(new Jun2dPoint(-13.096173389879, -22.540573969669));
		anArray.add(new Jun2dPoint(-23.151374489681, -32.555078802946));
		anArray.add(new Jun2dPoint(-33.469859601957, -41.195916336943));
		anArray.add(new Jun2dPoint(-43.74867983283, -48.292456782743));
		anArray.add(new Jun2dPoint(-53.674809597829, -53.726118177472));
		anArray.add(new Jun2dPoint(-62.935017495538, -57.43297792798));
		anArray.add(new Jun2dPoint(-71.225870248323, -59.404614266779));
		anArray.add(new Jun2dPoint(-78.263548871781, -59.687163865779));
		anArray.add(new Jun2dPoint(-83.793160876624, -58.378639187515));
		anArray.add(new Jun2dPoint(-87.597247119187, -55.624604941452));
		anArray.add(new Jun2dPoint(-89.503206438803, -51.612365462976));
		anArray.add(new Jun2dPoint(-89.38939467862, -46.563862262419));
		anArray.add(new Jun2dPoint(-87.1896960202, -40.727521881025));
		anArray.add(new Jun2dPoint(-82.896412456921, -34.369327232232));
		return anArray;
	}

	/**
	 * Add the example points to the specified array.
	 * 
	 * @param anArray java.util.Collection
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection ExamplePoints2_(Collection anArray) {
		anArray.add(new Jun2dPoint(-76.561370160576, -27.763409745646));
		anArray.add(new Jun2dPoint(-68.295197770848, -21.182474100744));
		anArray.add(new Jun2dPoint(-58.26478946108, -14.888371682783));
		anArray.add(new Jun2dPoint(-46.68902315775, -9.1231329863303));
		anArray.add(new Jun2dPoint(-33.832859675287, -4.100753234455));
		anArray.add(new Jun2dPoint(-20.0, -1.4210854715202E-14));
		anArray.add(new Jun2dPoint(-5.5243238686581, 3.0415225574905));
		anArray.add(new Jun2dPoint(9.2396283321601, 4.9318599769234));
		anArray.add(new Jun2dPoint(23.926837717005, 5.6275994134537));
		anArray.add(new Jun2dPoint(38.172339130703, 5.1350749368448));
		anArray.add(new Jun2dPoint(51.621778086227, 3.5098495530753));
		anArray.add(new Jun2dPoint(63.941665958, 0.85449404203745));
		anArray.add(new Jun2dPoint(74.829016245202, -2.6852612292192));
		anArray.add(new Jun2dPoint(84.020064045913, -6.9258717917014));
		anArray.add(new Jun2dPoint(91.297799652823, -11.652642801323));
		anArray.add(new Jun2dPoint(96.498084477439, -16.627488454179));
		anArray.add(new Jun2dPoint(99.514162142781, -21.597528285457));
		anArray.add(new Jun2dPoint(100.29942812986, -26.304233716926));
		anArray.add(new Jun2dPoint(98.868376207797, -30.492819713683));
		anArray.add(new Jun2dPoint(95.295697270536, -33.921567836281));
		anArray.add(new Jun2dPoint(89.713564313926, -36.37076861277));
		anArray.add(new Jun2dPoint(82.307194260665, -37.650982960076));
		anArray.add(new Jun2dPoint(73.308831361767, -37.610343980805));
		anArray.add(new Jun2dPoint(62.990346249491, -36.140651159083));
		anArray.add(new Jun2dPoint(51.654687817713, -33.182047792336));
		anArray.add(new Jun2dPoint(39.626460591393, -28.726118177472));
		anArray.add(new Jun2dPoint(27.241926991623, -22.817292149973));
		anArray.add(new Jun2dPoint(14.838751062237, -15.552499407948));
		anArray.add(new Jun2dPoint(2.7458072609198, -7.0790728731615));
		anArray.add(new Jun2dPoint(-8.7266253798703, 2.4090426850221));
		anArray.add(new Jun2dPoint(-19.295976929965, 12.67666524777));
		anArray.add(new Jun2dPoint(-28.715524566265, 23.454170033778));
		anArray.add(new Jun2dPoint(-36.781303686002, 34.445493870282));
		anArray.add(new Jun2dPoint(-43.337581161369, 45.337099429535));
		anArray.add(new Jun2dPoint(-48.280726678914, 55.807617254929));
		anArray.add(new Jun2dPoint(-51.561370160576, 65.537860443576));
		anArray.add(new Jun2dPoint(-53.184788780441, 74.2208935498));
		anArray.add(new Jun2dPoint(-53.209524283221, 81.571834168665));
		anArray.add(new Jun2dPoint(-51.744288335609, 87.337072865118));
		anArray.add(new Jun2dPoint(-48.943268665695, 91.302614416089));
		anArray.add(new Jun2dPoint(-45.0, 93.301270189222));
		anArray.add(new Jun2dPoint(-40.140009646664, 93.218467044652));
		anArray.add(new Jun2dPoint(-34.612486526671, 90.996481287483));
		anArray.add(new Jun2dPoint(-28.681253275612, 86.636955546154));
		anArray.add(new Jun2dPoint(-22.615342741834, 80.201610433598));
		anArray.add(new Jun2dPoint(-16.679492102995, 71.811119742297));
		anArray.add(new Jun2dPoint(-11.124869538753, 61.642175914575));
		anArray.add(new Jun2dPoint(-6.180339887499, 49.922829763398));
		anArray.add(new Jun2dPoint(-2.0445572646467, 36.926243067129));
		anArray.add(new Jun2dPoint(1.1208551656623, 22.963042976683));
		anArray.add(new Jun2dPoint(3.1968142882174, 8.372511545821));
		anArray.add(new Jun2dPoint(4.1107944922373, -6.4871192950498));
		anArray.add(new Jun2dPoint(3.8392222784169, -21.248968539067));
		anArray.add(new Jun2dPoint(2.4081703563493, -35.548084891543));
		anArray.add(new Jun2dPoint(-0.10767038000745, -49.031976826688));
		anArray.add(new Jun2dPoint(-3.5877058752956, -61.37076861277));
		anArray.add(new Jun2dPoint(-7.8697502264965, -72.266668738083));
		anArray.add(new Jun2dPoint(-12.755789948793, -81.462458839636));
		anArray.add(new Jun2dPoint(-18.01900988321, -88.7487421517));
		anArray.add(new Jun2dPoint(-23.41184767904, -93.969729664874));
		anArray.add(new Jun2dPoint(-28.674809597829, -97.027388366694));
		anArray.add(new Jun2dPoint(-33.545754880915, -97.883827646727));
		anArray.add(new Jun2dPoint(-37.76933993038, -96.561855540649));
		anArray.add(new Jun2dPoint(-41.106307597911, -93.143694183721));
		anArray.add(new Jun2dPoint(-43.342311157877, -87.767901802139));
		anArray.add(new Jun2dPoint(-44.295976929965, -80.624604941452));
		anArray.add(new Jun2dPoint(-43.825933556673, -71.949197616766));
		anArray.add(new Jun2dPoint(-41.836568863862, -62.014711981166));
		anArray.add(new Jun2dPoint(-38.282315983509, -51.123106421913));
		anArray.add(new Jun2dPoint(-33.170317688507, -39.595750395615));
		anArray.add(new Jun2dPoint(-26.561370160576, -27.763409745646));
		anArray.add(new Jun2dPoint(-18.569103002434, -15.956050937361));
		anArray.add(new Jun2dPoint(-9.3574094243898, -4.4927871418946));
		anArray.add(new Jun2dPoint(0.86380265700774, 6.327716732417));
		anArray.add(new Jun2dPoint(11.844413206843, 16.236078919335));
		anArray.add(new Jun2dPoint(23.301270189222, 25.0));
		anArray.add(new Jun2dPoint(34.926525850089, 32.430785172114));
		anArray.add(new Jun2dPoint(46.39686960603, 38.388390294866));
		anArray.add(new Jun2dPoint(57.383368034948, 42.784840687323));
		anArray.add(new Jun2dPoint(67.561601745327, 45.585924655592));
		anArray.add(new Jun2dPoint(76.621778086227, 46.811119742297));
		anArray.add(new Jun2dPoint(84.278498111791, 46.531766924167));
		anArray.add(new Jun2dPoint(90.279865963949, 44.867564585538));
		anArray.add(new Jun2dPoint(94.415648586801, 41.981508244989));
		anArray.add(new Jun2dPoint(96.524222816206, 38.073451967091));
		anArray.add(new Jun2dPoint(96.498084477439, 33.372511545821));
		anArray.add(new Jun2dPoint(94.287738979398, 28.128566482957));
		anArray.add(new Jun2dPoint(89.903843588977, 22.603146319764));
		anArray.add(new Jun2dPoint(83.41752648905, 17.060006101074));
		anArray.add(new Jun2dPoint(74.958865116746, 11.75570504585));
		anArray.add(new Jun2dPoint(64.713564313926, 6.9305015764522));
		anArray.add(new Jun2dPoint(52.917931646041, 2.7998667586709));
		anArray.add(new Jun2dPoint(39.852301043824, -0.45310270693558));
		anArray.add(new Jun2dPoint(25.833104975621, -2.6841208411403));
		anArray.add(new Jun2dPoint(11.203838098966, -3.7927851777125));
		anArray.add(new Jun2dPoint(-3.6748095978295, -3.7261181774721));
		anArray.add(new Jun2dPoint(-18.435345890507, -2.4804599961832));
		anArray.add(new Jun2dPoint(-32.71407475252, -0.10164968920079));
		anArray.add(new Jun2dPoint(-46.16157277577, 3.3165116677265));
		anArray.add(new Jun2dPoint(-58.452720148284, 7.6354658484048));
		return anArray;
	}

	/**
	 * Add the example points to the specified array.
	 * 
	 * @param anArray java.util.Collection
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection ExamplePoints3_(Collection anArray) {
		anArray.add(new Jun2dPoint(-69.295976929965, 12.676665247769));
		anArray.add(new Jun2dPoint(-78.441619334679, 18.227746870395));
		anArray.add(new Jun2dPoint(-85.688683722693, 24.049909329394));
		anArray.add(new Jun2dPoint(-90.890406976126, 29.886249710787));
		anArray.add(new Jun2dPoint(-93.957999561044, 35.470785101139));
		anArray.add(new Jun2dPoint(-94.862640349798, 40.537860443576));
		anArray.add(new Jun2dPoint(-93.635638499188, 44.831630935176));
		anArray.add(new Jun2dPoint(-90.366765557091, 48.115303850722));
		anArray.add(new Jun2dPoint(-85.200818653552, 50.179831591248));
		anArray.add(new Jun2dPoint(-78.332531280318, 50.851764697341));
		anArray.add(new Jun2dPoint(-70.0, 50.0));
		anArray.add(new Jun2dPoint(-60.476841800455, 47.541194162522));
		anArray.add(new Jun2dPoint(-50.063336245418, 43.443655472726));
		anArray.add(new Jun2dPoint(-39.0768378165, 37.729575509464));
		anArray.add(new Jun2dPoint(-27.841765905217, 30.475515665185));
		anArray.add(new Jun2dPoint(-16.679492102996, 21.811119742298));
		anArray.add(new Jun2dPoint(-5.8984463753705, 11.916081146161));
		anArray.add(new Jun2dPoint(4.215244653389, 1.0154497267076));
		anArray.add(new Jun2dPoint(13.406292454101, -10.626582747628));
		anArray.add(new Jun2dPoint(21.457687319452, -22.714229905447));
		anArray.add(new Jun2dPoint(28.196814288217, -34.928758643401));
		anArray.add(new Jun2dPoint(33.500057106861, -46.937969013797));
		anArray.add(new Jun2dPoint(37.29575259636, -58.406209812936));
		anArray.add(new Jun2dPoint(39.565411630219, -69.004615209486));
		anArray.add(new Jun2dPoint(40.34317933874, -78.421239441311));
		anArray.add(new Jun2dPoint(39.713564313926, -86.37076861277));
		anArray.add(new Jun2dPoint(37.807522655633, -92.603500891873));
		anArray.add(new Jun2dPoint(34.797035865964, -96.913308558384));
		anArray.add(new Jun2dPoint(30.888370153481, -99.144326692588));
		anArray.add(new Jun2dPoint(26.314247089374, -99.196152828256));
		anArray.add(new Jun2dPoint(21.325190402171, -97.027388366694));
		anArray.add(new Jun2dPoint(16.180339887499, -92.657404483344));
		anArray.add(new Jun2dPoint(11.138040106311, -86.166270999761));
		anArray.add(new Jun2dPoint(6.4465182168467, -77.692844464974));
		anArray.add(new Jun2dPoint(2.3349617242533, -67.431069648349));
		anArray.add(new Jun2dPoint(-0.9947067407427, -55.624604941453));
		anArray.add(new Jun2dPoint(-3.3750838379252, -42.559935002142));
		anArray.add(new Jun2dPoint(-4.6793275899921, -28.558181663223));
		anArray.add(new Jun2dPoint(-4.8257856655664, -13.965865148044));
		anArray.add(new Jun2dPoint(-3.7810550738832, 0.85509932313233));
		anArray.add(new Jun2dPoint(-1.5613701605762, 15.537860443576));
		anArray.add(new Jun2dPoint(1.7677291513558, 29.721221944769));
		anArray.add(new Jun2dPoint(6.0934402943574, 43.060038672863));
		anArray.add(new Jun2dPoint(11.259387197895, 55.235096769107));
		anArray.add(new Jun2dPoint(17.070836370226, 65.962173687749));
		anArray.add(new Jun2dPoint(23.301270189222, 75.0));
		anArray.add(new Jun2dPoint(29.700102686707, 82.156879940528));
		anArray.add(new Jun2dPoint(36.001285065142, 87.295770331557));
		anArray.add(new Jun2dPoint(41.932518316201, 90.337666502081));
		anArray.add(new Jun2dPoint(47.224769591537, 91.263197537722));
		anArray.add(new Jun2dPoint(51.621778086226, 90.112389931519));
		anArray.add(new Jun2dPoint(54.889235497167, 86.982616642915));
		anArray.add(new Jun2dPoint(56.823335646006, 82.024805859408));
		anArray.add(new Jun2dPoint(57.258407312932, 75.438038562932));
		anArray.add(new Jun2dPoint(56.073373097459, 67.462714581714));
		anArray.add(new Jun2dPoint(53.196814288217, 58.372511545821));
		anArray.add(new Jun2dPoint(48.610466097268, 48.465398636747));
		anArray.add(new Jun2dPoint(42.351017774219, 38.053996038512));
		anArray.add(new Jun2dPoint(34.51014645236, 27.455590641962));
		anArray.add(new Jun2dPoint(25.232770348333, 16.982128209232));
		anArray.add(new Jun2dPoint(14.713564313926, 6.9305015764522));
		anArray.add(new Jun2dPoint(3.1918368776272, -2.4265564047117));
		anArray.add(new Jun2dPoint(-9.0550789928664, -10.848687247824));
		anArray.add(new Jun2dPoint(-21.719720839136, -18.134970559888));
		anArray.add(new Jun2dPoint(-34.473434783164, -24.129617331502));
		anArray.add(new Jun2dPoint(-46.976079787051, -28.726118177472));
		anArray.add(new Jun2dPoint(-58.886195609255, -31.869722610807));
		anArray.add(new Jun2dPoint(-69.87131602639, -33.558180007144));
		anArray.add(new Jun2dPoint(-79.618103093713, -33.840729606143));
		anArray.add(new Jun2dPoint(-87.841982762908, -32.815383870343));
		anArray.add(new Jun2dPoint(-94.295976929965, -30.624604941452));
		anArray.add(new Jun2dPoint(-98.778451488469, -27.449526011735));
		anArray.add(new Jun2dPoint(-101.13953344144, -23.502916485364));
		anArray.add(new Jun2dPoint(-101.28599151701, -19.021130325903));
		anArray.add(new Jun2dPoint(-99.184422724427, -14.255309667275));
		anArray.add(new Jun2dPoint(-94.862640349798, -9.4621395564239));
		anArray.add(new Jun2dPoint(-88.409215335805, -4.8944638332374));
		anArray.add(new Jun2dPoint(-79.971181016202, -0.79207618596779));
		anArray.add(new Jun2dPoint(-69.749968934805, 2.62700577649));
		anArray.add(new Jun2dPoint(-57.995699126528, 5.1744918152113));
		anArray.add(new Jun2dPoint(-45.0, 6.698729810778));
		anArray.add(new Jun2dPoint(-31.087579185831, 7.0903444437742));
		anArray.add(new Jun2dPoint(-16.606805927475, 6.2864141988561));
		anArray.add(new Jun2dPoint(-1.9195965426301, 4.2730451915212));
		anArray.add(new Jun2dPoint(12.609083813531, 1.0862530505612));
		anArray.add(new Jun2dPoint(26.621778086226, -3.1888802577025));
		anArray.add(new Jun2dPoint(39.778826506759, -8.4207510076287));
		anArray.add(new Jun2dPoint(51.768070468147, -14.43539999204));
		anArray.add(new Jun2dPoint(62.313672490791, -21.022167288516));
		anArray.add(new Jun2dPoint(71.183782087866, -27.940653068829));
		anArray.add(new Jun2dPoint(78.196814288217, -34.928758643401));
		anArray.add(new Jun2dPoint(83.226151875275, -41.711545850414));
		anArray.add(new Jun2dPoint(86.20313263305, -48.010625272048));
		anArray.add(new Jun2dPoint(87.118237444977, -53.553765490738));
		anArray.add(new Jun2dPoint(86.02045222087, -58.084407287522));
		anArray.add(new Jun2dPoint(83.014834503148, -61.37076861277));
		anArray.add(new Jun2dPoint(78.258372374381, -63.214238277249));
		anArray.add(new Jun2dPoint(71.954277139834, -63.456778240441));
		anArray.add(new Jun2dPoint(64.344900471424, -61.987085418719));
		anArray.add(new Jun2dPoint(55.703509703997, -58.745303109509));
		return anArray;
	}

	/**
	 * Add the example points to the specified array.
	 * 
	 * @param anArray java.util.Collection
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection ExamplePoints4_(Collection anArray) {
		anArray.add(new Jun2dPoint(46.325190402171, -53.726118177472));
		anArray.add(new Jun2dPoint(36.517172041289, -46.980131601214));
		anArray.add(new Jun2dPoint(26.588889825058, -38.613445185003));
		anArray.add(new Jun2dPoint(16.842102757735, -28.785464428284));
		anArray.add(new Jun2dPoint(7.561384887636, -17.704974879935));
		anArray.add(new Jun2dPoint(-0.99470674074285, -5.6246049414524));
		anArray.add(new Jun2dPoint(-8.6015070013079, 7.1661597662713));
		anArray.add(new Jun2dPoint(-15.07491213088, 20.349198373467));
		anArray.add(new Jun2dPoint(-20.276635384314, 33.586960666714));
		anArray.add(new Jun2dPoint(-24.117887227673, 46.532372205262));
		anArray.add(new Jun2dPoint(-26.561370160576, 58.839130632798));
		anArray.add(new Jun2dPoint(-27.621533463268, 70.172071663516));
		anArray.add(new Jun2dPoint(-27.363090023585, 80.217279946733));
		anArray.add(new Jun2dPoint(-25.897854075974, 88.69162708705));
		anArray.add(new Jun2dPoint(-23.380013348522, 95.351436302372));
		anArray.add(new Jun2dPoint(-20.0, 100.0));
		anArray.add(new Jun2dPoint(-15.977170195424, 102.49371209432));
		anArray.add(new Jun2dPoint(-11.551540749616, 102.7466200503));
		anArray.add(new Jun2dPoint(-6.9748617204896, 100.73325104297));
		anArray.add(new Jun2dPoint(-2.5013251768768, 96.489620701105));
		anArray.add(new Jun2dPoint(1.6217780862265, 90.11238993152));
		anArray.add(new Jun2dPoint(5.163140728753, 81.756193479532));
		anArray.add(new Jun2dPoint(7.9159556093158, 71.62922131852));
		anArray.add(new Jun2dPoint(9.7055814981739, 59.987188844185));
		anArray.add(new Jun2dPoint(10.396100215329, 47.125882427924));
		anArray.add(new Jun2dPoint(9.8955440989955, 33.372511545821));
		anArray.add(new Jun2dPoint(8.159616378521, 19.076136022123));
		anArray.add(new Jun2dPoint(5.1937765003496, 4.5974657205688));
		anArray.add(new Jun2dPoint(1.0536161344168, -9.701650631907));
		anArray.add(new Jun2dPoint(-4.156492266291, -23.468721509515));
		anArray.add(new Jun2dPoint(-10.286435686074, -36.37076861277));
		anArray.add(new Jun2dPoint(-17.144995276163, -48.103829286842));
		anArray.add(new Jun2dPoint(-24.505928711614, -58.401513062581));
		anArray.add(new Jun2dPoint(-32.115305380024, -67.042350596578));
		anArray.add(new Jun2dPoint(-39.699857946546, -73.855712099916));
		anArray.add(new Jun2dPoint(-46.976079787051, -78.726118177472));
		anArray.add(new Jun2dPoint(-53.659772445872, -81.59581737922));
		anArray.add(new Jun2dPoint(-59.475731485502, -82.465560043834));
		anArray.add(new Jun2dPoint(-64.167253374966, -81.393555420901));
		anArray.add(new Jun2dPoint(-67.505150609118, -78.492656752473));
		anArray.add(new Jun2dPoint(-69.295976929965, -73.925875130674));
		anArray.add(new Jun2dPoint(-69.389188873845, -67.900375730483));
		anArray.add(new Jun2dPoint(-67.683003123497, -60.660157759234));
		anArray.add(new Jun2dPoint(-64.128750243144, -52.477660643846));
		anArray.add(new Jun2dPoint(-58.73357300568, -43.644572281899));
		anArray.add(new Jun2dPoint(-51.561370160576, -34.462139556424));
		anArray.add(new Jun2dPoint(-42.731942453675, -25.231295987028));
		anArray.add(new Jun2dPoint(-32.418355201445, -16.242925904715));
		anArray.add(new Jun2dPoint(-20.842588898115, -7.768578764398));
		anArray.add(new Jun2dPoint(-8.2696043581149, -0.051931348171578));
		anArray.add(new Jun2dPoint(4.9999999999999, 6.698729810778));
		anArray.add(new Jun2dPoint(18.638515582583, 12.316767607157));
		anArray.add(new Jun2dPoint(32.300574109215, 16.681998739744));
		anArray.add(new Jun2dPoint(45.633229272128, 19.723894910269));
		anArray.add(new Jun2dPoint(58.286356695661, 21.423085204351));
		anArray.add(new Jun2dPoint(69.923048275448, 21.811119742298));
		anArray.add(new Jun2dPoint(80.229676225506, 20.968511606995));
		anArray.add(new Jun2dPoint(88.925311742017, 19.021130325903));
		anArray.add(new Jun2dPoint(95.770202808734, 16.135073985353));
		anArray.add(new Jun2dPoint(100.57304470249, 12.510196649918));
		anArray.add(new Jun2dPoint(103.19681428822, 8.3725115458208));
		anArray.add(new Jun2dPoint(103.56298402906, 3.965727031716));
		anArray.add(new Jun2dPoint(101.6539823518, -0.45779945729099));
		anArray.add(new Jun2dPoint(97.513821985865, -4.6463854540475));
		anArray.add(new Jun2dPoint(91.246875384253, -8.3583125191077));
		anArray.add(new Jun2dPoint(83.014834503148, -11.37076861277));
		anArray.add(new Jun2dPoint(73.031949210998, -13.488143508835));
		anArray.add(new Jun2dPoint(61.558692598947, -14.54939820375));
		anArray.add(new Jun2dPoint(48.894050752676, -14.434259603961));
		anArray.add(new Jun2dPoint(35.366677550208, -13.068030227379));
		anArray.add(new Jun2dPoint(21.325190402171, -10.42484798825));
		anArray.add(new Jun2dPoint(7.1279094266652, -6.5292818824668));
		anArray.add(new Jun2dPoint(-6.8676404928847, -1.4562039111335));
		anArray.add(new Jun2dPoint(-20.315138516135, 4.6710658896588));
		anArray.add(new Jun2dPoint(-32.889464831111, 11.684287734688));
		anArray.add(new Jun2dPoint(-44.295976929965, 19.375395058547));
		anArray.add(new Jun2dPoint(-54.278779883438, 27.502991920062));
		anArray.add(new Jun2dPoint(-62.627737945638, 35.800048092214));
		anArray.add(new Jun2dPoint(-69.184015421004, 43.982545207602));
		anArray.add(new Jun2dPoint(-73.843981996087, 51.758795368645));
		anArray.add(new Jun2dPoint(-76.561370160576, 58.839130632798));
		anArray.add(new Jun2dPoint(-77.347628231682, 64.945648500133));
		anArray.add(new Jun2dPoint(-76.270470060276, 69.821695405845));
		anArray.add(new Jun2dPoint(-73.450679890732, 73.240777368303));
		anArray.add(new Jun2dPoint(-69.057286230652, 75.014604148582));
		anArray.add(new Jun2dPoint(-63.301270189222, 75.0));
		anArray.add(new Jun2dPoint(-56.428019914171, 73.104449479694));
		anArray.add(new Jun2dPoint(-48.708782023486, 69.290089732361));
		anArray.add(new Jun2dPoint(-40.431392038432, 63.576009769099));
		anArray.add(new Jun2dPoint(-31.890587791501, 56.038770982358));
		anArray.add(new Jun2dPoint(-23.378221913773, 46.811119742297));
		anArray.add(new Jun2dPoint(-15.173691425037, 36.078920597402));
		anArray.add(new Jun2dPoint(-7.5348941094317, 24.076395503763));
		anArray.add(new Jun2dPoint(-0.69000304271399, 11.079808807494));
		anArray.add(new Jun2dPoint(5.1696770519459, -2.6002123404892));
		anArray.add(new Jun2dPoint(9.8955440989954, -16.627488454179));
		anArray.add(new Jun2dPoint(13.386039541904, -30.649958746291));
		anArray.add(new Jun2dPoint(15.589361041238, -44.309914316121));
		anArray.add(new Jun2dPoint(16.504465853164, -57.254476446665));
		anArray.add(new Jun2dPoint(16.180339887499, -69.145994391645));
		return anArray;
	}

	/**
	 * Add the example points to the specified array.
	 * 
	 * @param anArray java.util.Collection
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection ExamplePoints5_(Collection anArray) {
		anArray.add(new Jun2dPoint(14.713564313927, -79.672038801991));
		anArray.add(new Jun2dPoint(12.244267338461, -88.554679005589));
		anArray.add(new Jun2dPoint(8.95060160633, -95.558754336451));
		anArray.add(new Jun2dPoint(5.0419358938458, -100.49888091452));
		anArray.add(new Jun2dPoint(0.75099177220059, -103.24497471454));
		anArray.add(new Jun2dPoint(-3.6748095978292, -103.72611817747));
		anArray.add(new Jun2dPoint(-7.982499563742, -101.93264953301));
		anArray.add(new Jun2dPoint(-11.922905670744, -97.916409762582));
		anArray.add(new Jun2dPoint(-15.259873338276, -91.789139961789));
		anArray.add(new Jun2dPoint(-17.779055840704, -83.719079915856));
		anArray.add(new Jun2dPoint(-19.295976929965, -73.925875130674));
		anArray.add(new Jun2dPoint(-19.663094105432, -62.673952567099));
		anArray.add(new Jun2dPoint(-18.775623086807, -50.264573218346));
		anArray.add(new Jun2dPoint(-16.575924428387, -37.026810925098));
		anArray.add(new Jun2dPoint(-13.05630012355, -23.307740128109));
		anArray.add(new Jun2dPoint(-8.2600999713543, -9.4621395564243));
		anArray.add(new Jun2dPoint(-2.2810927349283, 4.1579666275953));
		anArray.add(new Jun2dPoint(4.7388860724247, 17.213604413227));
		anArray.add(new Jun2dPoint(12.613941419828, 29.388662509472));
		anArray.add(new Jun2dPoint(21.119658256509, 40.398918370576));
		anArray.add(new Jun2dPoint(30.0, 50.0));
		anArray.add(new Jun2dPoint(38.975347736372, 57.994040489287));
		anArray.add(new Jun2dPoint(47.751423827963, 64.234824554502));
		return anArray;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSpiroPenTestExamples();
	}
}
