package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;

/**
 * JunSpiroDesignViewAwt class
 * 
 *  @author    m-asada
 *  @created   2006/04/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignViewAwt.java,v 8.11 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesignViewAwt extends JunAbstractViewCanvas implements JunSpiroDesignView {
	protected Point scrollAmount;

	protected transient Image offScreenImage;
	protected transient Dimension offScreenSize;

	/**
	 * Create a new instance of <code>JunSpiroDesignViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSpiroDesignViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSpiroDesignViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel
	 * @category Instance creation
	 */
	public JunSpiroDesignViewAwt(JunSpiroDesignAbstractModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		scrollAmount = null;
		offScreenImage = null;
		offScreenSize = null;
	}

	/**
	 * Initialize the receiver's off screen image.
	 * 
	 * @category initialize-release
	 */
	protected void initializeOffScreen() {
		if (offScreenImage == null) {
			return;
		}

		Graphics2D aGraphics = (Graphics2D) offScreenImage.getGraphics().create();
		try {
			aGraphics.setColor(this.getBackground());
			aGraphics.setClip(0, 0, offScreenSize.width, offScreenSize.height);
			aGraphics.fillRect(0, 0, offScreenSize.width, offScreenSize.height);
			this.displayOn_(aGraphics);
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setBackground(Color.white);
		this.setSize(new Dimension(480, 480));
	}

	/**
	 * Answer my default controller. Subclasses may override this.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunSpiroDesignController();
	}

	/**
	 * Answer my default controller as JunSpiroDesignController.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignController
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#getSpiroDesignController()
	 * @category controller accessing
	 */
	public JunSpiroDesignController getSpiroDesignController() {
		return (JunSpiroDesignController) this.controller();
	}

	/**
	 * Convert model point to view point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#convertModelPointToViewPoint_(java.awt.Point)
	 * @category converting
	 */
	public Point convertModelPointToViewPoint_(Point aPoint) {
		return new Point(aPoint.x + this.scrollAmount().x, aPoint.y + this.scrollAmount().y);
	}

	/**
	 * Convert view point to model point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#convertModelPointToViewPoint_(java.awt.Point)
	 * @category converting
	 */
	public Point convertViewPointToModelPoint_(Point aPoint) {
		return new Point(aPoint.x - this.scrollAmount().x, aPoint.y - this.scrollAmount().y);
	}

	/**
	 * Display the receiver on the graphics.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics graphicsContext) {
		Image anImage = this.offScreen();
		if (anImage != null) {
			Graphics2D offScreenGraphics = (Graphics2D) anImage.getGraphics();
			try {
				Rectangle clipBounds = graphicsContext.getClipBounds();
				if (clipBounds != null) {
					offScreenGraphics.setBackground(this.getBackground());
					offScreenGraphics.setClip(clipBounds);
					offScreenGraphics.clearRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
				}
				this.displayOn_at_(offScreenGraphics, new Point(0, 0));
			} finally {
				if (offScreenGraphics != null) {
					offScreenGraphics.dispose();
					offScreenGraphics = null;
				}
			}
			graphicsContext.drawImage(anImage,0,0, this);
		} else {
			this.displayOn_at_(graphicsContext, new Point(0, 0));
		}
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param aPoint java.awt.Point
	 * @category displaying
	 */
	public void displayOn_at_(Graphics graphicsContext, Point aPoint) {
		this.getModel().displayOn_at_(graphicsContext, new Point(aPoint.x + this.scrollAmount().x, aPoint.y + this.scrollAmount().y));
	}

	/**
	 * Repaints the specified rectangle of this component within <code>tm</code> milliseconds.
	 * 
	 * @param tm long
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 * @see java.awt.Component#repaint(long, int, int, int, int)
	 * @category displaying
	 */
	public void repaint(long tm, int x, int y, int width, int height) {
		if (this.isShowing()) {
			Graphics aGraphics = this.getGraphics();
			try {
				aGraphics.setClip(x, y, width, height);
				this.displayOn_(aGraphics);
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
					aGraphics = null;
				}
			}
		}
	}

	/**
	 * Create the off screen image.
	 * 
	 * @return java.awt.Image
	 * @see jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView#createOffScreen()
	 * @category displaying
	 */
	public Image createOffScreen() {
		this.initializeOffScreen();
		return this.offScreen();
	}

	/**
	 * Answer the off screen image.
	 * 
	 * @return java.awt.Image
	 * @see jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView#offScreen()
	 * @category displaying
	 */
	public Image offScreen() {
		Dimension viewSize = this.getSize();
		if (viewSize.equals(offScreenSize) == false || offScreenImage == null) {
			offScreenImage = this.createImage(viewSize.width, viewSize.height);
			offScreenSize = viewSize;
			this.initializeOffScreen();
		}
		return offScreenImage;
	}

	/**
	 * Answer the receiver's model as JunSpiroDesignAbstractModel.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#getModel()
	 * @category model accessing
	 */
	public JunSpiroDesignAbstractModel getModel() {
		return (JunSpiroDesignAbstractModel) this.model();
	}

	/**
	 * Show the popup menu at the specified point on the view.
	 *
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.smalltalk.StView#_showPopupMenu(int, int)
	 * @category popup menu
	 */
	public void _showPopupMenu(int x, int y) {
		PopupMenu popupMenu = this.popupMenuView();
		if (popupMenu != null) {
			this.getModel().updateMenuIndication_(this.getModel()._popupMenu());
			popupMenu.show(this, x, y);
		}
	}

	/**
	 * Answer the receiver's scroll amount.
	 * 
	 * @return java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#scrollAmount()
	 * @category scrolling
	 */
	public Point scrollAmount() {
		if (scrollAmount == null) {
			if (this.isShowing()) {
				scrollAmount = new Point((int) this.getBounds().getCenterX(), (int) this.getBounds().getCenterY());
			} else {
				scrollAmount = new Point(0, 0);
			}
		}
		return scrollAmount;
	}

	/**
	 * Set the receiver's scroll amount.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollAmount_(Point aPoint) {
		scrollAmount = aPoint;
	}

	/**
	 * Scroll by the specified point and repaint the receiver.
	 * 
	 * @param aPoint java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView#scrollBy_(java.awt.Point)
	 * @category scrolling
	 */
	public void scrollBy_(Point aPoint) {
		this.scrollAmount_(new Point(this.scrollAmount().x + aPoint.x, this.scrollAmount().y + aPoint.y));
		this.repaint();
	}

	/**
	 * Scroll to the specified point and repaint the receiver.
	 * 
	 * @param aNode java.awt.Point
	 * @category scrolling
	 */
	public void scrollFor_(Point aNode) {
		this.scrollAmount_(new Point(0 - aNode.x / 2 + (int) this.getBounds().getCenterX(), 0 - aNode.y / 2 + (int) this.getBounds().getCenterY()));
		this.repaint();
	}

	/**
	 * Scroll to the specified point and repaint the receiver.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollTo_(Point aPoint) {
		this.scrollAmount_(aPoint);
		this.repaint();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a dependent.
	 * The argument anAspectSymbol is typically a Symbol that indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		StSymbol aspectSymbol = evt.getAspect();
		if (aspectSymbol == $("spiro")) {
			this.displayOn_(this.getGraphics());
			return;
		}
		if (aspectSymbol == $("spiroDesign")) {
			this.repaint();
			return;
		}
		if (aspectSymbol == $("invalidate")) {
			Rectangle aParameter = (Rectangle) evt.getParameter();
			aParameter.translate(this.scrollAmount().x, this.scrollAmount().y);
			this.repaint(0, aParameter.x, aParameter.y, aParameter.width, aParameter.height);
			return;
		}
		super.update_(evt);
	}
}
