package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunPngImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;

/**
 * JunSpiroDesignAnimationThread class
 * 
 *  @author    m-asada
 *  @created   2006/04/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignAnimationThread.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesignAnimationThread extends Thread {
	protected JunSpiroDesign spiroDesign;
	protected JunSpiroDesignView[] spiroDesignViews;
	protected StBlockClosure doBlock;
	protected int status;

	protected static final int STATUS_RUN = 0;
	protected static final int STATUS_SUSPEND = 1;
	protected static final int STATUS_STOP = 2;

	/**
	 * Create a new instance of <code>JunSpiroDesignAnimationThread</code> and initialize it.
	 * 
	 * @param aSpiroDesign jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @param viewCollection jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView[]
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @throws java.lang.IllegalArgumentException
	 * @category Instance creation
	 */
	public JunSpiroDesignAnimationThread(JunSpiroDesign aSpiroDesign, JunSpiroDesignView[] viewCollection, StBlockClosure aBlock) {
		super();
		if (aSpiroDesign == null || viewCollection == null) {
			throw new IllegalArgumentException("aSpiroDesign and viewCollection should not be empty.");
		}
		this.spiroDesign_(aSpiroDesign);
		this.spiroDesignViews_(viewCollection);
		this.doBlock_(aBlock);
	}

	/**
	 * Answer the receiver's do block closure.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public StBlockClosure doBlock() {
		return doBlock;
	}

	/**
	 * Set the receiver's do block closure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void doBlock_(StBlockClosure aBlock) {
		doBlock = aBlock;
	}

	/**
	 * Answer the receiver's spiro design.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category accessing
	 */
	public JunSpiroDesign spiroDesign() {
		return spiroDesign;
	}

	/**
	 * Set the receiver's spiro design.
	 * 
	 * @param aSpiroDesign jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category accessing
	 */
	public void spiroDesign_(JunSpiroDesign aSpiroDesign) {
		spiroDesign = aSpiroDesign;
	}

	/**
	 * Answer the receiver's spiro design views.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView[]
	 * @category accessing
	 */
	public JunSpiroDesignView[] spiroDesignViews() {
		return spiroDesignViews;
	}

	/**
	 * Set the receiver's spiro design views.
	 * 
	 * @param viewCollection jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView[]
	 * @category accessing
	 */
	public void spiroDesignViews_(JunSpiroDesignView[] viewCollection) {
		spiroDesignViews = viewCollection;
	}

	/**
	 * Answer the receiver's status.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * Runs the receiver.
	 * 
	 * @see java.lang.Runnable#run()
	 * @category changing process state
	 */
	public void run() {
		this.animationRun();
	}

	/**
	 * Runs the receiver.
	 * 
	 * @see java.lang.Runnable#run()
	 * @category changing process state
	 */
	public void animationRun() {
		this.beRun();
		this.spiroDesign().animationState_(true);

		final JunSpiroDesign spiroDesign = this.spiroDesign();
		final StBlockClosure aBlock = JunSpiroDesignAnimationThread.this.doBlock();
		final JunSpiroDesignView[] viewCollection = this.spiroDesignViews();
		final boolean alt = StInputState.Default().altDown();
		final boolean shift = StInputState.Default().shiftDown();
		try {
			final File directory = new File(JunFileModel.DefaultDirectory(), spiroDesign.defaultBaseName());
			final StValueHolder indexHolder = new StValueHolder(1);
			if (alt) {
				if (directory.exists() == false) {
					directory.mkdir();
				}
			}
			final Rectangle previous = spiroDesign.bounds();
			spiroDesign.spiroLocusInterim_(new StBlockClosure() {
				public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
					JunSpiroCircle tera = (JunSpiroCircle) obj1;
					JunSpiroCircle moon = (JunSpiroCircle) obj2;
					JunSpiroPen pen = (JunSpiroPen) obj3;

					spiroDesign.animationHolder().value_(new JunSpiroDesign(tera, moon, pen));
					Rectangle current = moon.bounds();
					current.add(pen.mark());
					current.add(tera.mark());

					Rectangle parameter = new Rectangle(previous);
					parameter.add(current);
					for (int i = 0; i < viewCollection.length; i++) {
						viewCollection[i].update_(new DependentEvent(this, $("invalidate"), new Rectangle(parameter)));
					}
					previous.setBounds(current);
					if (aBlock != null) {
						Object anObject = aBlock.value();
						if (anObject != null) {
							throw new AnimationThreadException("the do block closure returned value.");
						}
					}
					if (alt) {
						StImage image = spiroDesign.asImageWithParts();
						if (shift) {
							image = JunImageAdjuster.Adjust_extent_(image, new Dimension(image.width() / 2, image.height() / 2));
						}
						String string = new DecimalFormat("00000000").format(indexHolder._intValue());
						File file = new File(directory, string + ".png");
						JunPngImageStream stream = null;
						JunCursors cursor = new JunCursors(JunCursors.ExecuteCursor());
						try {
							cursor._show();
							stream = (JunPngImageStream) JunPngImageStream.On_(new FileOutputStream(file));
							// stream.quality_(spiroDesign.defaultImageQuality());
							stream.nextPutImage_(image);
						} catch (IOException e) {
							System.err.println(e.getMessage());
							e.printStackTrace();
						} finally {
							if (stream != null) {
								try {
									stream.flush();
									stream.close();
								} catch (IOException e) {
								}
								stream = null;
							}
							cursor._restore();
						}
						indexHolder.value_(indexHolder._intValue() + 1);
					}
					try {
						JunSpiroDesignAnimationThread.this.sleep(spiroDesign.defaultTickTime());
						synchronized (JunSpiroDesignAnimationThread.this) {
							if (JunSpiroDesignAnimationThread.this.isStop()) {
								throw new AnimationThreadException("the animation thread is stopped.");
							}
							while (JunSpiroDesignAnimationThread.this.isSuspend()) {
								JunSpiroDesignAnimationThread.this.wait();
							}
						}
					} catch (InterruptedException e) {
					}
					return null;
				}
			});
			try {
				this.sleep(3000);
			} catch (InterruptedException e) {
			}
		} catch (AnimationThreadException e) {
		} finally {
			this.animationStop();
		}
	}

	/**
	 * Suspends the receiver.
	 * 
	 * @category changing process state
	 */
	public synchronized void animationSuspend() {
		this.beSuspend();
	}

	/**
	 * Resumes the suspended receiver.
	 * 
	 * @category changing process state
	 */
	public synchronized void animationResume() {
		this.beResume();
		this.notify();
	}

	/**
	 * Forces the receiver to stop executing.
	 * 
	 * @category changing process state
	 */
	public synchronized void animationStop() {
		this.beStop();
		this.spiroDesign().animationState_(false);
		this.notify();
	}

	/**
	 * Set the status be RUN.
	 * 
	 * @category setting
	 */
	public void beRun() {
		status = STATUS_RUN;
	}

	/**
	 * Set the status be Suspend.
	 * 
	 * @category setting
	 */
	public void beSuspend() {
		status = STATUS_SUSPEND;
	}

	/**
	 * Set the status be Resume.
	 * 
	 * @category setting
	 */
	public void beResume() {
		status = STATUS_RUN;
	}

	/**
	 * Set the status be Stop.
	 * 
	 * @category setting
	 */
	public void beStop() {
		status = STATUS_STOP;
	}

	/**
	 * Ansert true if the receiver is Run, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isRun() {
		return this.getStatus() == STATUS_RUN;
	}

	/**
	 * Ansert true if the receiver is Suspend, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isSuspend() {
		return this.getStatus() == STATUS_SUSPEND;
	}

	/**
	 * Ansert true if the receiver is Stop, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isStop() {
		return this.getStatus() == STATUS_STOP;
	}

	/**
	 * AnimationThreadException class
	 */
	public class AnimationThreadException extends RuntimeException {
		/**
		 * Create a new instance of <code>AnimationThreadException</code> and initialize it.
		 * 
		 * @param message java.lang.String
		 * @category Instance creation
		 */
		public AnimationThreadException(String message) {
			super(message);
		}
	}
}
