package jp.co.sra.jun.goodies.sound;

import java.awt.Graphics;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunSoundLevelMeterView interface
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/29 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSoundLevelMeterView.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public interface JunSoundLevelMeterView extends JunAbstractView {

	/**
	 * Display on the graphics.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 */
	public void displayOn_(Graphics graphicsContext);

	/**
	 * Display the level value on the graphics context.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param levelValue double[]
	 */
	public void displayOn_levelValue_(Graphics graphicsContext, double[] levelValue);
}
