package jp.co.sra.jun.goodies.soroban;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSorobanTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/03/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun563 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSorobanTestExamples.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSorobanTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSorobanModel aSoroban = new JunSorobanModel();
		aSoroban.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		(new Thread() {
			public void run() {
				JunSorobanModel aSoroban = new JunSorobanModel();
				aSoroban.open();
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}

				aSoroban.value_(123456.789);
				System.out.println(aSoroban.value());
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}

				aSoroban.plus_(7000000);
				System.out.println(aSoroban.value());
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}

				aSoroban.minus_(7123456);
				System.out.println(aSoroban.value());
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}

				aSoroban.resetValue();
				System.out.println(aSoroban.value());
			}
		}).start();

		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		(new Thread() {
			public void run() {
				JunSorobanModel aSoroban = new JunSorobanModel();
				aSoroban.open();
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}
				aSoroban.resetValue();
				for (int i = 1; i <= 1000; i++) {
					aSoroban.value_(i);
					try {
						this.sleep(15);
					} catch (InterruptedException e) {
					}
				}

				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}

				for (int i = 1; i <= 1000; i++) {
					aSoroban.plus_(0.001d);
					try {
						this.sleep(15);
					} catch (InterruptedException e) {
					}
				}
			}
		}).start();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSorobanTestExamples();
	}
}
