package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import java.util.Hashtable;
import jp.co.sra.smalltalk.StReadStream;

/**
 * JunPrologVariable class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/30 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologVariable.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologVariable extends JunPrologString {

	protected static int JunPrologVariableCounter;
	protected static Hashtable JunPrologVariableTable;

	static {
		Initialize();
	}

	/**
	 * Create a new instance of JunPrologVariable and initialize it.
	 *
	 * @param aString java.lang.String
	 */
	private JunPrologVariable(String aString) {
		super(aString);
	}

	/**
	 * Increment the number of variables.
	 */
	public static void CountUp() {
		JunPrologVariableCounter++;
	}

	/**
	 * Install the string as a JunPrologVariable.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologVariable
	 * @param aString java.lang.String
	 */
	public static JunPrologVariable Install_(String aString) {
		JunPrologVariable variable = (JunPrologVariable) JunPrologVariableTable.get(aString);
		if (variable == null) {
			variable = new JunPrologVariable(aString);
			JunPrologVariableTable.put(aString, variable);
		}
		return variable;
	}

	/**
	 * Read a JunPrologSymbol from the stream.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param aStream jp.co.sra.smalltalk.StReadStream
	 */
	public static JunPrologEntity ReadFrom_(StReadStream aStream) {
		boolean[] map = JunPrologCharMap.SymbolMap();
		StringBuffer buffer = new StringBuffer(20);
		char ch = aStream.peek();
		if (ch == '~') {
			aStream.next();
			CountUp();
			return Install_("~" + JunPrologVariableCounter);
		}
		while (ch != 0 && map[ch]) {
			buffer.append(aStream.next());
			ch = aStream.peek();
		}
		return Install_(buffer.toString());
	}

	/**
	 * Set the number of variables to zero.
	 */
	public static void SetZero() {
		JunPrologVariableCounter = 0;
	}

	/**
	 * Initialize the class variables.
	 */
	protected static void Initialize() {
		SetZero();
		JunPrologVariableTable = new Hashtable();
	}

	/**
	 * Answer true if the receiver is a kind of JunPrologVariable, otherwise false.
	 *
	 * @return boolean
	 */
	public boolean isJunPrologVariable() {
		return true;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		if (this.asString().charAt(0) == '~') {
			aWriter.write('~');
		} else {
			aWriter.write(this.asString());
		}
	}
}
