package jp.co.sra.jun.goodies.prolog;

import jp.co.sra.smalltalk.*;

/**
 * JunPrologParserTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/04/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologParserTestExamples.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologParserTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: JunPrologParser new parse: '' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream(""));
		System.out.println(result);
		return (result instanceof StSymbol) && (result == $("eof"));
	}

	/**
	 * Example2: JunPrologParser new parse: '?- remove.' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("?- remove."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{true},remove])");
	}

	/**
	 * Example3: JunPrologParser new parse: 'likes(john,mary).' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("likes(john,mary)."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{false},likes(john,mary)])");
	}

	/**
	 * Example4: JunPrologParser new parse: '?- likes(X,Y).' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("?- likes(X,Y)."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{true},likes(X,Y)])");
	}

	/**
	 * Example5: JunPrologParser new parse: '?- likes(john,X), likes(mary,X).' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("?- likes(john,X), likes(mary,X)."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{true},likes(john,X),likes(mary,X)])");
	}

	/**
	 * Example6: JunPrologParser new parse: 'atom(X) :- nonvar(X), =(X,[]).' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("atom(X) :- nonvar(X), =(X,[])."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{false},atom(X),nonvar(X),=(X,[])])");
	}

	/**
	 * Example7: JunPrologParser new parse: 'userPredicates(X) :- send(self,userPredicates,[],X).' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example7() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("userPredicates(X) :- send(self,userPredicates,[],X)."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{false},userPredicates(X),send(self,userPredicates,[],X)])");
	}

	/**
	 * Example8: JunPrologParser new parse: 'call(G) :- G.' readStream
	 * 
	 * @return boolean
	 */
	public static boolean Example8() {
		JunPrologParser parser = new JunPrologParser();
		Object result = parser.parse_(new StReadStream("call(G) :- G."));
		System.out.println(result);
		return result.toString().equals("JunPrologList([{false},call(G),G])");
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunPrologParserTestExamples();
	}
}
