package jp.co.sra.jun.goodies.prolog;

import java.io.*;

/**
 * JunPrologClause class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologClause.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologClause extends JunPrologList {

	/**
	 * Create a new instance of JunPrologClause and initialize it.
	 *
	 * @param aJunPrologStructure jp.co.sra.jun.goodies.prolog.JunPrologStructure
	 * @param aJunPrologBody jp.co.sra.jun.goodies.prolog.JunPrologBody
	 */
	public JunPrologClause(JunPrologStructure aJunPrologStructure, JunPrologBody aJunPrologBody) {
		this.head_body_(aJunPrologStructure, aJunPrologBody);
	}

	/**
	 * Answer my cdr part as JunPrologBody.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologBody
	 */
	public JunPrologBody body() {
		return (JunPrologBody) cdrPart;
	}

	/**
	 * Set the JunPrologBody as my cdr part.
	 *
	 * @param aJunPrologBody jp.co.sra.jun.goodies.prolog.JunPrologBody
	 */
	public void body_(JunPrologBody aJunPrologBody) {
		cdrPart = aJunPrologBody;
	}

	/**
	 * Answer my car part as JunPrologStructure.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologStructure
	 */
	public JunPrologStructure head() {
		return (JunPrologStructure) carPart;
	}

	/**
	 * Set the aJunPrologStructure as my new car part.
	 *
	 * @param aJunPrologStructure jp.co.sra.jun.goodies.prolog.JunPrologStructure
	 */
	public void head_(JunPrologStructure aJunPrologStructure) {
		carPart = aJunPrologStructure;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		JunPrologStructure head = this.head();
		JunPrologBody body = this.body();
		aWriter.write('(');
		head.printJunPrologOn_(aWriter);
		if (body != null) {
			aWriter.write(", ");
			body.printJunPrologOn_(aWriter);
		}
		aWriter.write(')');
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Print my string representation as a question on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void questionPrintJunPrologOn_(Writer aWriter) throws IOException {
		JunPrologStructure head = this.head();
		JunPrologBody body = this.body();
		aWriter.write("?- ");
		head.printJunPrologOn_(aWriter);
		if (body != null) {
			aWriter.write(", ");
			body.printJunPrologOn_(aWriter);
		}
		aWriter.write('.');
	}

	/**
	 * Create a new instance with the specified arguments.
	 * This method have to be overrided to create a subclass specified instance.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param carEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param cdrEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected JunPrologList _newInstanceWith(JunPrologEntity carEntity, JunPrologEntity cdrEntity) {
		throw new jp.co.sra.smalltalk.SmalltalkException("Do you really need this?");
	}

	/**
	 * Initialize the variables.
	 *
	 * @param aJunPrologStructure jp.co.sra.jun.goodies.prolog.JunPrologStructure
	 * @param aJunPrologBody jp.co.sra.jun.goodies.prolog.JunPrologBody
	 */
	protected void head_body_(JunPrologStructure aJunPrologStructure, JunPrologBody aJunPrologBody) {
		this.head_(aJunPrologStructure);
		this.body_(aJunPrologBody);
	}
}
