package jp.co.sra.jun.goodies.prolog;

import java.io.*;

/**
 * JunPrologBody class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologBody.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologBody extends JunPrologList {

	/**
	 * Create a new instance of JunPrologBody and initialize it.
	 *
	 * @param aJunPrologStructure jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public JunPrologBody(JunPrologEntity aJunPrologStructure, JunPrologEntity link) {
		this.structure_next_(aJunPrologStructure, link);
	}

	/**
	 * Create a new instance of JunPrologBody.
	 */
	protected JunPrologBody() {
		super();
	}

	/**
	 * Create a new instance of JunPrologBody from the list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologBody
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologBody FromList_(JunPrologList aJunPrologDotPair) {
		return FromReverseList_(aJunPrologDotPair.reverse());
	}

	/**
	 * Create a new instance of JunPrologBody from the reverse list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologBody
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologBody FromReverseList_(JunPrologList aJunPrologDotPair) {
		JunPrologEntity list = aJunPrologDotPair;
		JunPrologList mark = null;
		JunPrologBody body = null;
		while (list != null && list.consp()) {
			if (body == null) {
				mark = body = new JunPrologBody(list.car(), body);
			} else {
				body = new JunPrologBody(list.car(), body);
			}
			list = list.cdr();
		}
		mark.cdr_(list);
		return body;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		JunPrologList list = this;
		while (list.cdr() != null && list.cdr().consp()) {
			if (list != this) {
				aWriter.write(", ");
			}
			list.car().printJunPrologOn_(aWriter);
			list = (JunPrologList) list.cdr();
		}
		if (list != this) {
			aWriter.write(", ");
		}
		list.car().printJunPrologOn_(aWriter);
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Create a new instance with the specified arguments.
	 * This method have to be overrided to create a subclass specified instance.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param carEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param cdrEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected JunPrologList _newInstanceWith(JunPrologEntity carEntity, JunPrologEntity cdrEntity) {
		throw new jp.co.sra.smalltalk.SmalltalkException("Do you really need this?");
	}

	/**
	 * Set the structure part and the next part.
	 *
	 * @param aJunPrologStructure jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected void structure_next_(JunPrologEntity aJunPrologStructure, JunPrologEntity link) {
		carPart = aJunPrologStructure;
		cdrPart = link;
	}
}
