package jp.co.sra.jun.goodies.progress;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewPanel;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;

/**
 * JunProgressViewAwt class
 * 
 *  @author    nisinaka
 *  @created   1998/11/18 (by nisinaka)
 *  @updated   2000/03/16 (by Mitsuhiro Asada)
 *  @updated   2003/01/07 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunProgressViewAwt.java,v 8.11 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunProgressViewAwt extends JunAbstractViewCanvas implements JunProgressView {

	/**
	 * Create a new view for the JunProgress.
	 * The view consists of a JunProgressViewAwt and no button.
	 *
	 * @param aProgress jp.co.sra.jun.goodies.progress.JunProgress
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithNoButton_(JunProgress aProgress) {
		return new StViewPanel(aProgress) {
			protected void buildComponent() {
				JunProgress theProgress = (JunProgress) this.model();
				JunProgressViewAwt progressView = new JunProgressViewAwt(theProgress);

				Panel borderedPanel = StApplicationModel._PanelWithBorder();
				borderedPanel.setLayout(new BorderLayout());
				borderedPanel.add(progressView, BorderLayout.CENTER);

				this.setLayout(new BorderLayout());
				this.add(borderedPanel, BorderLayout.CENTER);
			}
		};
	}

	/**
	 * Create a new view for the JunProgress.
	 * The view consists of a JunProgressViewAwt and a stop button.
	 *
	 * @param aProgress jp.co.sra.jun.goodies.progress.JunProgress
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithStopButton_(JunProgress aProgress) {
		return new StViewPanel(aProgress) {
			protected void buildComponent() {
				JunProgress theProgress = (JunProgress) this.model();
				JunProgressViewAwt progressView = new JunProgressViewAwt(theProgress);

				Panel borderedPanel = StApplicationModel._PanelWithBorder();
				borderedPanel.setLayout(new BorderLayout());
				borderedPanel.add(progressView, BorderLayout.CENTER);

				progressView._stopButtonView = new JunButtonViewAwt(theProgress.stopButton(), new Dimension(60, 24));

				Panel buttonPanel = new Panel() {
					public Insets getInsets() {
						return new Insets(10, 10, 10, 10);
					}
				};
				buttonPanel.setLayout(new BorderLayout());
				buttonPanel.add(progressView._stopButtonView, BorderLayout.SOUTH);

				this.setLayout(new BorderLayout());
				this.add(borderedPanel, BorderLayout.CENTER);
				this.add(buttonPanel, BorderLayout.EAST);
			}
		};
	}

	////////////////////////////////////////////////////////////////////////////////

	protected JunButtonViewAwt _stopButtonView;

	/**
	 * Create a new instance of JunProgressViewAwt and initialize it.
	 *
	 * @param newModel jp.co.sra.jun.goodies.progress.JunProgress
	 * @category Instance creation
	 */
	public JunProgressViewAwt(JunProgress newModel) {
		super(newModel);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setSize(226 - 4, 60 - 4);
	}

	/**
	 * Answer my model as JunProgress.
	 * 
	 * @return jp.co.sra.jun.goodies.progress.JunProgress
	 * @category model accessing
	 */
	public JunProgress getProgress() {
		return (JunProgress) this.model();
	}

	/**
	 * Display the receiver using the Graphics.
	 * 
	 * @param graphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics graphics) {
		if (this.isShowing() == false) {
			return;
		}

		this.displayMessageOn_(graphics);
		this.displayScaleOn_(graphics);
		this.displayValueOn_(graphics);
	}

	/**
	 * Display the message using the Graphics.
	 * 
	 * @param graphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayMessageOn_(Graphics graphics) {
		String messageString = this.getProgress().message();
		if (messageString == null) {
			messageString = new String();
		}
		StComposedText composedText = new StComposedText(messageString, MessageFont);
		StRectangle displayRectangle = new StRectangle(composedText.bounds());
		StRectangle scaleRectangle = new StRectangle(0, 0, 200 + 1, displayRectangle.height());
		Dimension bounds = this.getSize();
		StRectangle clippingRectangle = new StRectangle(0, bounds.height / 3 * 0, bounds.width, bounds.height / 3 * 1);
		scaleRectangle = scaleRectangle.align_with_(scaleRectangle.bottomCenter(), clippingRectangle.bottomCenter());
		displayRectangle = displayRectangle.align_with_(displayRectangle.bottomLeft(), scaleRectangle.bottomLeft());
		graphics.setClip(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.clearRect(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.setColor(Color.black);
		composedText.displayOn_at_(graphics, displayRectangle.origin());
	}

	/**
	 * Display the scale using the Graphics.
	 * 
	 * @param graphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayScaleOn_(Graphics graphics) {
		StRectangle displayRectangle = new StRectangle(0, 0, 200 + 1, 10);
		Dimension bounds = this.getSize();
		StRectangle clippingRectangle = new StRectangle(0, bounds.height / 3 * 2, bounds.width, bounds.height);
		displayRectangle = displayRectangle.align_with_(displayRectangle.topCenter(), clippingRectangle.topCenter());
		graphics.setClip(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.clearRect(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.setColor(Color.black);
		int x = displayRectangle.left();
		int y;

		for (int n = 0; n <= 100; n++) {
			if ((n % 5) == 0) {
				if ((n % 10) == 0) {
					if ((n % 50) == 0) {
						y = displayRectangle.y();
						graphics.drawLine(x, y, x, y + 10);
					} else {
						y = displayRectangle.y() + 2;
						graphics.drawLine(x, y, x, y + 6);
					}
				} else {
					if ((n % 25) == 0) {
						y = displayRectangle.y() + 4;
						graphics.drawLine(x, y, x, y + 6);
					} else {
						y = displayRectangle.y() + 4;
						graphics.drawLine(x, y, x, y + 4);
					}
				}
			} else {
				y = displayRectangle.y() + 6;
				graphics.drawLine(x, y, x, y + 2);
			}

			x += 2;
		}
	}

	/**
	 * Display the value using the Graphics.
	 * 
	 * @param graphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayValueOn_(Graphics graphics) {
		float progressValue = this.getProgress().value();
		StRectangle gaugeRectangle = new StRectangle(0, 0, 6, 12);
		StRectangle displayRectangle = new StRectangle(0, 0, 200 + 1, 10);
		Dimension bounds = this.getSize();
		StRectangle clippingRectangle = new StRectangle(0, bounds.height / 3, bounds.width, bounds.height / 3 * 2);
		displayRectangle = displayRectangle.align_with_(displayRectangle.bottomCenter(), clippingRectangle.bottomCenter());
		gaugeRectangle = gaugeRectangle.align_with_(gaugeRectangle.bottomCenter(), displayRectangle.bottomLeft());
		gaugeRectangle = gaugeRectangle.translatedBy_((int) (progressValue * 200), -1);

		Polygon polygon = new Polygon();
		Point aPoint = gaugeRectangle.topCenter();
		polygon.addPoint(aPoint.x, aPoint.y);
		aPoint = gaugeRectangle.rightCenter();
		polygon.addPoint(aPoint.x, aPoint.y);
		aPoint = gaugeRectangle.bottomCenter();
		polygon.addPoint(aPoint.x, aPoint.y);
		aPoint = gaugeRectangle.leftCenter();
		polygon.addPoint(aPoint.x, aPoint.y);
		aPoint = gaugeRectangle.topCenter();
		polygon.addPoint(aPoint.x, aPoint.y);

		graphics.setClip(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.clearRect(clippingRectangle.x(), clippingRectangle.y(), clippingRectangle.width(), clippingRectangle.height());
		graphics.setColor(Color.gray);
		graphics.fillPolygon(polygon);
		graphics.setColor(Color.black);
		graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @category updating
	 */
	public synchronized void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		if (this.topComponent() != null) {
			if (this.getProgress().raisingFlag()) {
				this.topComponent().toFront();
			}
		}

		if (this.isShowing()) {
			if (evt.getAspect() == $("value") || evt.getAspect() == $("message")) {
				this.repaint();
			}
		}
	}

}
