package jp.co.sra.jun.goodies.progress;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunProgressTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/11/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunProgressTestExamples.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunProgressTestExamples extends JunTestExamples {

	/**
	 * Example: 
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunProgress aProgress = new JunProgress();
		aProgress.message_("abc");
		aProgress.openWithStopButton_(true);

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		final int size = 100;
		JunProgress aProgress = new JunProgress();
		aProgress.do_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunProgress progress = (JunProgress) anObject;
				for (int count = 1; count <= size; count++) {
					float value = (float) count / size;
					progress.message_(String.valueOf(value));
					progress.value_(value);
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
					}
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		final int size = 100;
		JunProgress aProgress = new JunProgress();
		aProgress.doWithStopButton_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunProgress progress = (JunProgress) anObject;
				for (int count = 1; count <= size; count++) {
					float value = (float) count / size;
					progress.message_(String.valueOf(value));
					progress.value_(value);
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
					}
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		final int size = 100;
		JunProgress aProgress = new JunProgress();
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				JunProgress progress = (JunProgress) anObject;
				for (int count = 1; count <= size; count++) {
					float value = (float) count / size;
					if (progress.hasStopButton()) {
						value = 1 - value;
					}
					progress.message_(String.valueOf(value));
					progress.value_(value);
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
					}
				}
				return null;
			}
		};

		aProgress.do_(aBlock);
		aProgress.doWithStopButton_(aBlock);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunProgressTestExamples();
	}
}
