package jp.co.sra.jun.goodies.nib;

import java.awt.Dialog;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunNibChoiceWithColorDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/26 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceWithColorDialog.java,v 8.12 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceWithColorDialog extends JunNibChoiceDialog {

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request() {
		return Request(JunSystem.$String("Nib Choice Dialog"));
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @return java.lang.Object
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request(String messageString) {
		return Request(messageString, new JunNibChoiceWithColor());
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param aNibChoiceModel jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunNibChoiceWithColor aNibChoiceModel) {
		return Request(messageString, aNibChoiceModel, null, null);
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param aNibChoiceModel jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunNibChoiceWithColor aNibChoiceModel, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunNibChoiceWithColorDialog nibChoiceDialog = new JunNibChoiceWithColorDialog();
		if (aNibChoiceModel != null) {
			nibChoiceDialog.nibChoiceWithColorModel_(aNibChoiceModel);
		}
		Dialog dialog = nibChoiceDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			nibChoiceDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			nibChoiceDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (nibChoiceDialog.accept()._booleanValue()) {
			return nibChoiceDialog.nibChoiceWithColorModel().value();
		} else {
			return null;
		}
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param valueArray java.lang.Object[]
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, Object[] valueArray) {
		return JunNibChoiceWithColorDialog.Request(messageString, new JunNibChoiceWithColor(valueArray), null, null);
	}

	/**
	 * Answer my current nib choice model.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @see jp.co.sra.jun.goodies.nib.JunNibChoiceDialog#nibChoiceModel()
	 */
	public JunNibChoice nibChoiceModel() {
		if (nibChoiceModel == null) {
			nibChoiceModel = new JunNibChoiceWithColor();
		}
		return nibChoiceModel;
	}

	/**
	 * Answer the current nib choice with color model.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor
	 * @category accessing
	 */
	public JunNibChoiceWithColor nibChoiceWithColorModel() {
		return (JunNibChoiceWithColor) this.nibChoiceModel();
	}

	/**
	 * Set new nib choice with color model.
	 * 
	 * @param aNibChoiceModel jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor
	 * @category accessing
	 */
	public void nibChoiceWithColorModel_(JunNibChoiceWithColor aNibChoiceModel) {
		super.nibChoiceModel_(aNibChoiceModel);
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunNibChoiceWithColorDialogViewAwt(this);
		} else {
			return new JunNibChoiceWithColorDialogViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Nib Choice Dialog");
	}
}
