package jp.co.sra.jun.goodies.nib;

import java.awt.Color;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.colors.JunColorChoiceSBH;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunNibChoiceWithColor class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/26 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun538 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceWithColor.java,v 8.11 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceWithColor extends JunNibChoice {
	protected JunColorChoiceModel colorModel;

	/**
	 * Create a new instance of JunNibChoiceWithColor.
	 * 
	 * @category Instance creation
	 */
	public JunNibChoiceWithColor() {
		super();
	}

	/**
	 * Create an instance of JunNibChoiceWithColor.
	 * 
	 * @param valueArray Object[]
	 * @category Instance creation
	 */
	public JunNibChoiceWithColor(Object[] valueArray) {
		this.value_(valueArray);
	}

	/**
	 * Create an instance of JunNibChoice.
	 * 
	 * @param aCollection double[]
	 * @category Instance creation
	 */
	public JunNibChoiceWithColor(double[] aCollection) {
		this.nibCollection_(aCollection);
	}

	/**
	 * Create an instance of JunNibChoice.
	 * 
	 * @param aCollection double[]
	 * @param nibWidth double
	 * @param nibColor java.awt.Color
	 * @param nibShape jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public JunNibChoiceWithColor(double[] aCollection, double nibWidth, Color nibColor, StSymbol nibShape) {
		this.value_(new Object[] { aCollection, new Double(nibWidth), nibColor, nibShape });
	}

	/**
	 * Initializing.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		colorModel = null;
	}

	/**
	 * Answer the color model.
	 * 
	 * @return jp.co.sra.jun.goodies.color.JunColorChoiceModel
	 * @category accessing
	 */
	public JunColorChoiceModel colorModel() {
		if (colorModel == null) {
			colorModel = new JunColorChoiceSBH();
			colorModel.color_(this.nibColor());
			colorModel.compute_(new StBlockClosure() {
				public Object value() {
					JunNibChoiceWithColor.this.nibColor_(colorModel.color());
					return Boolean.TRUE;
				}
			});
		}
		return colorModel;
	}

	/**
	 * Set my new nib color.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.goodies.nib.JunNibChoice#nibColor_(java.awt.Color)
	 * @category accessing
	 */
	public void nibColor_(Color aColor) {
		if (this.colorModel().color().equals(aColor) == false) {
			this.colorModel().color_(aColor);
		}
		super.nibColor_(aColor);
	}

	/**
	 * Set the receiver's new nib width and nib color.
	 * 
	 * @param aNumber double
	 * @param colorValue java.awt.Color
	 * @see jp.co.sra.jun.goodies.nib.JunNibChoice#nibWidth_nibColor_(double, java.awt.Color)
	 * @category accessing
	 */
	public void nibWidth_nibColor_(double aNumber, Color colorValue) {
		super.nibWidth_nibColor_(aNumber, colorValue);
		if (this.colorModel().color().equals(colorValue) == false) {
			this.colorModel().color_(colorValue);
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunNibChoiceWithColorViewAwt(this);
		} else {
			return new JunNibChoiceWithColorViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Nib Choice");
	}
}
