package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;
import java.awt.Window;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.files.JunFileViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunMultiMediaViewerViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/03/20 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun526 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaViewerViewSwing.java,v 8.10 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaViewerViewSwing extends JunAbstractViewJPanel implements JunMultiMediaViewerView {

	protected JunFileViewSwing fileView;
	protected JunMultiMediaImageViewSwing imageView;
	protected JunMultiMediaMovieViewSwing movieView;
	protected JunMultiMediaTextViewSwing textView;
	protected JunMultiMediaExtraViewSwing extraView;

	/**
	 * Create a new instance of JunMultiMediaViewerViewSwing and initialize it.
	 *
	 * @param aMultiMediaViewer jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewer
	 * @category Instance creation
	 */
	public JunMultiMediaViewerViewSwing(JunMultiMediaViewer aMultiMediaViewer) {
		super(aMultiMediaViewer);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 290));
		this.add(this.imageView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.movieView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.textView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.extraView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.setPreferredSize(new Dimension(480, 580));
	}

	/**
	 * Answer my model as JunMultiMediaViewer.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewer
	 * @category model accessing
	 */
	public JunMultiMediaViewer getMultiMediaViewer() {
		return (JunMultiMediaViewer) this.model();
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileViewSwing
	 * @category user interface
	 */
	public JunFileViewSwing fileView() {
		if (fileView == null) {
			fileView = new JunFileViewSwing(this.getMultiMediaViewer().fileModel());
		}
		return fileView;
	}

	/**
	 * Answer my image view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewSwing
	 * @category user interface
	 */
	public JunMultiMediaImageViewSwing imageView() {
		if (imageView == null) {
			imageView = new JunMultiMediaImageViewSwing(this.getMultiMediaViewer().imageModel());
			imageView.setVisible(false);
		}
		return imageView;
	}

	/**
	 * Answer my movie view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewSwing
	 * @category user interface
	 */
	public JunMultiMediaMovieViewSwing movieView() {
		if (movieView == null) {
			movieView = new JunMultiMediaMovieViewSwing(this.getMultiMediaViewer().movieModel());
			movieView.setVisible(false);
		}
		return movieView;
	}

	/**
	 * Answer my text view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewSwing
	 * @category user interface
	 */
	public JunMultiMediaTextViewSwing textView() {
		if (textView == null) {
			textView = new JunMultiMediaTextViewSwing(this.getMultiMediaViewer().textModel());
			textView.setVisible(false);
		}
		return textView;
	}

	/**
	 * Answer my extra view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraViewAwt
	 * @category user interface
	 */
	public JunMultiMediaExtraViewSwing extraView() {
		if (extraView == null) {
			extraView = new JunMultiMediaExtraViewSwing(this.getMultiMediaViewer().extraModel());
			extraView.setVisible(false);
		}
		return extraView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.movieView().getMovieView()._setupKeyboard(aWindow);
	}

}
